/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DBConnection {
    private static Logger logger = Logger.getLogger((String)DBConnection.class.getName());
    public static final int POSTGRESQL = 1;
    public static final int HSQLDB = 2;
    protected Connection connection = null;
    protected String message = "";
    protected String origin = "";
    protected Date openDate = null;
    protected boolean status = false;
    protected boolean closed = false;
    private static int n = -1;
    private String dbName = null;
    public int dbType = 0;
    public String tableType = "";
    public String boolType = "";
    public String startTransaction = "SET AUTOCOMMIT TO OFF";
    public String endTransaction = "SET AUTOCOMMIT TO ON";
    public String rollbackTransaction = "ROLLBACK";
    private static Hashtable connectionHash = new Hashtable();

    public static void setLogger(Logger l) {
        logger = l;
    }

    private void initSQLparams(String name) {
        if (name.indexOf("hsqldb") != -1) {
            this.dbName = this.dbName + " : HSQLDB";
            this.dbType = 2;
            this.tableType = "CACHED";
            this.boolType = "BOOLEAN";
            this.startTransaction = "SET AUTOCOMMIT FALSE";
            this.endTransaction = "SET AUTOCOMMIT TRUE";
            this.rollbackTransaction = "ROLLBACK";
        } else {
            this.dbType = 1;
            this.dbName = this.dbName + " : POSTGRESQL";
            this.tableType = "";
            this.boolType = "BOOL";
            this.startTransaction = "START TRANSACTION";
            this.endTransaction = "COMMIT";
            this.rollbackTransaction = "ROLLBACK";
        }
    }

    public DBConnection(String dbname) {
        this(dbname, null, null, null);
    }

    public DBConnection(String dbname, String origin) {
        this(dbname, null, null, origin);
    }

    public DBConnection(String dbname, String user, String passwd) {
        this(dbname, user, passwd, null);
    }

    public DBConnection(String dbname, String user, String passwd, String origin) {
        ++n;
        this.origin = origin;
        this.dbName = dbname;
        this.openDate = new Date();
        if (dbname.startsWith("java:comp/env")) {
            block25: {
                try {
                    InitialContext ctx = new InitialContext();
                    if (ctx == null) {
                        throw new NullPointerException("DB:constr for " + dbname + ", No InitialContext found");
                    }
                    DataSource ds = (DataSource)ctx.lookup(dbname);
                    if (ds != null) {
                        try {
                            Vector<DBConnection> cv = (Vector<DBConnection>)connectionHash.get(dbname);
                            if (cv == null) {
                                cv = new Vector<DBConnection>();
                                connectionHash.put(dbname, cv);
                            }
                            this.connection = ds.getConnection();
                            String dburl = this.connection.getMetaData().getURL();
                            logger.debug((Object)("DBConnection:constr: user: " + user + " JDNI DB name: " + dbname + " JDBC URL=" + dburl + " why: " + origin + " opened: " + this.openDate.getTime()));
                            this.dbName = this.dbName + " -> " + dburl;
                            this.initSQLparams(dburl);
                            cv.add(this);
                            this.status = true;
                            break block25;
                        }
                        catch (SQLException sqle) {
                            logger.error((Object)("DBConnection:constr: SQL error for " + dbname + "[" + n + "] Error creating connection maybe driver missing?: " + sqle));
                            this.message = this.message + "DBConnection:constr: SQL error for " + dbname + "[" + n + "] Error creating connection, maybe driver missing?: " + sqle;
                            return;
                        }
                        catch (Exception e) {
                            logger.error((Object)("DBConnection:constr: Exception for " + dbname + "[" + n + "] Unexpected error: " + e));
                            this.message = this.message + "DBConnection:constr: Exception for " + dbname + "[" + n + "]\n" + e;
                            return;
                        }
                    }
                    logger.info((Object)("DBConnection:constr: No DataSource? " + dbname));
                }
                catch (Exception e) {
                    logger.error((Object)("DBConnection:constr: Exception: " + e.getMessage()));
                }
            }
            return;
        }
        logger.debug((Object)("DBConnection:constr: user: " + user + " JDBC URL: " + dbname + " why: " + origin + " opened: " + this.openDate.getTime()));
        this.initSQLparams(dbname);
        if (dbname.startsWith("jdbc:hsqldb")) {
            if (user == null) {
                user = "sa";
            }
            if (passwd == null) {
                passwd = "";
            }
            try {
                Class<?> cl = Class.forName("org.hsqldb.jdbcDriver");
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"DBConnection:constr: driver not found: org.hsqldb.jdbcDriver");
                this.status = false;
                return;
            }
            try {
                this.connection = DriverManager.getConnection(dbname, user, passwd);
                Vector<DBConnection> cv = null;
                cv = (Vector<DBConnection>)connectionHash.get(dbname);
                if (cv == null) {
                    cv = new Vector<DBConnection>();
                    connectionHash.put(dbname, cv);
                }
                cv.add(this);
                this.status = true;
            }
            catch (Exception e) {
                logger.error((Object)("DBConnection:constr: HSQLDB connection create failed, error: " + e));
                this.status = false;
                return;
            }
        }
        if (dbname.startsWith("jdbc:postgresql")) {
            if (user == null) {
                user = "imdiArchive";
            }
            if (passwd == null) {
                passwd = "";
            }
            try {
                Class<?> cl = Class.forName("org.postgresql.Driver");
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"DBConnection:constr: driver not found: org.postgresql.Driver");
                this.status = false;
                return;
            }
            try {
                this.connection = DriverManager.getConnection(dbname, user, passwd);
                Vector<DBConnection> cv = null;
                cv = (Vector<DBConnection>)connectionHash.get(dbname);
                if (cv == null) {
                    cv = new Vector<DBConnection>();
                    connectionHash.put(dbname, cv);
                }
                cv.add(this);
                this.status = true;
            }
            catch (Exception e) {
                logger.error((Object)("DBConnection:constr: connection create failed for " + dbname + " error: " + e), (Throwable)e);
                this.status = false;
                return;
            }
        }
        logger.error((Object)("DBConnection:constr: Invalid DB specification: " + dbname), (Throwable)new Exception("tracing"));
        this.status = false;
        return;
    }

    public synchronized void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
                logger.debug((Object)("DBConnection:free: " + this.dbName + "[" + n + "] closed. why: " + this.origin + " opened: " + this.openDate.getTime()));
            } else {
                logger.warn((Object)("DBConnection:free: " + this.dbName + "[" + n + "] connection already null. why: " + this.origin + " opened: " + this.openDate.getTime()));
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("DBConnection:free: " + this.dbName + "[" + n + "] SQLException: " + sqle));
        }
        catch (Exception e) {
            logger.error((Object)("DBConnection:free: " + this.dbName + "[" + n + "] Exception: " + e.getMessage()));
        }
        this.closed = true;
        this.connection = null;
        this.status = false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean getStatus() {
        block5: {
            try {
                if (this.closed) {
                    logger.warn((Object)("DBConnection:getStatus: connection closed by user: " + this.dbName + "[" + n + "]"));
                    break block5;
                }
                if (this.connection == null) {
                    logger.warn((Object)("DBConnection:getStatus: connection was not created: " + this.dbName + "[" + n + "]"));
                    break block5;
                }
                if (this.connection.isClosed()) {
                    logger.warn((Object)("DBConnection:getStatus: connection was closed by system: " + this.dbName + "[" + n + "]"));
                    break block5;
                }
                return true;
            }
            catch (SQLException sqle) {
                logger.error((Object)("DBConnection: " + this.dbName + "[" + n + "] SQL Exception: " + sqle));
            }
        }
        this.status = false;
        return this.status;
    }

    public String toString() {
        return this.dbName;
    }

    public String getMessage() {
        return this.message;
    }

    public static synchronized void closeAll() {
        Enumeration dbnames = connectionHash.keys();
        while (dbnames.hasMoreElements()) {
            Object key = dbnames.nextElement();
            Vector cv = (Vector)connectionHash.get(key);
            if (cv == null) continue;
            for (int i = 0; i < cv.size(); ++i) {
                try {
                    Connection con;
                    DBConnection dbcon = (DBConnection)cv.get(i);
                    if (dbcon == null || (con = dbcon.getConnection()) == null) continue;
                    con.close();
                    continue;
                }
                catch (SQLException sqle) {
                    logger.error((Object)("DBConnection:closeALL[" + n + "] SQL Exception: " + sqle), (Throwable)sqle);
                }
            }
        }
    }

    public static void report(PrintWriter out) {
        Enumeration dbnames = connectionHash.keys();
        while (dbnames.hasMoreElements()) {
            Object key = dbnames.nextElement();
            Vector cv = (Vector)connectionHash.get(key);
            for (int i = 0; i < cv.size(); ++i) {
                DBConnection db = null;
                String message = "";
                message = key + " " + i;
                try {
                    db = (DBConnection)cv.get(i);
                    if (db.closed) continue;
                    if (db.getConnection() != null) {
                        boolean open;
                        boolean bl = open = !db.getConnection().isClosed();
                        message = open ? message + ": open" : message + ": closed by system";
                    } else {
                        message = message + ": ERROR " + db.getMessage();
                    }
                    message = message + ", status: " + ((DBConnection)cv.get(i)).getStatus();
                    message = message + ", origin/why: " + ((DBConnection)cv.get((int)i)).origin;
                    message = message + ", opened: " + ((DBConnection)cv.get((int)i)).openDate.getTime();
                }
                catch (SQLException sqle) {
                    message = message + " error: " + sqle;
                }
                if (db.closed) continue;
                out.println(message);
            }
        }
    }
}

