/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class DefaultFileFilter
extends FileFilter {
    private final String description;
    private final String[] extensions;

    public DefaultFileFilter(String extension) {
        this(extension, "*." + extension);
    }

    public DefaultFileFilter(String[] extensions) {
        this.extensions = extensions;
        StringBuffer d = new StringBuffer("*." + extensions[0]);
        for (int i = 1; i < extensions.length; ++i) {
            d.append(", *." + extensions[i]);
        }
        this.description = d.toString();
    }

    public DefaultFileFilter(String extension, String description) {
        this.extensions = new String[]{extension};
        this.description = description;
    }

    public DefaultFileFilter(String[] extensions, String description) {
        this.extensions = extensions;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName().toLowerCase();
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!name.endsWith(this.extensions[i])) continue;
            return true;
        }
        return false;
    }
}

