/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

public class MimeType {
    private String _type;
    private String _format;
    private boolean _status;
    private String _compression = null;

    public MimeType(String type, String format) {
        this._type = type;
        this._format = format;
        this._status = true;
    }

    public MimeType(String mimetype) {
        int idx = mimetype.indexOf(47);
        if (idx < 0) {
            this._status = false;
        } else {
            this._type = mimetype.substring(0, idx);
            this._format = mimetype.substring(idx + 1);
            this._status = true;
        }
    }

    public static String getMimeTypeStringFromExtension(String name) {
        if (name.endsWith(".xml") || name.endsWith(".xsd")) {
            return "text/xml";
        }
        if (name.endsWith(".imdi")) {
            return "text/x-imdi+xml";
        }
        if (name.endsWith(".html") || name.endsWith(".htm")) {
            return "text/html";
        }
        if (name.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (name.endsWith(".txt")) {
            return "text/plain";
        }
        if (name.endsWith(".cha")) {
            return "text/x-chat";
        }
        if (name.endsWith(".sht")) {
            return "text/x-shoebox-text";
        }
        if (name.endsWith(".eaf")) {
            return "text/x-eaf+xml";
        }
        if (name.endsWith(".wav")) {
            return "audio/x-wav";
        }
        if (name.endsWith(".m4a")) {
            return "audio/mp4";
        }
        if (name.endsWith(".aiff")) {
            return "audio/x-aiff";
        }
        if (name.endsWith(".aifc")) {
            return "audio/x-aiff";
        }
        if (name.endsWith(".mpg")) {
            return "video/x-mpeg1";
        }
        if (name.endsWith(".mpeg")) {
            return "video/x-mpeg2";
        }
        if (name.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (name.endsWith(".mov")) {
            return "video/quicktime";
        }
        if (name.endsWith(".smil")) {
            return "application/smil+xml";
        }
        if (name.endsWith(".gif")) {
            return "image/gif";
        }
        if (name.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        if (name.endsWith(".tiff")) {
            return "image/tiff";
        }
        if (name.startsWith("http:") && (name.indexOf(".php") != -1 || name.indexOf(".") == -1)) {
            return "text/x-imdi+xml";
        }
        return "Unknown";
    }

    public static MimeType getMimeTypeFromExtension(String name) {
        MimeType mt = new MimeType(MimeType.getMimeTypeStringFromExtension(name));
        if (mt.status()) {
            return mt;
        }
        return null;
    }

    public static boolean matches(String type1, String type2) {
        String t1 = type1;
        String t2 = type2;
        if (type1.endsWith("*") && type2.endsWith("*")) {
            t1 = type1.substring(0, type1.length() - 1);
            t2 = type2.substring(0, type2.length() - 1);
            if (t2.startsWith(t1) || t1.startsWith(t2)) {
                return true;
            }
        } else if (type1.endsWith("*")) {
            t1 = type1.substring(0, type1.length() - 1);
            if (t2.startsWith(t1)) {
                return true;
            }
        } else if (type2.endsWith("*")) {
            t2 = type2.substring(0, type2.length() - 1);
            if (t1.startsWith(t2)) {
                return true;
            }
        } else {
            if (t1.equals(t2)) {
                return true;
            }
            if (t1.indexOf(47) != -1 && t2.indexOf(47) != -1 && t1.substring(0, t1.indexOf(47)).equalsIgnoreCase(t2.substring(0, t2.indexOf(47)))) {
                String f1 = t1.substring(t1.indexOf(47) + 1).toLowerCase();
                String f2 = t2.substring(t2.indexOf(47) + 1).toLowerCase();
                if (f1.length() < f2.length() ? f2.indexOf(f1) > -1 : f2.length() < f1.length() && f1.indexOf(f2) > -1) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean status() {
        return this._status;
    }

    public String toString() {
        if (this._compression != null && !this._compression.equalsIgnoreCase("None")) {
            return this._type + "/" + this._format + " - " + this._compression;
        }
        return this._type + "/" + this._format;
    }

    public String getType() {
        return this._type;
    }

    public String getFormat() {
        return this._format;
    }

    public String getCompression() {
        return this._compression;
    }

    public void setCompression(String compr) {
        this._compression = compr;
    }

    public boolean equals(String t) {
        if (this._compression != null && !this._compression.equalsIgnoreCase("None")) {
            return false;
        }
        return this.toString().equalsIgnoreCase(t);
    }

    public boolean matches(String t) {
        if (this._compression != null && !this._compression.equalsIgnoreCase("None")) {
            return false;
        }
        if (t.endsWith("*")) {
            return this.toString().regionMatches(0, t, 0, t.length() - 1);
        }
        return this.toString().equals(t);
    }
}

