/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import nl.mpi.util.CVEntry;
import nl.mpi.util.DescriptedObject;
import nl.mpi.util.gui.DescriptedObjectListCellRenderer;
import nl.mpi.util.gui.RestrictedComboBoxEditor;
import nl.mpi.util.gui.SteppedComboBox;

public class SplittedExplicativeJComboBoxPanel
extends JPanel
implements ItemListener {
    private final HashMap hash;
    private final JComboBox categoryComboBox = new JComboBox();
    private final char splitChar;
    private ComboBoxEditor comboBoxEditor;
    private JComboBox itemComboBox;
    private SteppedComboBox featureComboBox = null;
    private boolean itemBoxEditable;

    public SplittedExplicativeJComboBoxPanel(List items, char splitChar) {
        this(items, splitChar, 50);
    }

    public SplittedExplicativeJComboBoxPanel(List items, char splitChar, int limit) {
        Set set;
        this.splitChar = splitChar;
        this.setLayout(new BorderLayout());
        this.hash = SplittedExplicativeJComboBoxPanel.splitItems(items, splitChar);
        if (this.hash.size() == items.size()) {
            set = new HashSet(items);
        } else {
            for (Object key : this.hash.keySet()) {
                Vector vector = (Vector)this.hash.get(key);
                if (vector.size() <= 2) continue;
                vector.insertElementAt(new EmptyDescriptedObject("All Elements", key.toString() + "(*)"), 0);
            }
            SplittedExplicativeJComboBoxPanel.setVectorSizeLimit(this.hash, limit);
            set = (Set)new HashSet(this.hash.keySet()).clone();
        }
        while (set.size() > 0) {
            Iterator<Object> it = set.iterator();
            Object object1 = it.next();
            while (it.hasNext()) {
                Object object2 = it.next();
                if (object1.toString().compareTo(object2.toString()) <= 0) continue;
                object1 = object2;
            }
            this.categoryComboBox.addItem(object1);
            set.remove(object1);
        }
        if (this.categoryComboBox.getItemCount() > 0) {
            this.categoryComboBox.setSelectedIndex(0);
        } else {
            this.categoryComboBox.setEnabled(false);
        }
        this.categoryComboBox.setMaximumRowCount(15);
        if (this.hash.size() != items.size()) {
            this.featureComboBox = new SteppedComboBox();
            this.updateFeatureComboBox();
            this.add((Component)this.categoryComboBox, "West");
            this.featureComboBox.setMaximumRowCount(15);
            this.categoryComboBox.addItemListener(this);
            ToolTipManager.sharedInstance().registerComponent(this.featureComboBox);
            this.comboBoxEditor = new RestrictedComboBoxEditor(splitChar, ',', ')', '*');
            this.featureComboBox.setEditor(this.comboBoxEditor);
            this.featureComboBox.setRenderer(new MyListCellRenderer('('));
            this.itemComboBox = this.featureComboBox;
        } else {
            this.categoryComboBox.setRenderer(new DescriptedObjectListCellRenderer());
            this.itemComboBox = this.categoryComboBox;
        }
        this.add((Component)this.itemComboBox, "Center");
        if (this.itemBoxEditable) {
            this.itemComboBox.setToolTipText("Enable editing with right mouse key");
        }
        this.itemComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (SplittedExplicativeJComboBoxPanel.this.itemBoxEditable && ie.getStateChange() == 1 && SplittedExplicativeJComboBoxPanel.this.itemComboBox.getSelectedIndex() != -1) {
                    SplittedExplicativeJComboBoxPanel.this.itemComboBox.setEditable(false);
                    SplittedExplicativeJComboBoxPanel.this.itemComboBox.setToolTipText("Enable editing with right mouse key");
                }
            }
        });
        this.itemComboBox.getComponent(0).addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                System.out.println(me);
                if (SplittedExplicativeJComboBoxPanel.this.itemBoxEditable && me.getModifiers() == 4) {
                    SplittedExplicativeJComboBoxPanel.this.itemComboBox.setEditable(true);
                    SplittedExplicativeJComboBoxPanel.this.itemComboBox.setToolTipText("Use DELETE key to change entry");
                }
            }
        });
    }

    public void setEditable(boolean b) {
        this.itemBoxEditable = b;
    }

    public void setSelectedItem(Object o) {
        if (this.featureComboBox == null) {
            for (int i = 0; i < this.categoryComboBox.getItemCount(); ++i) {
                if (!this.categoryComboBox.getItemAt(i).toString().equals(o.toString())) continue;
                this.categoryComboBox.setSelectedIndex(i);
                break;
            }
        } else {
            String s = o.toString();
            int catIndex = s.indexOf(this.splitChar);
            if (catIndex == -1) {
                System.out.println("String " + s + " not found!");
                return;
            }
            for (int i = 0; i < this.categoryComboBox.getItemCount(); ++i) {
                if (!this.categoryComboBox.getItemAt(i).toString().startsWith(s.substring(0, catIndex))) continue;
                this.categoryComboBox.setSelectedIndex(i);
                this.updateFeatureComboBox();
                if (s.indexOf(42) == -1) {
                    for (int j = 0; j < this.featureComboBox.getItemCount(); ++j) {
                        if (!this.featureComboBox.getItemAt(j).toString().endsWith(s.substring(catIndex))) continue;
                        this.featureComboBox.setSelectedIndex(j);
                        return;
                    }
                    continue;
                }
                this.featureComboBox.setEditable(true);
                this.featureComboBox.setSelectedIndex(-1);
                int leftBracket = s.indexOf(91);
                int rightBracket = s.indexOf(93);
                if (leftBracket == -1 || rightBracket == -1) {
                    this.comboBoxEditor.setItem(o);
                } else {
                    this.comboBoxEditor.setItem(s.substring(0, leftBracket) + s.substring(rightBracket + 1));
                }
                return;
            }
        }
    }

    public Object getSelectedItem() {
        return this.featureComboBox != null && this.featureComboBox.getSelectedIndex() == -1 ? this.comboBoxEditor.getItem() : this.itemComboBox.getSelectedItem();
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.updateFeatureComboBox();
        }
    }

    private static void setVectorSizeLimit(HashMap hash, int limit) {
        for (Object key : (Set)new HashSet(hash.keySet()).clone()) {
            Vector vector = (Vector)hash.get(key);
            float frac = (float)vector.size() / (float)limit;
            if (!(frac > 1.0f)) continue;
            int alimit = (int)((double)((float)vector.size() / (float)((int)((double)frac + 0.99999))) + 0.99999);
            hash.remove(key);
            String previousFirst = "";
            int i = 0;
            while ((float)i < frac) {
                int end = alimit * (i + 1) < vector.size() ? alimit * (i + 1) : vector.size();
                Vector localVector = new Vector(vector.subList(alimit * i, end));
                String first = localVector.firstElement().toString();
                String last = localVector.lastElement().toString();
                if (i > 0) {
                    int diff = 1;
                    while (first.substring(0, diff).equals(previousFirst.substring(0, diff))) {
                        ++diff;
                    }
                    Object subKey = first.substring(0, diff) + "-" + last.substring(diff - 1, diff);
                    if (key instanceof CVEntry) {
                        subKey = new CVEntry((String)subKey, ((CVEntry)key).getDescription());
                    }
                    hash.put(subKey, localVector);
                } else {
                    hash.put(key, localVector);
                }
                previousFirst = first;
                ++i;
            }
        }
    }

    private static HashMap splitItems(List items, char splitChar) {
        Vector vector;
        int i;
        HashMap hash = new HashMap();
        Vector nonSplit = new Vector();
        for (i = 0; i < items.size(); ++i) {
            String cat = items.get(i).toString();
            int splitIndex = cat.indexOf(splitChar);
            if (splitIndex >= 0) {
                if (hash.containsKey(cat = cat.substring(0, splitIndex))) {
                    ((Vector)hash.get(cat)).add(items.get(i));
                    continue;
                }
                vector = new Vector();
                vector.add(items.get(i));
                hash.put(cat, vector);
                continue;
            }
            nonSplit.add(items.get(i));
        }
        for (i = 0; i < nonSplit.size(); ++i) {
            Object key = nonSplit.elementAt(i);
            String keyString = key.toString();
            if (hash.containsKey(keyString)) {
                Object value = hash.get(keyString);
                hash.remove(keyString);
                hash.put((String)key, value);
                continue;
            }
            vector = new Vector();
            vector.add(key);
            hash.put((String)key, vector);
        }
        return hash;
    }

    private void updateFeatureComboBox() {
        if (this.featureComboBox.getItemCount() > 0) {
            this.featureComboBox.removeAllItems();
        }
        Vector vector = (Vector)this.hash.get(this.categoryComboBox.getSelectedItem());
        for (int i = 0; i < vector.size(); ++i) {
            this.featureComboBox.addItem(vector.elementAt(i));
        }
        this.featureComboBox.setPopupWidth(this.featureComboBox.getPreferredSize().width);
    }

    private class EmptyDescriptedObject
    implements DescriptedObject {
        private final String description;
        private final String string;

        public EmptyDescriptedObject(String description, String string) {
            this.string = string;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.string;
        }
    }

    public class MyListCellRenderer
    implements ListCellRenderer {
        private final JLabel label = new JLabel();
        private final char splitChar;

        MyListCellRenderer(char splitChar) {
            this.splitChar = splitChar;
            SplittedExplicativeJComboBoxPanel.this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean celHasFocus) {
            if (isSelected) {
                this.label.setBackground(list.getSelectionBackground());
                this.label.setForeground(list.getSelectionForeground());
            } else {
                this.label.setBackground(list.getBackground());
                this.label.setForeground(list.getForeground());
            }
            if (value instanceof DescriptedObject) {
                String string;
                int splitindex;
                DescriptedObject descrobj = (DescriptedObject)value;
                if (isSelected) {
                    this.label.setToolTipText(descrobj.getDescription());
                }
                string = (splitindex = (string = value.toString()).indexOf(this.splitChar)) >= 0 ? string.substring(splitindex) : "";
                this.label.setText(string);
                return this.label;
            }
            return SplittedExplicativeJComboBoxPanel.this.comboBoxEditor.getEditorComponent();
        }
    }
}

