/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JFrame;

public class TriptychLayout
implements LayoutManager {
    public static final String CENTER = "Center";
    public static final String LEFT = "Left";
    public static final String RIGHT = "Right";
    private Component[] components = new Component[3];

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new TriptychLayout());
        frame.getContentPane().add(LEFT, new JButton("Button 1"));
        frame.getContentPane().add(CENTER, new JButton("Button 2"));
        frame.getContentPane().add(RIGHT, new JButton("Button 3"));
        frame.pack();
        frame.setVisible(true);
    }

    public void addLayoutComponent(String name, Component comp) {
        if (name == null || name.equals("")) {
            for (int i = 0; i < 3; ++i) {
                if (this.components[i] != null) continue;
                this.components[i] = comp;
                break;
            }
        } else {
            if (LEFT.equals(name)) {
                this.components[0] = comp;
            }
            if (CENTER.equals(name)) {
                this.components[1] = comp;
            }
            if (RIGHT.equals(name)) {
                this.components[2] = comp;
            }
        }
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int parentWidth = parent.getSize().width;
        while (parentWidth == 0 && parent.getParent() != null) {
            parent = parent.getParent();
            parentWidth = parent.getSize().width;
        }
        parentWidth -= insets.left + insets.right;
        int height = this.getPreferredHeight();
        int middleWidth = 0;
        if (this.components[1] != null) {
            middleWidth = this.components[1].getPreferredSize().width;
            int x = Math.max(0, (parentWidth - middleWidth) / 2);
            this.components[1].setBounds(x + insets.left, insets.top, middleWidth, height);
        }
        if (this.components[0] != null) {
            this.components[0].setBounds(insets.left, insets.top, (parentWidth - middleWidth) / 2, height);
        }
        if (this.components[2] != null) {
            this.components[2].setBounds(insets.left + (parentWidth + middleWidth) / 2, insets.top, (parentWidth - middleWidth) / 2, height);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.components[1] != null ? this.components[1].getMinimumSize() : new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.getPreferredWidth(), this.getPreferredHeight());
    }

    public void removeLayoutComponent(Component comp) {
        for (int i = 0; i < 3; ++i) {
            if (this.components[i] != comp) continue;
            this.components[i] = null;
        }
    }

    private int getPreferredHeight() {
        int preferredHeight = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.components[i] == null) continue;
            preferredHeight = Math.max(preferredHeight, this.components[i].getPreferredSize().height);
        }
        return preferredHeight;
    }

    private int getPreferredWidth() {
        int preferredWidth = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.components[i] == null) continue;
            preferredWidth += this.components[i].getPreferredSize().width;
        }
        return preferredWidth;
    }
}

