/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import nl.mpi.imdidb.IMDIDB;
import nl.mpi.util.DBConnection;
import org.apache.log4j.Logger;

public abstract class DBImpl {
    protected static String staticSyncFlag = "dummy";
    private static boolean checkedDB = false;
    private boolean status = false;
    protected DBConnection db = null;
    protected static Logger logger = Logger.getLogger((String)IMDIDB.class.getName());

    public static void setLogger(Logger l) {
        logger = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        String string = staticSyncFlag;
        synchronized (string) {
            if (!this.db.getStatus()) {
                logger.error((Object)"DBImpl: init() ERROR status = false");
                this.setStatus(false);
                return false;
            }
            return this.createTables();
            {
            }
        }
    }

    public void reset() {
        this.dropOldIndexes();
        this.dropOldTables();
    }

    public abstract void shutdown();

    public synchronized void close() {
        this.closePreparedStatements();
        if (this.db != null) {
            this.db.close();
        }
        this.db = null;
    }

    protected abstract boolean createTables();

    protected abstract boolean createIndexes();

    protected abstract void dropOldTables();

    protected abstract void dropOldIndexes();

    protected abstract boolean initPreparedStatements();

    protected abstract void closePreparedStatements();

    public boolean getStatus() {
        return this.status;
    }

    protected synchronized void setStatus(boolean st) {
        this.status = st;
    }
}

