/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import java.io.IOException;
import nl.mpi.imdidb.IMDIRdbModel;
import nl.mpi.imdidb.MDTable;
import nl.mpi.util.OurURL;
import org.apache.commons.digester.Digester;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MDDigester {
    private static final String[] LANGUAGE_TYPES = new String[]{"Id", "Name", "MotherTongue", "PrimaryLanguage", "Dominant", "SourceLanguage", "TargetLanguage"};
    private static final String[] CONTACT_TYPES = new String[]{"Name", "Address", "Email", "Organisation"};
    private static final String[] ACCESS_TYPES = new String[]{"Availability", "Date", "Owner", "Publisher"};
    private static XMLReader xmlReader;

    public static MDTable processCatalogueNode(OurURL url) throws IOException, SAXException {
        return MDDigester.processNode(url, MDDigester.createCatalogDigester());
    }

    public static MDTable processSessionNode(OurURL url) throws IOException, SAXException {
        return MDDigester.processNode(url, MDDigester.createSessionDigester());
    }

    private static MDTable processNode(OurURL url, Digester digester) throws IOException, SAXException {
        MDTable imdi = null;
        InputSource inputSource = new InputSource(url.openStream());
        inputSource.setSystemId(url.toString());
        imdi = (MDTable)digester.parse(inputSource);
        return imdi;
    }

    private static XMLReader getXmlReader() throws SAXException {
        if (xmlReader == null) {
            xmlReader = XMLReaderFactory.createXMLReader(SAXParser.class.getName());
            xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        return xmlReader;
    }

    private static Digester createSessionDigester() throws SAXException {
        Digester digester = new Digester(MDDigester.getXmlReader());
        digester.setValidating(false);
        MDDigester.startTable(digester, "METATRANSCRIPT/Session", "Session", "Name", "Title", "Date", "References");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/MDGroup/Location", "Continent", "Country", "Address");
        MDDigester.startTable(digester, "METATRANSCRIPT/Session/MDGroup/Location/Region", "Region", new String[0]);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/MDGroup/Location", "Region");
        digester.addSetNext("METATRANSCRIPT/Session/MDGroup/Location/Region", "addTable");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/MDGroup/Project", "Name", "Title", "Id");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/MDGroup/Project/Contact", CONTACT_TYPES);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/MDGroup/Content", "Genre", "SubGenre", "Task", "Modalities", "Subject");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/MDGroup/Content/CommunicationContext", "Interactivity", "PlanningType", "Involvement", "SocialContext", "EventStructure", "Channel");
        MDDigester.addKeyValueTable(digester, "METATRANSCRIPT/Session/MDGroup/Keys/Key");
        MDDigester.addTable(digester, "METATRANSCRIPT/Session/MDGroup/Content/Languages/Language", "Language", LANGUAGE_TYPES);
        MDDigester.addKeyValueTable(digester, "METATRANSCRIPT/Session/MDGroup/Content/Keys/Key");
        MDDigester.startTable(digester, "METATRANSCRIPT/Session/MDGroup/Actors/Actor", "Actor", "Role", "Name", "FullName", "Code", "FamilySocialRole", "EthnicGroup", "Age", "BirthDate", "Sex", "Education", "Anonymized");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/MDGroup/Actors/Actor/Contact", CONTACT_TYPES);
        MDDigester.addTable(digester, "METATRANSCRIPT/Session/MDGroup/Actors/Actor/Languages/Language", "Language", LANGUAGE_TYPES);
        MDDigester.addKeyValueTable(digester, "METATRANSCRIPT/Session/MDGroup/Actors/Actor/Keys/Key");
        digester.addSetNext("METATRANSCRIPT/Session/MDGroup/Actors/Actor", "addTable");
        MDDigester.startTable(digester, "METATRANSCRIPT/Session/Resources/Source", "Source", "Id", "Format", "Quality");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/Source/CounterPosition", "Start", "End");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/Source/TimePosition", "Start", "End");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/Source/Access", ACCESS_TYPES);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/Source/Access/Contact", CONTACT_TYPES);
        MDDigester.addKeyValueTable(digester, "METATRANSCRIPT/Session/Resources/Source/Keys/Key");
        digester.addSetNext("METATRANSCRIPT/Session/Resources/Source", "addTable");
        MDDigester.startTable(digester, "METATRANSCRIPT/Session/Resources/WrittenResource", "WrittenResource", "ResourceLink", "MediaResourceLink", "Date", "Type", "SubType", "Format", "Size", "Derivation", "CharacterEncoding", "ContentEncoding", "LanguageId", "Anonymized");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/WrittenResource/Validation", "Type", "Methodology", "Level");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/WrittenResource/Access", ACCESS_TYPES);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/WrittenResource/Access/Contact", CONTACT_TYPES);
        MDDigester.addKeyValueTable(digester, "METATRANSCRIPT/Session/Resources/WrittenResource/Keys/Key");
        digester.addSetNext("METATRANSCRIPT/Session/Resources/WrittenResource", "addTable");
        MDDigester.startTable(digester, "METATRANSCRIPT/Session/Resources/MediaFile", "MediaFile", "ResourceLink", "Type", "Format", "Size", "Quality", "RecordingConditions");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/MediaFile/TimePosition", "Start", "End");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/MediaFile/Access", ACCESS_TYPES);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/MediaFile/Access/Contact", CONTACT_TYPES);
        MDDigester.addKeyValueTable(digester, "METATRANSCRIPT/Session/Resources/MediaFile/Keys/Key");
        digester.addSetNext("METATRANSCRIPT/Session/Resources/MediaFile", "addTable");
        MDDigester.startTable(digester, "METATRANSCRIPT/Session/Resources/Anonyms", "Anonyms", "ResourceLink");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/Anonyms/Access", ACCESS_TYPES);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Session/Resources/Anonyms/Access/Contact", CONTACT_TYPES);
        digester.addSetNext("METATRANSCRIPT/Session/Resources/Anonyms", "addTable");
        return digester;
    }

    private static Digester createCatalogDigester() throws SAXException {
        Digester digester = new Digester(MDDigester.getXmlReader());
        digester.setValidating(false);
        MDDigester.startTable(digester, "METATRANSCRIPT/Catalogue", "Catalogue", "Name", "Title", "Id", "SmallestAnnotationUnit", "Applications", "Date", "Size", "DistributionForm", "Pricing", "ContactPerson", "ReferenceLink", "MetadataLink", "Publications");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Catalogue/Format", "Text", "Audio", "Video", "Image");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Catalogue/Quality", "Text", "Audio", "Video", "Image");
        MDDigester.addTable(digester, "METATRANSCRIPT/Catalogue/DocumentLanguages/Language", "DocumentLanguages", "Id", "Name");
        MDDigester.addTable(digester, "METATRANSCRIPT/Catalogue/SubjectLanguages/Language", "SubjectLanguages", "Id", "Name", "Dominant", "SourceLanguage", "TargetLanguage");
        MDDigester.startTable(digester, "METATRANSCRIPT/Catalogue/Location", "Location", "Continent", "Country", "Address");
        MDDigester.startTable(digester, "METATRANSCRIPT/Catalogue/Location/Region", "Region", new String[0]);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Catalogue/Location", "Region");
        digester.addSetNext("METATRANSCRIPT/Catalogue/Location/Region", "addTable");
        digester.addSetNext("METATRANSCRIPT/Catalogue/Location", "addTable");
        MDDigester.startTable(digester, "METATRANSCRIPT/Catalogue/Project", "Project", "Name", "Title", "Id");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Catalogue/Project/Contact", CONTACT_TYPES);
        digester.addSetNext("METATRANSCRIPT/Catalogue/Project", "addTable");
        MDDigester.startTable(digester, "METATRANSCRIPT/Catalogue/Publisher", "Publisher", new String[0]);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Catalogue", "Publisher");
        digester.addSetNext("METATRANSCRIPT/Catalogue/Publisher", "addTable");
        MDDigester.startTable(digester, "METATRANSCRIPT/Catalogue/ContentType", "ContentType", new String[0]);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Catalogue", "ContentType");
        digester.addSetNext("METATRANSCRIPT/Catalogue/ContentType", "addTable");
        MDDigester.startTable(digester, "METATRANSCRIPT/Catalogue/Author", "Author", new String[0]);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Catalogue", "Author");
        digester.addSetNext("METATRANSCRIPT/Catalogue/Author", "addTable");
        MDDigester.addColumns(digester, "METATRANSCRIPT/Catalogue/Access", ACCESS_TYPES);
        MDDigester.addColumns(digester, "METATRANSCRIPT/Catalogue/Access/Contact", CONTACT_TYPES);
        MDDigester.addKeyValueTable(digester, "METATRANSCRIPT/Catalogue/Keys/Key");
        return digester;
    }

    private static void addTable(Digester digester, String pattern, String tableName, String ... columnNames) {
        MDDigester.startTable(digester, pattern, tableName, columnNames);
        digester.addSetNext(pattern, "addTable");
    }

    private static void startTable(Digester digester, String pattern, String tableName, String ... columnNames) {
        MDDigester.addTable(digester, pattern, tableName);
        MDDigester.addColumns(digester, pattern, columnNames);
    }

    private static void addTable(Digester digester, String pattern, String tableName) {
        digester.addObjectCreate(pattern, MDTable.class);
        digester.addCallMethod(pattern, "setName", 1);
        digester.addObjectParam(pattern, 0, (Object)IMDIRdbModel.toTableName(tableName, pattern));
    }

    private static void addColumns(Digester digester, String pattern, String ... columnNames) {
        for (String columnName : columnNames) {
            String columnsPattern = pattern + "/" + columnName;
            digester.addCallMethod(columnsPattern, "addColumn", 2);
            digester.addObjectParam(columnsPattern, 0, (Object)IMDIRdbModel.toColumnName(columnName, columnsPattern));
            digester.addCallParam(columnsPattern, 1);
        }
    }

    private static void addKeyValueTable(Digester digester, String pattern) {
        MDDigester.startTable(digester, pattern, "Key", new String[0]);
        digester.addCallMethod(pattern, "addColumn", 2);
        digester.addObjectParam(pattern, 0, (Object)IMDIRdbModel.toColumnName("Name", pattern));
        digester.addCallParam(pattern, 1, "Name");
        digester.addCallMethod(pattern, "addColumn", 2);
        digester.addObjectParam(pattern, 0, (Object)IMDIRdbModel.toColumnName("Value", pattern));
        digester.addCallParam(pattern, 1);
        digester.addSetNext(pattern, "addTable");
    }
}

