<?xml version="1.0" encoding="UTF-8"?>
<!--
	Do the following repairs on IMDI 3.0 Session file:
	- (r1) copy or insert BirthDate
	- (r3,r4,r7) Place WrittenResource elements in the correct order
	- (r5,r6) Place MediaFile elements in the correct order
    - (r8) Change WrittenResource.Anonymized empty tags to Unspecified
    - (r10) Correct hours in position
    - (r13) Change empty tags TimePosition.Start, TimePosition.End to Unspecified
    - (r11) Capitalize 'unspecified' -> 'Unspecified' for MediaFile.Quality, Source.Quality
    - Repair Actor Language sub-schema
    - Repair Content Language sub-schema
    - Place Actor elements in correct order
    - Repair empty SourceLanguage, TargetLanguage
    - Repair empty MotherTongue, PrimaryLanguage
    - Remove empty ResourceRef, ResourceRefs
    - Repair Languages ordering
    - Repair Access ordering
    
	Freddy Offenga, 2004

    - repair Content ordering
    - also repair empty Language.Dominant element

	Daan Broeder  oct. 2004
	
		- fixed Content ordering, Added Task
	
	Freddy, oct. 2004
	
-->
<xsl:stylesheet exclude-result-prefixes="imdi" version="1.0" xmlns="http://www.mpi.nl/IMDI/Schema/IMDI" xmlns:imdi="http://www.mpi.nl/IMDI/Schema/IMDI" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output encoding="UTF-8" indent="yes" method="xml"/>

        <xsl:template match="/">
                <xsl:variable name="version" select="substring-after(imdi:METATRANSCRIPT/@FormatId|METATRANSCRIPT/@FormatId,'IMDI ')"/>
                <xsl:choose>
                        <xsl:when test="$version &lt; 3">
     	                   <xsl:copy-of select="."/>
                           <xsl:message>SKIP - old IMDI file</xsl:message>
                        </xsl:when>
                   		<xsl:when test="imdi:METATRANSCRIPT/@Type='SESSION'">
                           <METATRANSCRIPT Date="{imdi:METATRANSCRIPT/@Date}" FormatId="IMDI 3.0" Originator="{imdi:METATRANSCRIPT/@Originator}" Type="{imdi:METATRANSCRIPT/@Type}" Version="{number(imdi:METATRANSCRIPT/@Version)}" xmlns="http://www.mpi.nl/IMDI/Schema/IMDI" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.mpi.nl/IMDI/Schema/IMDI  ./IMDI_3.0.xsd">    
                                <xsl:apply-templates select="imdi:METATRANSCRIPT/imdi:*"/>
                           </METATRANSCRIPT>                   		
                        </xsl:when>                        
                        <xsl:otherwise>                     
     	                	<xsl:copy-of select="."/>
                        	<xsl:message>
                           		<xsl:text>SKIP - IMDI </xsl:text>
                           		<xsl:value-of select="imdi:METATRANSCRIPT/@Type"/>
                        	</xsl:message>
                        </xsl:otherwise>
                </xsl:choose>
        </xsl:template>

		<!-- Place Content elements in the correct order -->
		<xsl:template match="imdi:Content">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>
		    	<xsl:apply-templates select="imdi:Genre"/>
		    	<xsl:apply-templates select="imdi:SubGenre"/>
		    	<xsl:apply-templates select="imdi:Task"/>		    	
		    	<xsl:apply-templates select="imdi:Modalities"/>
		    	<xsl:apply-templates select="imdi:Subject"/>
		    	<xsl:apply-templates select="imdi:CommunicationContext"/>
		    	<xsl:apply-templates select="imdi:Languages"/>
		    	<xsl:apply-templates select="imdi:Keys"/>
		    	<xsl:apply-templates select="imdi:Description"/>
			</xsl:element>
			<xsl:message>Content ordering repaired</xsl:message>
		</xsl:template>

		<!-- (r3,r4,r7) Place WrittenResource elements in the correct order -->
		<xsl:template match="imdi:WrittenResource">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>
		    	<xsl:apply-templates select="imdi:ResourceLink"/>
		    	<xsl:apply-templates select="imdi:MediaResourceLink"/>
		    	<xsl:apply-templates select="imdi:Date"/>
		    	<xsl:apply-templates select="imdi:Type"/>
		    	<xsl:apply-templates select="imdi:SubType"/>
		    	<xsl:apply-templates select="imdi:Format"/>
		    	<xsl:apply-templates select="imdi:Size"/>
		    	<xsl:apply-templates select="imdi:Validation"/>
		    	<xsl:apply-templates select="imdi:Derivation"/>
		    	<xsl:apply-templates select="imdi:CharacterEncoding"/>		    	
		    	<xsl:apply-templates select="imdi:ContentEncoding"/>	    	
		    	<xsl:apply-templates select="imdi:LanguageId"/>
		    	<xsl:apply-templates select="imdi:Anonymized"/>
		    	<xsl:apply-templates select="imdi:Access"/>
		    	<xsl:apply-templates select="imdi:Description"/>
		    	<xsl:apply-templates select="imdi:Keys"/>
			</xsl:element>
			<xsl:message>WrittenResource ordering repaired</xsl:message>
		</xsl:template>

		<!-- (r5,r6) Place MediaFile elements in the correct order -->
		<xsl:template match="imdi:MediaFile">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>
		    	<xsl:apply-templates select="imdi:ResourceLink"/>
		    	<xsl:apply-templates select="imdi:Type"/>
		    	<xsl:apply-templates select="imdi:Format"/>
		    	<xsl:apply-templates select="imdi:Size"/>
		    	<xsl:apply-templates select="imdi:Quality"/>
		    	<xsl:apply-templates select="imdi:RecordingConditions"/>
		    	<xsl:apply-templates select="imdi:TimePosition"/>
		    	<xsl:apply-templates select="imdi:Access"/>
		    	<xsl:apply-templates select="imdi:Description"/>
		    	<xsl:apply-templates select="imdi:Keys"/>
			</xsl:element>
			<xsl:message>MediaFile ordering repaired</xsl:message>
		</xsl:template>

		<!-- (r8) Change the following empty tags to Unspecified:
		     - WrittenResource.Anonymized
		-->
		<xsl:template match="imdi:WrittenResource/imdi:Anonymized">
			<xsl:call-template name="repair-empty-tag">
         	   <xsl:with-param name="value-node" select="." />
        	</xsl:call-template>
		</xsl:template>
		
		<!-- (r10) Correct hours in position
			 (r13) Change empty tags to Unspecified
		     - TimePosition.Start
		     - TimePosition.End
		-->
		<xsl:template match="imdi:TimePosition/imdi:Start|imdi:TimePosition/imdi:End">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>
		    	<xsl:choose>
                	<xsl:when test="normalize-space(.)=''">
                		<xsl:text>Unspecified</xsl:text>
                		<xsl:message>Empty tag changed to Unspecified</xsl:message>
                	</xsl:when>
                	<xsl:when test="string-length(substring-before(text(), ':'))=1">
                		<xsl:value-of select="concat('0', text())"/>
                		<xsl:message>Corrected hours in position</xsl:message>
                	</xsl:when>
					<xsl:otherwise>
		    			<xsl:apply-templates select="imdi:*|*|text()"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:template>
		
		<!-- (r11) Capitalize 'unspecified' -> 'Unspecified' for
			- MediaFile.Quality
			- Source.Quality
		-->
		<xsl:template match="imdi:MediaFile/imdi:Quality|imdi:Source/imdi:Quality">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>
		    	<xsl:choose>
                	<xsl:when test="normalize-space(.)='unspecified'">
                		<xsl:text>Unspecified</xsl:text>
                		<xsl:message>Capitalized unspecified value</xsl:message>
                	</xsl:when>
					<xsl:otherwise>
		    			<xsl:apply-templates select="imdi:*|*|text()"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:template>		

		<!-- Place Actor elements in correct order -->
		<xsl:template match="imdi:Actor">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>
		    	<xsl:apply-templates select="imdi:Role"/>
		    	<xsl:apply-templates select="imdi:Name"/>
		    	<xsl:apply-templates select="imdi:FullName"/>
		    	<xsl:apply-templates select="imdi:Code"/>
		    	<xsl:apply-templates select="imdi:FamilySocialRole"/>
		    	<xsl:apply-templates select="imdi:Languages"/>
		    	<xsl:apply-templates select="imdi:EthnicGroup"/>
		    	<xsl:apply-templates select="imdi:Age"/>
                <xsl:choose>
                  	<xsl:when test="count(imdi:BirthDate)>0">
						<xsl:apply-templates select="imdi:BirthDate"/>
						<xsl:message>copied BirthDate</xsl:message>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="BirthDate">
                      		<xsl:text>Unspecified</xsl:text>
                      	</xsl:element>
                        <xsl:message>inserted BirthDate (Unspecified)</xsl:message>
                    </xsl:otherwise>
                </xsl:choose>
		    	<xsl:apply-templates select="imdi:Sex"/>
		    	<xsl:apply-templates select="imdi:Education"/>
		    	<xsl:apply-templates select="imdi:Anonymized"/>
		    	<xsl:apply-templates select="imdi:Contact"/>
		    	<xsl:apply-templates select="imdi:Keys"/>
		    	<xsl:apply-templates select="imdi:Description"/>
			</xsl:element>
			<xsl:message>Actor ordering repaired</xsl:message>
		</xsl:template>
   
		<!-- Repair Actor Language sub-schema -->
		<xsl:template match="imdi:Actor/imdi:Languages/imdi:Language">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>
		    	<xsl:apply-templates select="imdi:Id"/>
		    	<xsl:apply-templates select="imdi:Name"/>
		    	<xsl:apply-templates select="imdi:MotherTongue"/>
		    	<xsl:apply-templates select="imdi:PrimaryLanguage"/>
		    	<xsl:apply-templates select="imdi:Description"/>
			</xsl:element>
			<xsl:message>Actor Language sub-schema repaired</xsl:message>
		</xsl:template>
				    	
		<!-- Repair Content Language sub-schema -->
		<xsl:template match="imdi:Content/imdi:Languages/imdi:Language">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>
		    	<xsl:apply-templates select="imdi:Id"/>
		    	<xsl:apply-templates select="imdi:Name"/>
		    	<xsl:apply-templates select="imdi:Dominant"/>   	
		    	<xsl:apply-templates select="imdi:SourceLanguage"/>
		    	<xsl:apply-templates select="imdi:TargetLanguage"/>
		    	<xsl:apply-templates select="imdi:Description"/>
			</xsl:element>
			<xsl:message>Content Language sub-schema repaired</xsl:message>
		</xsl:template>

		<!-- Repair empty SourceLanguage, TargetLanguage , Dominant -->
		<xsl:template match="imdi:Language/imdi:SourceLanguage|imdi:Language/imdi:TargetLanguage|imdi:Language/imdi:Dominant">
			<xsl:call-template name="repair-empty-tag">
         	   <xsl:with-param name="value-node" select="." />
        	</xsl:call-template>        
 		</xsl:template>

		<!-- Repair empty MotherTongue, PrimaryLanguage -->
		<xsl:template match="imdi:Language/imdi:MotherTongue|imdi:Language/imdi:PrimaryLanguage">
			<xsl:call-template name="repair-empty-tag">
         	   <xsl:with-param name="value-node" select="." />
        	</xsl:call-template>        
 		</xsl:template>

		<!-- Repair empty Session.Date -->
		<xsl:template match="imdi:Session/imdi:Date">
			<xsl:call-template name="repair-empty-tag">
         	   <xsl:with-param name="value-node" select="." />
        	</xsl:call-template>        
 		</xsl:template>
 		
		<!-- Remove empty ResourceRef, ResourceRefs, DefaultLink -->
        <xsl:template match="@ResourceRef|@ResourceRefs|@DefaultLink">
		    <xsl:choose>
            	<xsl:when test="normalize-space(.)=''">
	        		<xsl:message>
    	    			<xsl:text>Removed empty attribute </xsl:text>
        				<xsl:value-of select="name(.)"/> from <xsl:value-of select="name(..)"/>
            		</xsl:message>
            	</xsl:when>
				<xsl:otherwise>
	    			<xsl:attribute name="{name(.)}">
            			<xsl:value-of select="."/>
        			</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>        	
        </xsl:template>

		<!-- Repair Languages ordering -->
		<xsl:template match="imdi:Languages">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>
		    	<xsl:apply-templates select="imdi:Description"/>
		    	<xsl:apply-templates select="imdi:Language"/>
			</xsl:element>
			<xsl:message>Languages ordering repaired</xsl:message>
		</xsl:template>

		<!-- Repair Access ordering -->
		<xsl:template match="imdi:Access">
		    <xsl:element name="{name(.)}">
		    	<xsl:apply-templates select="@*"/>    	
		    	<xsl:apply-templates select="imdi:Availability"/>
		    	<xsl:apply-templates select="imdi:Date"/>
		    	<xsl:apply-templates select="imdi:Owner"/>
		    	<xsl:apply-templates select="imdi:Publisher"/>
		    	<xsl:apply-templates select="imdi:Contact"/>
		    	<xsl:apply-templates select="imdi:Description"/>		    	
			</xsl:element>
			<xsl:message>Access ordering repaired</xsl:message>
		</xsl:template>
				               
		<!-- copy attributes -->
        <xsl:template match="@*">
            <xsl:attribute name="{name(.)}">
            	<xsl:value-of select="."/>
        	</xsl:attribute>
        </xsl:template>

		<!-- copy elements -->
        <xsl:template match="imdi:*">
        	<xsl:element name="{name(.)}">
				<xsl:apply-templates select="@*"/>
                <xsl:apply-templates select="imdi:*|*|text()"/>
        	</xsl:element>
        </xsl:template>
        
        <!-- repair empty tag -->
        <xsl:template name="repair-empty-tag">
			<xsl:param name="value-node" />
            <xsl:element name="{name($value-node)}">
               	<xsl:apply-templates select="$value-node/@*"/>
		    	<xsl:choose>
               		<xsl:when test="normalize-space($value-node)=''">
               			<xsl:text>Unspecified</xsl:text>
	               		<xsl:message>
    	           			<xsl:text>Empty tag </xsl:text>
        	       			<xsl:value-of select="name($value-node/..)"/>/<xsl:value-of select="name($value-node)"/>
            	   			<xsl:text> changed to Unspecified</xsl:text>
               			</xsl:message>
               		</xsl:when>
					<xsl:otherwise>
	    				<xsl:apply-templates select="$value-node/text()"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:template>

</xsl:stylesheet>
