/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.flap.model.DataNodeType;
import nl.mpi.flap.model.FieldGroup;
import nl.mpi.kinnate.data.FilteredNodeContainer;
import nl.mpi.kinnate.data.KinTreeFilteredNode;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.ExternalLink;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.SymbolGraphic;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinTreeNode
extends ArbilNode
implements Comparable {
    private UniqueIdentifier uniqueIdentifier;
    protected EntityData entityData = null;
    protected IndexerParameters indexerParameters;
    protected ArbilNode[] childNodes = null;
    protected final SymbolGraphic symbolGraphic;
    protected EntityCollection entityCollection;
    protected MessageDialogHandler dialogHandler;
    protected ArbilDataNodeLoader dataNodeLoader;
    private String derivedLabelString = null;
    protected final DataStoreSvg dataStoreSvg;

    public KinTreeNode(SymbolGraphic symbolGraphic, UniqueIdentifier uniqueIdentifier, EntityData entityData, DataStoreSvg dataStoreSvg, IndexerParameters indexerParameters, MessageDialogHandler dialogHandler, EntityCollection entityCollection, ArbilDataNodeLoader dataNodeLoader) {
        this.uniqueIdentifier = uniqueIdentifier;
        this.dataStoreSvg = dataStoreSvg;
        this.indexerParameters = indexerParameters;
        this.entityData = entityData;
        this.entityCollection = entityCollection;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.symbolGraphic = symbolGraphic;
    }

    public EntityData getEntityData() {
        return this.entityData;
    }

    public UniqueIdentifier getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public String toString() {
        if (this.derivedLabelString == null) {
            if (this.entityData == null) {
                return "<entity not loaded>";
            }
            StringBuilder labelBuilder = new StringBuilder();
            String[] labelArray = this.entityData.getLabel();
            if (labelArray != null && labelArray.length > 0) {
                for (String labelString : labelArray) {
                    labelBuilder.append(labelString);
                    labelBuilder.append(" ");
                }
            }
            this.derivedLabelString = labelBuilder.toString();
            if (this.derivedLabelString.replaceAll("\\s", "").isEmpty()) {
                this.derivedLabelString = "<unlabeled entity>";
            }
        }
        return this.derivedLabelString;
    }

    public ArbilDataNode[] getAllChildren() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void getAllChildren(Vector<ArbilDataNode> allChildren) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ArbilNode[] getChildArray() {
        if (this.childNodes == null) {
            HashMap metaNodeMap = new HashMap();
            for (EntityRelation entityRelation : this.entityData.getAllRelations()) {
                String wraperNodeLabel = entityRelation.getTypeLabel();
                if (!metaNodeMap.containsKey(wraperNodeLabel)) {
                    metaNodeMap.put(wraperNodeLabel, new HashSet());
                }
                ((HashSet)metaNodeMap.get(wraperNodeLabel)).add(new KinTreeFilteredNode(this.symbolGraphic, entityRelation, this.dataStoreSvg, this.indexerParameters, this.dialogHandler, this.entityCollection, this.dataNodeLoader));
            }
            HashSet<ArbilNode> kinTreeMetaNodes = new HashSet<ArbilNode>();
            for (Map.Entry filteredNodeEntry : metaNodeMap.entrySet()) {
                kinTreeMetaNodes.add((ArbilNode)new FilteredNodeContainer((String)filteredNodeEntry.getKey(), null, ((HashSet)filteredNodeEntry.getValue()).toArray(new KinTreeFilteredNode[0])));
            }
            this.getLinksMetaNode(kinTreeMetaNodes);
            this.childNodes = kinTreeMetaNodes.toArray(new ArbilNode[0]);
        }
        return this.childNodes;
    }

    protected void getLinksMetaNode(HashSet<ArbilNode> kinTreeMetaNodes) {
        if (this.entityData.externalLinks != null) {
            HashSet<ArbilDataNode> relationList = new HashSet<ArbilDataNode>();
            for (ExternalLink externalLink : this.entityData.externalLinks) {
                ArbilDataNode linkedArbilDataNode = this.dataNodeLoader.getArbilDataNode(null, externalLink.getLinkUri());
                relationList.add(linkedArbilDataNode);
            }
            kinTreeMetaNodes.add((ArbilNode)new ContainerNode(null, "External Links", null, (ArbilNode[])relationList.toArray(new ArbilDataNode[0])));
        }
    }

    public int getChildCount() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ImageIcon getIcon() {
        if (this.entityData != null) {
            return this.symbolGraphic.getSymbolGraphic(this.entityData.getSymbolNames(this.dataStoreSvg.defaultSymbol), this.entityData.isEgo, this.entityData.isRequired);
        }
        return null;
    }

    public String getID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<FieldGroup> getFieldGroups() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasCatalogue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasHistory() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasLocalResource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasResource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isArchivableFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCatalogue() {
        return false;
    }

    public boolean isChildNode() {
        return false;
    }

    public boolean isCmdiMetaDataNode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCorpus() {
        return false;
    }

    public boolean isDataLoaded() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isEditable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isEmptyMetaNode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isFavorite() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isLoading() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isDataPartiallyLoaded() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isLocal() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isMetaDataNode() {
        return false;
    }

    public boolean isResourceSet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setID(String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLabel(String label) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLabel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setFieldGroups(List<FieldGroup> fieldGroups) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setChildIds(List<String> idString) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<String> getChildIds() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setType(DataNodeType dataNodeType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DataNodeType getType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isSession() {
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof KinTreeNode) {
            int compResult = this.toString().compareTo(o.toString());
            if (compResult == 0) {
                // empty if block
            }
            return compResult;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KinTreeNode other = (KinTreeNode)obj;
        return this.entityData == other.entityData;
    }

    public int hashCode() {
        int hash = 0;
        hash = 37 * hash + (this.uniqueIdentifier != null ? this.uniqueIdentifier.hashCode() : 0);
        return hash;
    }
}

