/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.ui.EntityUploadPanel;
import nl.mpi.kinnate.ui.GedcomImportPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.menu.DocumentNewMenu;
import nl.mpi.kinnate.ui.menu.MainMenuBar;
import nl.mpi.kinnate.ui.menu.RecentFileMenu;
import nl.mpi.kinnate.ui.window.SavePanelFrame;

public abstract class AbstractDiagramManager {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Widgets");
    private EntityUploadPanel entityUploadPanel;
    private final ApplicationVersionManager versionManager;
    private final ArbilWindowManager dialogHandler;
    private final SessionStorage sessionStorage;
    private final ArbilDataNodeLoader dataNodeLoader;
    private final ArbilTreeHelper treeHelper;
    private final ProjectManager projectManager;

    public AbstractDiagramManager(ApplicationVersionManager versionManager, ArbilWindowManager dialogHandler, SessionStorage sessionStorage, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper, ProjectManager projectManager) {
        this.versionManager = versionManager;
        this.dialogHandler = dialogHandler;
        this.sessionStorage = sessionStorage;
        this.dataNodeLoader = dataNodeLoader;
        this.treeHelper = treeHelper;
        this.projectManager = projectManager;
    }

    public abstract void createApplicationWindow();

    public JFrame createDiagramWindow(String diagramTitle, Component diagramComponent, Rectangle preferredSizeLocation) {
        JFrame diagramFame = diagramComponent instanceof SavePanel ? new SavePanelFrame((SavePanel)((Object)diagramComponent)) : new JFrame();
        this.setWindowTitle(diagramFame, diagramTitle);
        diagramFame.setJMenuBar(new MainMenuBar(this, this.sessionStorage, this.dialogHandler, this.versionManager, diagramFame, this.projectManager));
        if (diagramComponent != null) {
            diagramFame.setContentPane((Container)diagramComponent);
        }
        this.setWindowIcon(diagramFame);
        diagramFame.setDefaultCloseOperation(0);
        diagramFame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AbstractDiagramManager.this.closeWindowAction((JFrame)e.getWindow());
            }
        });
        if (preferredSizeLocation != null) {
            diagramFame.setLocation(preferredSizeLocation.x, preferredSizeLocation.y);
            diagramFame.setPreferredSize(preferredSizeLocation.getSize());
        }
        diagramFame.pack();
        diagramFame.setVisible(true);
        return diagramFame;
    }

    public JFrame createHelpWindow(String diagramTitle, Component diagramComponent, Rectangle preferredSizeLocation) {
        JFrame diagramFame = diagramComponent instanceof SavePanel ? new SavePanelFrame((SavePanel)((Object)diagramComponent)) : new JFrame();
        this.setWindowTitle(diagramFame, diagramTitle);
        if (diagramComponent != null) {
            diagramFame.setContentPane((Container)diagramComponent);
        }
        this.setWindowIcon(diagramFame);
        diagramFame.setDefaultCloseOperation(0);
        diagramFame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((JFrame)e.getWindow()).setVisible(false);
            }
        });
        if (preferredSizeLocation != null) {
            diagramFame.setLocation(preferredSizeLocation.x, preferredSizeLocation.y);
            diagramFame.setPreferredSize(preferredSizeLocation.getSize());
        }
        diagramFame.pack();
        diagramFame.setVisible(true);
        return diagramFame;
    }

    public void setWindowTitle(JFrame windowFrame, String titleString) {
        windowFrame.setTitle(this.versionManager.getApplicationVersion().applicationTitle + " " + this.versionManager.getApplicationVersion().currentMajor + "." + this.versionManager.getApplicationVersion().currentMinor + "." + this.versionManager.getApplicationVersion().currentRevision + " - " + titleString);
    }

    public void setWindowIcon(JFrame windowFrame) {
        windowFrame.setIconImage(ArbilIcons.getSingleInstance().linorgIcon.getImage());
    }

    protected void closeWindowAction(JFrame windowFrame) {
        if (this.offerUserToSaveAll()) {
            System.exit(0);
        }
    }

    public abstract Component createDiagramContainer(Component var1, Rectangle var2);

    public JDialog createDialogueContainer(Component diagramComponent, Component parentComponent) {
        String diagramTitle = diagramComponent.getName();
        JFrame parentFrame = (JFrame)SwingUtilities.getRoot(parentComponent);
        JDialog jDialog = new JDialog(parentFrame, diagramTitle, true);
        jDialog.getContentPane().removeAll();
        jDialog.getContentPane().add(diagramComponent);
        jDialog.pack();
        return jDialog;
    }

    public abstract void createDiagramSubPanel(String var1, Component var2, Component var3);

    public KinDiagramPanel newDiagram(Rectangle preferredSizeLocation, ProjectRecord projectRecord) throws EntityServiceException {
        URI defaultDiagramUri = null;
        if (projectRecord == null) {
            if (KinDiagramPanel.getGlobalDefaultDiagramFile(this.sessionStorage).exists()) {
                defaultDiagramUri = KinDiagramPanel.getGlobalDefaultDiagramFile(this.sessionStorage).toURI();
            }
        } else if (KinDiagramPanel.getDefaultDiagramFile(projectRecord).exists()) {
            defaultDiagramUri = KinDiagramPanel.getDefaultDiagramFile(projectRecord).toURI();
        }
        KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(defaultDiagramUri, false, projectRecord, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper, this.projectManager, this);
        egoSelectionTestPanel.setName(MessageFormat.format(widgets.getString("[{0}] UNSAVED DEFAULT DIAGRAM"), egoSelectionTestPanel.getGraphPanel().dataStoreSvg.projectRecord.getProjectName()));
        this.createDiagramContainer(egoSelectionTestPanel, preferredSizeLocation);
        return egoSelectionTestPanel;
    }

    public void newDiagram(DocumentNewMenu.DocumentType documentType, ProjectRecord projectRecord, Rectangle preferredSizeLocation) throws EntityServiceException {
        KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(documentType, projectRecord, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper, this.projectManager, this);
        egoSelectionTestPanel.setName(MessageFormat.format(widgets.getString("[{0}] UNSAVED {1}"), egoSelectionTestPanel.getGraphPanel().dataStoreSvg.projectRecord.getProjectName(), documentType.getDisplayName()));
        this.createDiagramContainer(egoSelectionTestPanel, preferredSizeLocation);
    }

    public void openDiagram(String diagramTitle, URI selectedUri, boolean saveToRecentMenu, Rectangle preferredSizeLocation) throws EntityServiceException {
        KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(selectedUri, saveToRecentMenu, null, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper, this.projectManager, this);
        if (saveToRecentMenu) {
            RecentFileMenu.addRecentFile(this.sessionStorage, new File(selectedUri));
        }
        egoSelectionTestPanel.setName(diagramTitle);
        this.createDiagramContainer(egoSelectionTestPanel, preferredSizeLocation);
    }

    abstract Component getSelectedDiagram();

    public void openImportPanel(File importFile, KinDiagramPanel kinDiagramPanel, EntityCollection entityCollection) throws ImportException {
        new GedcomImportPanel(this, kinDiagramPanel, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper).startImport(importFile);
    }

    public void openImportPanel(String importUrlString, KinDiagramPanel kinDiagramPanel, EntityCollection entityCollection) throws ImportException {
        new GedcomImportPanel(this, kinDiagramPanel, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper).startImport(importUrlString);
    }

    public void openJarImportPanel(String importUrlString, KinDiagramPanel kinDiagramPanel, EntityCollection entityCollection) throws ImportException {
        new GedcomImportPanel(this, kinDiagramPanel, this.sessionStorage, this.dialogHandler, this.dataNodeLoader, this.treeHelper).startImportJar(importUrlString);
    }

    public abstract void setSelectedDiagram(Component var1);

    public abstract void setSelectedDiagram(int var1);

    public void openEntityUploadPanel(Rectangle preferredSizeLocation, EntityCollection entityCollection) {
        if (this.entityUploadPanel == null) {
            this.entityUploadPanel = new EntityUploadPanel(this.sessionStorage, entityCollection, this.dialogHandler);
            this.entityUploadPanel.setName(widgets.getString("ENTITY UPLOAD"));
            this.createDiagramContainer(this.entityUploadPanel, preferredSizeLocation);
        }
        this.setSelectedDiagram(this.entityUploadPanel);
    }

    public abstract int getSavePanelIndex(Component var1);

    public abstract String getSavePanelTitle(int var1);

    public SavePanel getCurrentSavePanel(Component parentComponent) {
        return this.getSavePanel(this.getSavePanelIndex(parentComponent));
    }

    abstract Component getDiagramAt(int var1);

    public SavePanel getSavePanel(int tabIndex) {
        Component selectedComponent = this.getDiagramAt(tabIndex);
        SavePanel savePanel = null;
        if (selectedComponent instanceof SavePanel) {
            savePanel = (SavePanel)((Object)selectedComponent);
        }
        return savePanel;
    }

    public abstract void closeSavePanel(int var1);

    public KinTermSavePanel getKinTermPanel(Component parentComponent) {
        SavePanel selectedComponent = this.getCurrentSavePanel(parentComponent);
        if (selectedComponent == null) {
            return null;
        }
        KinTermSavePanel kinTermSavePanel = null;
        if (selectedComponent instanceof SavePanelFrame) {
            selectedComponent = (SavePanel)((Object)((SavePanelFrame)selectedComponent).getContentPane());
        }
        if (selectedComponent instanceof KinTermSavePanel) {
            kinTermSavePanel = (KinTermSavePanel)((Object)selectedComponent);
        }
        return kinTermSavePanel;
    }

    public abstract void setDiagramTitle(int var1, String var2);

    public abstract Component[] getAllDiagrams();

    public boolean offerUserToSaveAll() {
        int diagramCount = this.getAllDiagrams().length;
        for (int diagramCounter = 0; diagramCounter < diagramCount; ++diagramCounter) {
            Component selectedComponent = this.getDiagramAt(diagramCounter);
            if (!(selectedComponent instanceof SavePanel)) continue;
            SavePanel savePanel = (SavePanel)((Object)selectedComponent);
            this.setSelectedDiagram(selectedComponent);
            String diagramName = this.getSavePanelTitle(diagramCounter);
            boolean userCanceled = this.offerUserToSave(savePanel, diagramName);
            if (!userCanceled) continue;
            return false;
        }
        return true;
    }

    public boolean offerUserToSave(SavePanel savePanel, String diagramName) {
        if (savePanel.requiresSave()) {
            boolean fileSaved = false;
            while (!fileSaved) {
                switch (this.dialogHandler.showDialogBox(MessageFormat.format(widgets.getString("THE PROJECT DATA HAS BEEN SAVED, HOWEVER THE CURRENT DIAGRAM HAS NOT: \"{0}\"DO YOU WANT TO SAVE THIS DIAGRAM BEFORE CLOSING?"), diagramName), "CLOSE DIAGRAM", 1, -1)) {
                    case 0: {
                        if (savePanel.hasSaveFileName()) {
                            savePanel.saveToFile();
                            return false;
                        }
                        fileSaved = null != this.saveDiagramAs(savePanel);
                        break;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private String saveDiagramAs(SavePanel savePanel) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".svg");
            }

            public String getDescription() {
                return widgets.getString("SCALABLE VECTOR GRAPHICS (SVG)");
            }
        });
        int returnVal = fc.showSaveDialog((Component)((Object)savePanel));
        if (returnVal == 0) {
            File svgFile = fc.getSelectedFile();
            if (!svgFile.getName().toLowerCase().endsWith(".svg")) {
                svgFile = new File(svgFile.getParentFile(), svgFile.getName() + ".svg");
            }
            savePanel.saveToFile(svgFile);
            RecentFileMenu.addRecentFile(this.sessionStorage, svgFile);
            return svgFile.getName();
        }
        return null;
    }
}

