/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.util.list.StringList;

public final class DropDB
extends ACreate {
    public DropDB(String name) {
        super(name);
    }

    @Override
    protected boolean run() {
        if (!MetaData.validName(this.args[0], true)) {
            return this.error(Text.NAME_INVALID_X, this.args[0]);
        }
        StringList dbs = this.context.databases().listDBs(this.args[0]);
        if (dbs.size() == 0) {
            return this.info(Text.NO_DB_DROPPED, this.args[0]);
        }
        boolean ok = true;
        for (String db : dbs) {
            DropDB.close(this.context, db);
            if (this.context.pinned(db)) {
                this.info(Text.DB_PINNED_X, db);
                ok = false;
                continue;
            }
            if (!DropDB.drop(db, this.context)) {
                this.info(Text.DB_NOT_DROPPED_X, db);
                ok = false;
                continue;
            }
            this.info(Text.DB_DROPPED_X, db);
        }
        return ok;
    }

    public static synchronized boolean drop(String db, Context ctx) {
        IOFile dbpath = ctx.mprop.dbpath(db);
        return dbpath.exists() && DropDB.drop(dbpath) && ctx.databases().delete(db);
    }

    public static synchronized boolean drop(IOFile path) {
        return path.exists() && path.delete();
    }

    public static synchronized boolean drop(IOFile path, String pat) {
        boolean ok = true;
        for (IOFile f : path.children()) {
            ok &= !f.name().matches(pat) || f.delete();
        }
        return ok;
    }

    @Override
    public boolean newData(Context ctx) {
        return DropDB.close(ctx, this.args[0]);
    }

    @Override
    protected boolean databases(StringList db) {
        return this.databases(db, 0);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.DB)).args();
    }
}

