/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import java.util.ArrayList;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.parse.CmdParser;
import org.basex.core.parse.PasswordReader;
import org.basex.core.parse.StringParser;
import org.basex.core.parse.XMLParser;
import org.basex.query.QueryException;
import org.basex.util.InputParser;

public final class CommandParser
extends InputParser {
    public final CmdParser parser;

    public CommandParser(String in, Context c) {
        super(in);
        this.parser = in.startsWith("<") ? new XMLParser(in, c) : new StringParser(in, c);
    }

    public CommandParser password(PasswordReader pr) {
        this.parser.password(pr);
        return this;
    }

    public Command parseSingle() throws QueryException {
        return this.parse(true, false)[0];
    }

    public Command[] parse() throws QueryException {
        return this.parse(false, false);
    }

    public Command[] suggest() throws QueryException {
        return this.parse(false, true);
    }

    private Command[] parse(boolean sngl, boolean sggst) throws QueryException {
        ArrayList<Command> cmds = new ArrayList<Command>();
        this.parser.parse(cmds, sngl, sggst);
        if (sngl && cmds.size() != 1) {
            throw new QueryException("Single command expected.");
        }
        return cmds.toArray(new Command[cmds.size()]);
    }
}

