/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import javax.swing.Box;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.DialogParsing;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class DialogImport
extends BaseXBack {
    private static final String[] PARSING = new String[]{"xml", "json", "html", "csv", "text", "raw"};
    final BaseXLabel info;
    final BaseXTextField input;
    final BaseXButton browse;
    final BaseXCombo parser;
    String dbname;
    private final GUI gui;
    private final DialogParsing parsing;
    private final BaseXCheckBox archives;
    private final BaseXCheckBox skipCorrupt;
    private final BaseXCheckBox addRaw;
    private final BaseXTextField filter;

    public DialogImport(BaseXDialog dial, BaseXBack panel, DialogParsing parse) {
        this.gui = dial.gui;
        this.parsing = parse;
        this.layout(new TableLayout(10, 1));
        this.border(8);
        this.add(new BaseXLabel(Text.FILE_OR_DIR + ":", true, true).border(0, 0, 6, 0));
        String in = this.gui.gprop.get(GUIProp.CREATEPATH);
        this.input = new BaseXTextField(this.gui.gprop.get(GUIProp.CREATEPATH), dial);
        IO io = IO.get(in);
        if (io instanceof IOFile && !in.isEmpty()) {
            this.dbname = io.dbname();
        }
        this.browse = new BaseXButton(Text.BROWSE_D, dial);
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogImport.this.choose();
            }
        });
        BaseXBack b = new BaseXBack(new TableLayout(1, 2, 8, 0));
        b.add(this.input);
        b.add(this.browse);
        this.add(b);
        this.add(panel);
        this.add(Box.createVerticalStrut(12));
        Prop prop = this.gui.context.prop;
        StringList parsers = new StringList(PARSING.length);
        for (String p : PARSING) {
            parsers.add(p.toUpperCase(Locale.ENGLISH));
        }
        this.parser = new BaseXCombo(dial, parsers.toArray());
        this.parser.setSelectedItem(prop.get(Prop.PARSER).toUpperCase(Locale.ENGLISH));
        this.filter = new BaseXTextField(prop.get(Prop.CREATEFILTER), dial);
        BaseXLayout.setWidth(this.filter, 200);
        this.addRaw = new BaseXCheckBox(Text.ADD_RAW_FILES, prop.is(Prop.ADDRAW), dial);
        this.skipCorrupt = new BaseXCheckBox(Text.SKIP_CORRUPT_FILES, prop.is(Prop.SKIPCORRUPT), dial);
        this.archives = new BaseXCheckBox(Text.PARSE_ARCHIVES, prop.is(Prop.ADDARCHIVES), dial);
        BaseXBack p = new BaseXBack(new TableLayout(2, 2, 20, 0));
        p.add(new BaseXLabel(Text.INPUT_FORMAT, false, true).border(0, 0, 6, 0));
        p.add(new BaseXLabel(Text.FILE_PATTERNS + ":", false, true).border(0, 0, 6, 0));
        p.add(this.parser);
        p.add(this.filter);
        this.add(p);
        this.add(Box.createVerticalStrut(8));
        this.add(this.addRaw);
        this.add(this.skipCorrupt);
        this.add(this.archives);
        this.info = new BaseXLabel(" ").border(24, 0, 6, 0);
        this.add(this.info);
    }

    String input() {
        return this.input.getText().trim();
    }

    IOFile inputFile() {
        String path = this.gui.gprop.get(GUIProp.CREATEPATH);
        BaseXFileChooser fc = new BaseXFileChooser(Text.FILE_OR_DIR, path, this.gui);
        fc.addFilter("XML Documents", IO.XMLSUFFIXES);
        fc.addFilter("HTML Documents", IO.HTMLSUFFIXES);
        fc.addFilter("JSON Documents", ".json");
        fc.addFilter("Comma-Separated Values", ".csv");
        fc.addFilter("Plain Text", IO.TXTSUFFIXES);
        fc.addFilter("ZIP Archives", IO.ZIPSUFFIXES);
        IOFile file = fc.select(BaseXFileChooser.Mode.FDOPEN);
        if (file != null) {
            this.gui.gprop.set(GUIProp.CREATEPATH, file.path());
        }
        return file;
    }

    boolean action(Object comp, boolean empty) {
        boolean ok = this.parsing.action();
        String in = this.input.getText().trim();
        IO io = IO.get(in);
        this.gui.gprop.set(GUIProp.CREATEPATH, in);
        boolean dir = io.isDir();
        String type = this.parser();
        boolean r = type.equals("raw");
        if (comp == this.parser) {
            this.parsing.updateType(type);
            if (dir) {
                this.filter.setText(r ? "*" : "*." + type);
            }
        }
        boolean bl = empty ? in.isEmpty() || io.exists() : !in.isEmpty() && io.exists();
        if ((ok &= bl) && comp == this.input) {
            this.setType(in);
        }
        this.info.setText(null, null);
        this.filter.setEnabled(dir);
        this.addRaw.setEnabled(dir && !r && !this.gui.context.prop.is(Prop.MAINMEM));
        this.skipCorrupt.setEnabled(!r);
        this.archives.setEnabled(dir || io.isArchive());
        return ok;
    }

    void setOptions() {
        String type = this.parser();
        this.gui.set(Prop.PARSER, type);
        this.gui.set(Prop.CREATEFILTER, this.filter.getText());
        this.gui.set(Prop.ADDARCHIVES, this.archives.isSelected());
        this.gui.set(Prop.SKIPCORRUPT, this.skipCorrupt.isSelected());
        this.gui.set(Prop.ADDRAW, this.addRaw.isSelected());
        this.parsing.setOptions(type);
    }

    void choose() {
        IOFile in = this.inputFile();
        if (in == null) {
            return;
        }
        this.input.setText(in.path());
        this.setType(in.path());
    }

    void setType(String in) {
        IO io = IO.get(in);
        if (!in.isEmpty() && io instanceof IOFile) {
            this.dbname = io.dbname();
        }
        boolean dir = io.isDir();
        boolean archive = io.isArchive();
        if (dir || archive) {
            this.filter.setText("*.xml");
        }
        String type = null;
        if (!dir && !archive) {
            String path = io.path();
            int i = path.lastIndexOf(46);
            if (i != -1) {
                String suf = path.substring(i).toLowerCase(Locale.ENGLISH);
                if (Token.eq(suf, IO.XMLSUFFIXES)) {
                    type = "xml";
                } else if (Token.eq(suf, IO.HTMLSUFFIXES)) {
                    type = "html";
                } else if (Token.eq(suf, ".csv")) {
                    type = "csv";
                } else if (Token.eq(suf, IO.TXTSUFFIXES)) {
                    type = "text";
                } else if (Token.eq(suf, ".json")) {
                    type = "json";
                }
            }
            if (type == null) {
                type = DialogImport.guess(io);
            }
        }
        if (type == null) {
            type = "xml";
        }
        this.parser.setSelectedItem(type.toUpperCase(Locale.ENGLISH));
        this.parsing.updateType(type);
    }

    String parser() {
        return this.parser.getSelectedItem().toString().toLowerCase(Locale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String guess(IO in) {
        if (!in.exists()) {
            return null;
        }
        BufferInput ti = null;
        try {
            ti = new BufferInput(in);
            int b = ti.read();
            if (b == 60) {
                String string = "xml";
                return string;
            }
            int c = 0;
            while (b >= 0 && ++c < 4096) {
                if (b < 32 && !Token.ws(b) || b >= 128) {
                    String ex = "raw";
                    return ex;
                }
                b = ti.read();
            }
            String string = "text";
            return string;
        }
        catch (IOException ex) {
            return null;
        }
        finally {
            if (ti != null) {
                try {
                    ti.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

