/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DialogInput
extends BaseXDialog {
    private final BaseXTextField input;
    private final String old;
    private final BaseXBack buttons;
    private final BaseXLabel info;
    private final StringList db;
    private final int type;

    public DialogInput(String o, String tit, BaseXDialog d, int t) {
        super(d, tit);
        this.old = o;
        this.db = d.gui.context.databases().listDBs();
        this.type = t;
        String title = "";
        if (this.type == 0) {
            title = Text.TARGET_PATH + ": ";
        } else if (this.type == 1) {
            title = Text.NAME_OF_DB + ": ";
        } else if (this.type == 2) {
            title = Text.NAME_OF_DB_COPY + ": ";
        }
        this.set(new BaseXLabel(title, false, true).border(0, 0, 6, 0), "North");
        this.input = new BaseXTextField(o, this);
        this.info = new BaseXLabel(" ");
        BaseXBack p = new BaseXBack(new BorderLayout(0, 8));
        p.add((Component)this.input, "North");
        p.add((Component)this.info, "Center");
        this.set(p, "Center");
        this.buttons = this.newButtons(Text.B_OK, Text.B_CANCEL);
        this.set(this.buttons, "South");
        this.action(null);
        this.finish(null);
    }

    public String input() {
        return this.input.getText().trim();
    }

    @Override
    public void action(Object cmp) {
        String in = this.input();
        String msg = null;
        boolean bl = this.ok = this.type != 0 && (this.db.contains(in) || in.equals(this.old));
        if (this.ok) {
            msg = Util.info(Text.DB_EXISTS_X, in);
        }
        if (!this.ok) {
            boolean bl2 = this.type == 0 ? MetaData.normPath(in) != null : (this.ok = MetaData.validName(in, false));
            if (!this.ok) {
                msg = in.isEmpty() ? Text.ENTER_DB_NAME : Util.info(Text.INVALID_X, Text.NAME);
            }
        }
        this.info.setText(msg, this.type == 1 || this.type == 2 ? GUIConstants.Msg.ERROR : GUIConstants.Msg.WARN);
        DialogInput.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        if (this.ok) {
            super.close();
        }
    }
}

