/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.basex.core.Lang;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXSlider;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.view.ViewData;
import org.basex.io.IOFile;

public final class DialogPrefs
extends BaseXDialog {
    private static final int[] HITS = new int[]{10, 25, 100, 250, 1000, 2500, 10000, 25000, 100000, 250000, 1000000, -1};
    private static final String[][] LANGS = Lang.parse();
    final BaseXTextField path;
    final BaseXSlider limit;
    final BaseXLabel label;
    private final BaseXLabel creds;
    private final BaseXCombo lang;
    private final BaseXCheckBox focus;
    private final BaseXCheckBox names;
    private final BaseXCheckBox simpfd;
    private final BaseXCheckBox javalook;
    private final boolean oldShowNames;

    public DialogPrefs(GUI main) {
        super(main, Text.PREFERENCES);
        BaseXBack pp = new BaseXBack(new TableLayout(12, 1));
        pp.add(new BaseXLabel(Text.DATABASE_PATH, true, true));
        BaseXBack p = new BaseXBack(new TableLayout(1, 2, 8, 0));
        MainProp mprop = this.gui.context.mprop;
        GUIProp gprop = this.gui.gprop;
        this.path = new BaseXTextField(mprop.dbpath().path(), this);
        BaseXButton button = new BaseXButton(Text.BROWSE_D, this);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IOFile file = new BaseXFileChooser(Text.CHOOSE_DIR, DialogPrefs.this.path.getText(), DialogPrefs.this.gui).select(BaseXFileChooser.Mode.DOPEN);
                if (file != null) {
                    DialogPrefs.this.path.setText(file.dir());
                }
            }
        });
        p.add(this.path);
        p.add(button);
        pp.add(p);
        pp.add(new BaseXLabel(Text.GUI_INTERACTIONS, true, true).border(12, 0, 6, 0));
        this.javalook = new BaseXCheckBox(Text.JAVA_LF, gprop.is(GUIProp.JAVALOOK), this);
        pp.add(this.javalook);
        this.focus = new BaseXCheckBox(Text.RT_FOCUS, gprop.is(GUIProp.MOUSEFOCUS), this);
        pp.add(this.focus);
        this.simpfd = new BaseXCheckBox(Text.SIMPLE_FILE_CHOOSER, gprop.is(GUIProp.SIMPLEFD), this);
        pp.add(this.simpfd);
        boolean sn = gprop.is(GUIProp.SHOWNAME);
        this.names = new BaseXCheckBox(Text.SHOW_NAME_ATTS, sn, 6, this);
        Data data = this.gui.context.data();
        this.names.setEnabled(data != null && ViewData.nameID(data) != 0);
        this.oldShowNames = sn;
        pp.add(this.names);
        int mh = this.hitsForSlider();
        this.limit = new BaseXSlider(0, HITS.length - 1, mh, this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPrefs.this.action(DialogPrefs.this.limit);
            }
        });
        this.label = new BaseXLabel(" ");
        p = new BaseXBack(new TableLayout(1, 4, 12, 0));
        p.add(new BaseXLabel(Text.MAX_NO_OF_HITS + ":"));
        p.add(this.limit);
        p.add(this.label);
        pp.add(p);
        pp.add(new BaseXLabel(Text.LANGUAGE_RESTART, true, true).border(16, 0, 6, 0));
        this.lang = new BaseXCombo(this, LANGS[0]);
        this.lang.setSelectedItem(mprop.get(MainProp.LANG));
        this.creds = new BaseXLabel(" ");
        p = new BaseXBack(new TableLayout(1, 2, 12, 0));
        p.add(this.lang);
        p.add(this.creds);
        pp.add(p);
        this.set(pp, "Center");
        this.set(this.okCancel(), "South");
        this.action(null);
        this.finish(null);
    }

    @Override
    public void action(Object cmp) {
        int mh;
        this.creds.setText(Text.TRANSLATION + ": " + DialogPrefs.creds(this.lang.getSelectedItem().toString()));
        if (cmp == this.names) {
            this.gui.gprop.set(GUIProp.SHOWNAME, this.names.isSelected());
            this.gui.notify.layout();
        }
        this.label.setText((mh = this.hitsAsProperty()) == -1 ? Text.ALL : Integer.toString(mh));
    }

    @Override
    public void close() {
        MainProp mprop = this.gui.context.mprop;
        mprop.set(MainProp.LANG, this.lang.getSelectedItem().toString());
        String dbpath = this.path.getText();
        if (!mprop.get(MainProp.DBPATH).equals(dbpath)) {
            this.gui.execute(new Close());
        }
        mprop.set(MainProp.DBPATH, dbpath);
        mprop.write();
        int mh = this.hitsAsProperty();
        this.gui.context.prop.set(Prop.MAXHITS, mh);
        GUIProp gprop = this.gui.gprop;
        gprop.set(GUIProp.MOUSEFOCUS, this.focus.isSelected());
        gprop.set(GUIProp.SIMPLEFD, this.simpfd.isSelected());
        gprop.set(GUIProp.JAVALOOK, this.javalook.isSelected());
        gprop.set(GUIProp.MAXHITS, mh);
        gprop.write();
        this.dispose();
    }

    @Override
    public void cancel() {
        boolean sn = this.gui.gprop.is(GUIProp.SHOWNAME);
        this.gui.gprop.set(GUIProp.SHOWNAME, this.oldShowNames);
        if (sn != this.oldShowNames) {
            this.gui.notify.layout();
        }
        super.cancel();
    }

    private int hitsAsProperty() {
        return HITS[this.limit.value()];
    }

    private int hitsForSlider() {
        int mh = this.gui.gprop.num(Prop.MAXHITS);
        if (mh == -1) {
            mh = Integer.MAX_VALUE;
        }
        int hl = HITS.length - 1;
        int h = -1;
        while (++h < hl && HITS[h] < mh) {
        }
        return h;
    }

    static String creds(String lng) {
        for (int i = 0; i < LANGS[0].length; ++i) {
            if (!LANGS[0][i].equals(lng)) continue;
            return LANGS[1][i];
        }
        return "";
    }
}

