/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.value.DiskValues;
import org.basex.util.Num;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class UpdatableDiskValues
extends DiskValues {
    public UpdatableDiskValues(Data d, boolean txt) throws IOException {
        this(d, txt, txt ? "txt" : "atv");
    }

    private UpdatableDiskValues(Data d, boolean txt, String pref) throws IOException {
        super(d, txt, pref);
    }

    @Override
    protected int pre(int id) {
        return this.data.pre(id);
    }

    @Override
    public void flush() {
        this.idxl.write4(0L, this.size);
        super.flush();
    }

    @Override
    public void index(TokenObjMap<IntList> m) {
        int j;
        int last = this.size - 1;
        TokenList allkeys = new TokenList(m.keys()).sort(true);
        TokenList nkeys = new TokenList(m.size());
        int p = 0;
        for (byte[] key : allkeys) {
            p = this.get(key, p, last);
            if (p < 0) {
                p = -(p + 1);
                nkeys.add(key);
                continue;
            }
            this.appendIds(p, key, UpdatableDiskValues.diffs(m.get(key)));
        }
        int i = last;
        int pos = this.size + j;
        for (j = nkeys.size() - 1; j >= 0; --j) {
            byte[] key = nkeys.get(j);
            int ins = -(1 + this.get(key, 0, i));
            if (ins < 0) {
                throw new IllegalStateException("Key should not exist");
            }
            while (i >= ins) {
                this.idxr.write5((long)pos * 5L, this.idxr.read5((long)i * 5L));
                this.ctext.add(pos--, this.ctext.get(i--));
            }
            this.idxr.write5((long)pos * 5L, this.idxl.appendNums(UpdatableDiskValues.diffs(m.get(key))));
            this.ctext.add(pos--, key);
        }
        this.size += nkeys.size();
    }

    private void appendIds(int ix, byte[] key, int[] nids) {
        long oldpos = this.idxr.read5((long)ix * 5L);
        int numold = this.idxl.readNum(oldpos);
        int[] ids = new int[numold + nids.length];
        for (int i = 0; i < numold; ++i) {
            int v = this.idxl.readNum();
            nids[0] = nids[0] - v;
            ids[i] = v;
        }
        System.arraycopy(nids, 0, ids, numold, nids.length);
        long newpos = this.idxl.appendNums(ids);
        this.idxr.write5((long)ix * 5L, newpos);
        this.cache.add(key, ids.length, newpos + (long)Num.length(ids.length));
    }

    @Override
    public void delete(TokenObjMap<IntList> m) {
        TokenList allkeys = new TokenList(m.keys()).sort(true);
        IntList empty = new IntList(m.size());
        int p = 0;
        for (byte[] key : allkeys) {
            p = this.get(key, p, this.size - 1);
            if (p < 0) {
                p = -(p + 1);
                continue;
            }
            if (this.deleteIds(p, key, m.get(key).sort().toArray()) != 0) continue;
            empty.add(p);
        }
        if (!empty.isEmpty()) {
            this.deleteKeys(empty.toArray());
        }
    }

    private int deleteIds(int ix, byte[] key, int[] ids) {
        long pos = this.idxr.read5((long)ix * 5L);
        int numold = this.idxl.readNum(pos);
        if (numold == ids.length) {
            this.cache.delete(key);
            return 0;
        }
        int[] nids = new int[numold - ids.length];
        int i = 0;
        int j = 0;
        int cid = 0;
        int pid = 0;
        while (i < nids.length) {
            if (j < ids.length && ids[j] == (cid += this.idxl.readNum())) {
                ++j;
                continue;
            }
            nids[i++] = cid - pid;
            pid = cid;
        }
        this.idxl.writeNums(pos, nids);
        this.cache.add(key, nids.length, pos + (long)Num.length(nids.length));
        return nids.length;
    }

    private void deleteKeys(int[] keys) {
        int j = 0;
        int pos = keys[j++];
        for (int i = pos + 1; i < this.size; ++i) {
            if (j < keys.length && i == keys[j]) {
                ++j;
                continue;
            }
            this.idxr.write5((long)pos * 5L, this.idxr.read5((long)i * 5L));
            this.ctext.add(pos++, this.ctext.get(i));
        }
        this.size -= j;
    }

    @Override
    public void replace(byte[] o, byte[] n, int id) {
        int[] tmp;
        int p = this.get(o);
        if (p >= 0 && this.deleteIds(p, o, tmp = new int[]{id}) == 0) {
            this.cache.delete(o);
            tmp[0] = p;
            this.deleteKeys(tmp);
        }
        this.insertId(n, id);
    }

    private void insertId(byte[] key, int id) {
        int ix = this.get(key);
        if (ix < 0) {
            ix = -(ix + 1);
            for (int i = this.size; i > ix; --i) {
                this.idxr.write5((long)i * 5L, this.idxr.read5((long)(i - 1) * 5L));
            }
            this.idxr.write5((long)ix * 5L, this.idxl.appendNums(new int[]{id}));
            this.ctext.add(ix, key);
            ++this.size;
        } else {
            long pos = this.idxr.read5((long)ix * 5L);
            int num = this.idxl.readNum(pos);
            int[] ids = new int[num + 1];
            boolean notadded = true;
            int cid = 0;
            int j = -1;
            for (int i = 0; i < num; ++i) {
                int v = this.idxl.readNum();
                if (notadded && id < cid + v) {
                    ids[++j] = id - cid;
                    notadded = false;
                    v -= id - cid;
                    cid = id;
                }
                ids[++j] = v;
                cid += v;
            }
            if (notadded) {
                ids[ids.length - 1] = id - cid;
            }
            long newpos = this.idxl.appendNums(ids);
            this.idxr.write5((long)ix * 5L, newpos);
            this.cache.add(key, ids.length, newpos + (long)Num.length(ids.length));
        }
    }

    private static int[] diffs(IntList ids) {
        int[] a = ids.sort().toArray();
        for (int l = a.length - 1; l > 0; --l) {
            int n = l;
            a[n] = a[n] - a[l - 1];
        }
        return a;
    }
}

