/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.And;
import org.basex.query.expr.Arith;
import org.basex.query.expr.CAttr;
import org.basex.query.expr.CComm;
import org.basex.query.expr.CDoc;
import org.basex.query.expr.CElem;
import org.basex.query.expr.CNSpace;
import org.basex.query.expr.CPI;
import org.basex.query.expr.CTxt;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Castable;
import org.basex.query.expr.Catch;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Context;
import org.basex.query.expr.Except;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Extension;
import org.basex.query.expr.Filter;
import org.basex.query.expr.If;
import org.basex.query.expr.Instance;
import org.basex.query.expr.InterSect;
import org.basex.query.expr.List;
import org.basex.query.expr.LitMap;
import org.basex.query.expr.Or;
import org.basex.query.expr.Pragma;
import org.basex.query.expr.Quantifier;
import org.basex.query.expr.Range;
import org.basex.query.expr.Root;
import org.basex.query.expr.Switch;
import org.basex.query.expr.SwitchCase;
import org.basex.query.expr.Treat;
import org.basex.query.expr.Try;
import org.basex.query.expr.TypeCase;
import org.basex.query.expr.TypeSwitch;
import org.basex.query.expr.Unary;
import org.basex.query.expr.Union;
import org.basex.query.expr.VarRef;
import org.basex.query.flwor.For;
import org.basex.query.flwor.ForLet;
import org.basex.query.flwor.GFLWOR;
import org.basex.query.flwor.Group;
import org.basex.query.flwor.GroupSpec;
import org.basex.query.flwor.Let;
import org.basex.query.flwor.Order;
import org.basex.query.flwor.OrderBy;
import org.basex.query.flwor.OrderByExpr;
import org.basex.query.flwor.OrderByStable;
import org.basex.query.ft.FTAnd;
import org.basex.query.ft.FTContains;
import org.basex.query.ft.FTContent;
import org.basex.query.ft.FTDistance;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTExtensionSelection;
import org.basex.query.ft.FTMildNot;
import org.basex.query.ft.FTMode;
import org.basex.query.ft.FTNot;
import org.basex.query.ft.FTOptions;
import org.basex.query.ft.FTOr;
import org.basex.query.ft.FTOrder;
import org.basex.query.ft.FTScope;
import org.basex.query.ft.FTWeight;
import org.basex.query.ft.FTWindow;
import org.basex.query.ft.FTWords;
import org.basex.query.ft.ThesQuery;
import org.basex.query.ft.Thesaurus;
import org.basex.query.func.DynamicFunc;
import org.basex.query.func.Function;
import org.basex.query.func.Functions;
import org.basex.query.func.InlineFunc;
import org.basex.query.func.PartFunc;
import org.basex.query.func.UserFunc;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.path.Axis;
import org.basex.query.path.AxisStep;
import org.basex.query.path.Bang;
import org.basex.query.path.DocTest;
import org.basex.query.path.ExtTest;
import org.basex.query.path.NameTest;
import org.basex.query.path.Path;
import org.basex.query.path.Test;
import org.basex.query.up.expr.Delete;
import org.basex.query.up.expr.Insert;
import org.basex.query.up.expr.Rename;
import org.basex.query.up.expr.Replace;
import org.basex.query.up.expr.Transform;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.util.ExprList;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.TypedFunc;
import org.basex.query.util.Var;
import org.basex.query.util.VarStack;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.StopWords;
import org.basex.util.ft.Tokenizer;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public class QueryParser
extends InputParser {
    private static final byte[] URICHECK = new byte[0];
    private static final byte[] SKIPCHECK = new byte[0];
    private static final byte[][] KEYWORDS = new byte[][]{NodeType.ATT.string(), NodeType.COM.string(), NodeType.DOC.string(), NodeType.ELM.string(), Token.token("empty-sequence"), FuncType.ANY_FUN.string(), Token.token("if"), AtomType.ITEM.string(), NodeType.NSP.string(), NodeType.NOD.string(), NodeType.PI.string(), Token.token("schema-attribute"), Token.token("schema-element"), Token.token("switch"), NodeType.TXT.string(), Token.token("typeswitch")};
    final QueryContext ctx;
    private final TokenBuilder tok = new TokenBuilder();
    private final TokenList modules = new TokenList();
    private QNm module;
    private Err alter;
    private QNm alterFunc;
    private int ap;
    private final StringList serial = new StringList();
    private boolean declElem;
    private boolean declFunc;
    private boolean declColl;
    private boolean declConstr;
    private boolean declSpaces;
    private boolean declOrder;
    private boolean declReval;
    private boolean declGreat;
    private boolean declPres;
    private boolean declBase;
    private boolean declItem;
    private final ArrayList<QNmCheck> names = new ArrayList();

    public QueryParser(String in, QueryContext c) throws QueryException {
        super(in);
        this.ctx = c;
        String bind = this.ctx.context.prop.get(Prop.BINDINGS).trim();
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        boolean first = true;
        int sl = bind.length();
        for (int s = 0; s < sl; ++s) {
            char ch = bind.charAt(s);
            if (first) {
                if (ch == '=') {
                    first = false;
                    continue;
                }
                key.append(ch);
                continue;
            }
            if (ch == ',') {
                if (s + 1 == sl || bind.charAt(s + 1) != ',') {
                    this.bind(key, val);
                    key.setLength(0);
                    val.setLength(0);
                    first = true;
                    continue;
                }
                ++s;
            }
            val.append(ch);
        }
        this.bind(key, val);
    }

    private void bind(StringBuilder key, StringBuilder val) throws QueryException {
        String k = key.toString().trim();
        if (!k.isEmpty()) {
            this.ctx.bind(k, new Atm(val.toString()), null);
        }
    }

    public final Expr parse() throws QueryException {
        return this.parse(null);
    }

    public final Expr parse(byte[] uri) throws QueryException {
        byte[] empty;
        int cp;
        boolean hs;
        this.file(this.ctx.sc.baseIO(), this.ctx.context);
        if (!this.more()) {
            this.error(Err.QUERYEMPTY, new Object[0]);
        }
        for (int i = 0; i < this.il; i += hs ? Character.charCount(cp) : 1) {
            cp = this.input.charAt(i);
            boolean bl = hs = cp >= 55296;
            if (hs) {
                cp = this.input.codePointAt(i);
            }
            if (XMLToken.valid(cp)) continue;
            this.ip = i;
            this.error(Err.QUERYINV, cp);
        }
        Expr expr = this.module(uri);
        if (this.more()) {
            if (this.alter != null) {
                this.error();
            }
            String rest = this.rest();
            ++this.ip;
            if (uri != null) {
                this.error(Err.MODEXPR, rest);
            }
            this.error(Err.QUERYEND, rest);
        }
        this.assignURI(0);
        if (this.ctx.sc.nsElem != null) {
            this.ctx.sc.ns.add(Token.EMPTY, this.ctx.sc.nsElem, null);
        }
        if (this.ctx.sc.decFormats.get(empty = new QNm(Token.EMPTY).eqname()) == null) {
            this.ctx.sc.decFormats.add(empty, new DecFormatter());
        }
        this.ctx.funcs.check();
        if (this.ctx.updates != null) {
            this.ctx.funcs.checkUp();
            this.ctx.vars.checkUp();
            expr.checkUp();
        }
        return expr;
    }

    public final Expr module(byte[] u) throws QueryException {
        try {
            Expr expr = null;
            this.versionDecl();
            if (u == null) {
                int i = this.ip;
                if (this.wsConsumeWs("module", "namespace", null)) {
                    this.error(Err.MAINMOD, new Object[0]);
                }
                this.ip = i;
                expr = this.mainModule();
                if (expr == null) {
                    if (this.alter != null) {
                        this.error();
                    } else {
                        this.error(Err.EXPREMPTY, new Object[0]);
                    }
                }
            } else {
                expr = this.moduleDecl(u);
            }
            return expr;
        }
        catch (QueryException ex) {
            this.mark();
            ex.pos(this);
            throw ex;
        }
    }

    private void versionDecl() throws QueryException {
        int i = this.ip;
        if (!this.wsConsumeWs("xquery")) {
            return;
        }
        boolean version = this.wsConsumeWs("version");
        if (version) {
            String ver = Token.string(this.stringLiteral());
            if (ver.equals("1.0")) {
                this.ctx.sc.xquery3 = false;
            } else if (Token.eq(ver, "1.1", "3.0")) {
                this.ctx.sc.xquery3 = true;
            } else {
                this.error(Err.XQUERYVER, ver);
            }
        }
        if ((version || this.ctx.sc.xquery3) && this.wsConsumeWs("encoding")) {
            String enc = Token.string(this.stringLiteral());
            if (!Token.supported(enc)) {
                this.error(Err.XQUERYENC2, enc);
            }
        } else if (!version) {
            this.ip = i;
            return;
        }
        this.wsCheck(";");
    }

    private Expr mainModule() throws QueryException {
        this.prolog1();
        this.prolog2();
        return this.expr();
    }

    private QNm moduleDecl(byte[] u) throws QueryException {
        this.wsCheck("module");
        this.wsCheck("namespace");
        this.skipWS();
        byte[] name = this.ncName(Err.XPNAME);
        this.wsCheck("=");
        byte[] uri = this.stringLiteral();
        if (uri.length == 0) {
            this.error(Err.NSMODURI, new Object[0]);
        }
        this.module = new QNm(name, uri);
        this.ctx.sc.ns.add(name, uri, this.info());
        this.skipWS();
        this.check(59);
        this.prolog1();
        this.prolog2();
        if (u.length != 0 && !Token.eq(u, uri)) {
            this.error(Err.WRONGMODULE, this.module.uri(), this.file);
        }
        return this.module;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prolog1() throws QueryException {
        while (true) {
            block12: {
                int i;
                block13: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                i = this.ip;
                                                if (!this.wsConsumeWs("declare")) break block13;
                                                if (!this.wsConsumeWs("default")) break block14;
                                                if (!(this.defaultNamespaceDecl() || this.defaultCollationDecl() || this.emptyOrderDecl() || this.ctx.sc.xquery3 && this.decimalFormatDecl(true))) {
                                                    this.error(Err.DECLINCOMPLETE, new Object[0]);
                                                }
                                                break block12;
                                            }
                                            if (!this.wsConsumeWs("boundary-space")) break block15;
                                            this.boundarySpaceDecl();
                                            break block12;
                                        }
                                        if (!this.wsConsumeWs("base-uri")) break block16;
                                        this.baseURIDecl();
                                        break block12;
                                    }
                                    if (!this.wsConsumeWs("construction")) break block17;
                                    this.constructionDecl();
                                    break block12;
                                }
                                if (!this.wsConsumeWs("ordering")) break block18;
                                this.orderingModeDecl();
                                break block12;
                            }
                            if (!this.wsConsumeWs("revalidation")) break block19;
                            this.revalidationDecl();
                            break block12;
                        }
                        if (!this.wsConsumeWs("copy-namespaces")) break block20;
                        this.copyNamespacesDecl();
                        break block12;
                    }
                    if (this.ctx.sc.xquery3 && this.wsConsumeWs("decimal-format")) {
                        this.decimalFormatDecl(false);
                        break block12;
                    } else if (this.wsConsumeWs("namespace")) {
                        this.namespaceDecl();
                        break block12;
                    } else {
                        if (!this.wsConsumeWs("ft-option")) {
                            this.ip = i;
                            return;
                        }
                        FTOpt fto = new FTOpt();
                        while (this.ftMatchOption(fto)) {
                        }
                        this.ctx.ftOpt().copy(fto);
                    }
                    break block12;
                }
                if (!this.wsConsumeWs("import")) {
                    return;
                }
                if (this.wsConsumeWs("schema")) {
                    this.schemaImport();
                } else {
                    if (!this.wsConsumeWs("module")) {
                        this.ip = i;
                        return;
                    }
                    this.moduleImport();
                }
            }
            this.skipWS();
            this.check(59);
        }
    }

    private void prolog2() throws QueryException {
        while (true) {
            int i = this.ip;
            if (!this.wsConsumeWs("declare")) {
                return;
            }
            if (this.ctx.sc.xquery3 && this.wsConsumeWs("context")) {
                this.contextItemDecl();
            } else if (this.wsConsumeWs("option")) {
                this.optionDecl();
            } else if (this.wsConsumeWs("default")) {
                this.error(Err.PROLOGORDER, new Object[0]);
            } else {
                Ann ann = new Ann();
                while (true) {
                    if (this.wsConsumeWs("updating")) {
                        this.addAnnotation(ann, Ann.Q_UPDATING, Empty.SEQ);
                        continue;
                    }
                    if (!this.ctx.sc.xquery3 || !this.consume(37)) break;
                    this.annotation(ann);
                }
                if (this.wsConsumeWs("variable")) {
                    if (ann.contains(Ann.Q_UPDATING)) {
                        this.error(Err.UPDATINGVAR, new Object[0]);
                    }
                    this.varDecl(ann);
                } else if (this.wsConsumeWs("function")) {
                    this.functionDecl(ann);
                } else if (!ann.isEmpty()) {
                    this.error(Err.VARFUNC, new Object[0]);
                } else {
                    this.ip = i;
                    return;
                }
            }
            this.skipWS();
            this.check(59);
        }
    }

    private Ann annotations() throws QueryException {
        Ann ann = new Ann();
        while (this.wsConsume("%")) {
            this.annotation(ann);
        }
        this.skipWS();
        return ann;
    }

    private void annotation(Ann ann) throws QueryException {
        QNm name = this.eQName(Err.QNAMEINV, this.ctx.sc.nsFunc);
        ValueBuilder vb = new ValueBuilder(1);
        if (this.wsConsumeWs("(")) {
            do {
                Item it;
                if ((it = this.literal()) == null) {
                    this.error(Err.ANNVALUE, new Object[0]);
                }
                vb.add(it);
            } while (this.wsConsumeWs(","));
            this.wsCheck(")");
        }
        this.skipWS();
        this.addAnnotation(ann, name, vb.value());
    }

    private void addAnnotation(Ann ann, QNm name, Value value) throws QueryException {
        if (name.eq(Ann.Q_UPDATING)) {
            if (ann.contains(Ann.Q_UPDATING)) {
                this.error(Err.DUPLUPD, new Object[0]);
            }
        } else if (name.eq(Ann.Q_PUBLIC) || name.eq(Ann.Q_PRIVATE)) {
            if (ann.contains(Ann.Q_PUBLIC) || ann.contains(Ann.Q_PRIVATE)) {
                this.error(Err.DUPLVIS, new Object[0]);
            }
        } else if (NSGlobal.reserved(name.uri())) {
            this.error(Err.ANNRES, name);
        }
        ann.add(name, value);
    }

    private void namespaceDecl() throws QueryException {
        byte[] pref = this.ncName(Err.XPNAME);
        this.wsCheck("=");
        byte[] uri = this.stringLiteral();
        if (this.ctx.sc.ns.staticURI(pref) != null) {
            this.error(Err.DUPLNSDECL, new Object[]{pref});
        }
        this.ctx.sc.ns.add(pref, uri, this.info());
    }

    private void revalidationDecl() throws QueryException {
        if (this.declReval) {
            this.error(Err.DUPLREVAL, new Object[0]);
        }
        this.declReval = true;
        if (this.wsConsumeWs("strict") || this.wsConsumeWs("lax")) {
            this.error(Err.NOREVAL, new Object[0]);
        }
        this.wsCheck("skip");
    }

    private void boundarySpaceDecl() throws QueryException {
        if (this.declSpaces) {
            this.error(Err.DUPLBOUND, new Object[0]);
        }
        this.declSpaces = true;
        boolean spaces = this.wsConsumeWs("preserve");
        if (!spaces) {
            this.wsCheck("strip");
        }
        this.ctx.sc.spaces = spaces;
    }

    private boolean defaultNamespaceDecl() throws QueryException {
        boolean elem = this.wsConsumeWs("element");
        if (!elem && !this.wsConsumeWs("function")) {
            return false;
        }
        this.wsCheck("namespace");
        byte[] uri = this.stringLiteral();
        if (Token.eq(QueryText.XMLURI, uri)) {
            this.error(Err.BINDXMLURI, uri, Token.XML);
        }
        if (Token.eq(QueryText.XMLNSURI, uri)) {
            this.error(Err.BINDXMLURI, uri, Token.XMLNS);
        }
        if (elem) {
            if (this.declElem) {
                this.error(Err.DUPLNS, new Object[0]);
            }
            this.declElem = true;
            this.ctx.sc.nsElem = uri.length == 0 ? null : uri;
        } else {
            if (this.declFunc) {
                this.error(Err.DUPLNS, new Object[0]);
            }
            this.declFunc = true;
            this.ctx.sc.nsFunc = uri.length == 0 ? null : uri;
        }
        return true;
    }

    private void optionDecl() throws QueryException {
        this.skipWS();
        QNm name = this.eQName(Err.QNAMEINV, URICHECK);
        byte[] val = this.stringLiteral();
        if (this.ctx.sc.xquery3 && Token.eq(name.prefix(), QueryText.OUTPUT)) {
            String key = Token.string(name.local());
            if (this.module != null) {
                this.error(Err.MODOUT, new Object[0]);
            }
            if (this.ctx.serProp == null) {
                this.ctx.serProp = new SerializerProp();
            }
            if (this.ctx.serProp.get(key) == null) {
                this.error(Err.OUTWHICH, key);
            }
            if (this.serial.contains(key)) {
                this.error(Err.OUTDUPL, key);
            }
            this.ctx.serProp.set(key, Token.string(val));
            this.serial.add(key);
        } else if (Token.eq(name.prefix(), QueryText.DB)) {
            String key = Token.string(Token.uc(name.local()));
            Object obj = this.ctx.context.prop.get(key);
            if (obj == null) {
                this.error(Err.BASX_OPTIONS, key);
            }
            this.ctx.globalOpt.put(key, obj);
            this.ctx.dbOptions.put(key, Token.string(val));
        }
    }

    private void orderingModeDecl() throws QueryException {
        if (this.declOrder) {
            this.error(Err.DUPLORD, new Object[0]);
        }
        this.declOrder = true;
        this.ctx.sc.ordered = this.wsConsumeWs("ordered");
        if (!this.ctx.sc.ordered) {
            this.wsCheck("unordered");
        }
    }

    private boolean emptyOrderDecl() throws QueryException {
        if (!this.wsConsumeWs("order")) {
            return false;
        }
        this.wsCheck("empty");
        if (this.declGreat) {
            this.error(Err.DUPLORDEMP, new Object[0]);
        }
        this.declGreat = true;
        this.ctx.sc.orderGreatest = this.wsConsumeWs("greatest");
        if (!this.ctx.sc.orderGreatest) {
            this.wsCheck("least");
        }
        return true;
    }

    private void copyNamespacesDecl() throws QueryException {
        if (this.declPres) {
            this.error(Err.DUPLCOPYNS, new Object[0]);
        }
        this.declPres = true;
        this.ctx.sc.nsPreserve = this.wsConsumeWs("preserve");
        if (!this.ctx.sc.nsPreserve) {
            this.wsCheck("no-preserve");
        }
        this.wsCheck(",");
        this.ctx.sc.nsInherit = this.wsConsumeWs("inherit");
        if (!this.ctx.sc.nsInherit) {
            this.wsCheck("no-inherit");
        }
    }

    private boolean decimalFormatDecl(boolean def) throws QueryException {
        int n;
        QNm name;
        if (def && !this.wsConsumeWs("decimal-format")) {
            return false;
        }
        QNm qNm = name = def ? new QNm() : this.eQName(Err.QNAMEINV, null);
        if (this.ctx.sc.decFormats.get(name.eqname()) != null) {
            this.error(Err.DECDUPL, new Object[0]);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        do {
            n = map.size();
            this.skipWS();
            String prop = Token.string(this.ncName(null));
            for (String s : QueryText.DECFORMATS) {
                if (!prop.equals(s)) continue;
                if (map.get(s) != null) {
                    this.error(Err.DECDUPLPROP, s);
                }
                this.wsCheck("=");
                map.put(s, Token.string(this.stringLiteral()));
                break;
            }
            if (!map.isEmpty()) continue;
            this.error(Err.NODECLFORM, prop);
        } while (n != map.size());
        this.ctx.sc.decFormats.add(name.eqname(), new DecFormatter(this.info(), map));
        return true;
    }

    private boolean defaultCollationDecl() throws QueryException {
        if (!this.wsConsumeWs("collation")) {
            return false;
        }
        if (this.declColl) {
            this.error(Err.DUPLCOLL, new Object[0]);
        }
        this.declColl = true;
        byte[] cl = this.ctx.sc.baseURI().resolve(Uri.uri(this.stringLiteral())).string();
        if (!Token.eq(QueryText.URLCOLL, cl)) {
            this.error(Err.COLLWHICH, new Object[]{cl});
        }
        return true;
    }

    private void baseURIDecl() throws QueryException {
        if (this.declBase) {
            this.error(Err.DUPLBASE, new Object[0]);
        }
        this.declBase = true;
        byte[] base = this.stringLiteral();
        if (base.length != 0) {
            this.ctx.sc.baseURI(Token.string(base));
        }
    }

    private void schemaImport() throws QueryException {
        if (this.wsConsumeWs("namespace")) {
            this.ncName(Err.XPNAME);
            this.wsCheck("=");
        } else if (this.wsConsumeWs("default")) {
            this.wsCheck("element");
            this.wsCheck("namespace");
        }
        byte[] ns = this.stringLiteral();
        if (ns.length == 0) {
            this.error(Err.NSEMPTY, new Object[0]);
        }
        if (this.wsConsumeWs("at")) {
            do {
                this.stringLiteral();
            } while (this.wsConsumeWs(","));
        }
        this.error(Err.IMPLSCHEMA, new Object[0]);
    }

    private void moduleImport() throws QueryException {
        byte[] uri;
        byte[] ns = Token.EMPTY;
        if (this.wsConsumeWs("namespace")) {
            ns = this.ncName(Err.XPNAME);
            this.wsCheck("=");
        }
        if ((uri = Token.trim(this.stringLiteral())).length == 0) {
            this.error(Err.NSMODURI, new Object[0]);
        }
        if (this.modules.contains(uri)) {
            this.error(Err.DUPLMODULE, new Object[]{uri});
        }
        this.modules.add(uri);
        if (ns != Token.EMPTY) {
            this.ctx.sc.ns.add(ns, uri, this.info());
        }
        try {
            if (this.wsConsumeWs("at")) {
                do {
                    this.module(this.stringLiteral(), uri);
                } while (this.wsConsumeWs(","));
                return;
            }
            byte[] path = this.ctx.modDeclared.get(uri);
            if (path != null) {
                this.module(path, uri);
                return;
            }
            for (byte[] u : Function.URIS.values()) {
                if (!Token.eq(uri, u)) continue;
                return;
            }
            if (this.ctx.modules.addImport(uri, this.info(), this)) {
                return;
            }
            this.error(Err.NOMODULE, new Object[]{uri});
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            this.error(Err.CIRCMODULE, new Object[0]);
        }
    }

    public void module(byte[] path, byte[] uri) throws QueryException {
        IO io = this.ctx.sc.io(Token.string(path));
        byte[] p = Token.token(io.path());
        byte[] u = this.ctx.modParsed.get(p);
        if (u != null) {
            if (!Token.eq(uri, u)) {
                this.error(Err.WRONGMODULE, uri, this.ctx.context.user.has(Perm.ADMIN) ? io.path() : io.name());
            }
            return;
        }
        this.ctx.modParsed.add(p, uri);
        String qu = null;
        try {
            qu = Token.string(io.read());
        }
        catch (IOException ex) {
            this.error(Err.NOMODULEFILE, this.ctx.context.user.has(Perm.ADMIN) ? io.path() : io.name());
        }
        StaticContext sc = this.ctx.sc;
        this.ctx.sc = new StaticContext();
        this.ctx.sc.baseURI(io.path());
        this.ctx.sc.xquery3 = sc.xquery3;
        new QueryParser(qu, this.ctx).parse(uri);
        this.ctx.sc = sc;
    }

    private void contextItemDecl() throws QueryException {
        this.wsCheck("item");
        if (this.declItem) {
            this.error(Err.DUPLITEM, new Object[0]);
        }
        this.declItem = true;
        if (this.module != null) {
            this.error(Err.DECITEM, new Object[0]);
        }
        Type type = this.ctx.sc.initType = this.wsConsumeWs("as") ? this.itemType().type : null;
        if (!this.wsConsumeWs("external")) {
            this.wsCheck(":=");
        } else if (!this.wsConsumeWs(":=")) {
            return;
        }
        this.ctx.ctxItem = this.check(this.single(), Err.NOVARDECL);
        if (this.ctx.ctxItem.uses(Expr.Use.UPD)) {
            Err.UPCTX.thrw(this.info(), this.ctx.ctxItem);
        }
    }

    private void varDecl(Ann ann) throws QueryException {
        Var old;
        Var v = this.typedVar(ann);
        if (this.module != null && !Token.eq(v.name.uri(), this.module.uri())) {
            this.error(Err.MODNS, v);
        }
        if ((old = this.ctx.vars.get(v.name)) != null && old.declared) {
            this.error(Err.VARDEFINE, old);
        }
        (old != null ? old : v).declared = true;
        if (this.wsConsumeWs("external")) {
            if (old != null && v.type != null) {
                old.reset(v.type, this.ctx);
            }
            if (this.ctx.sc.xquery3 && this.wsConsumeWs(":=")) {
                v.bind(this.check(this.single(), Err.NOVARDECL), this.ctx);
            }
        } else {
            this.wsCheck(":=");
            v.bind(this.check(this.single(), Err.NOVARDECL), this.ctx);
        }
        if (old == null) {
            this.ctx.vars.updateGlobal(v);
        }
    }

    private Var typedVar(Ann ann) throws QueryException {
        return Var.create(this.ctx, this.info(), this.varName(), this.optAsType(), ann);
    }

    private SeqType optAsType() throws QueryException {
        return this.wsConsumeWs("as") ? this.sequenceType() : null;
    }

    private void constructionDecl() throws QueryException {
        if (this.declConstr) {
            this.error(Err.DUPLCONS, new Object[0]);
        }
        this.declConstr = true;
        this.ctx.sc.strip = this.wsConsumeWs("strip");
        if (!this.ctx.sc.strip) {
            this.wsCheck("preserve");
        }
    }

    private void functionDecl(Ann ann) throws QueryException {
        QNm name = this.eQName(Err.FUNCNAME, this.ctx.sc.nsFunc);
        if (QueryParser.keyword(name)) {
            this.error(Err.RESERVED, name);
        }
        if (this.module != null && !Token.eq(name.uri(), this.module.uri())) {
            this.error(Err.MODNS, name);
        }
        this.wsCheck("(");
        VarStack vl = this.ctx.vars.cache(4);
        Var[] args = this.paramList();
        this.wsCheck(")");
        UserFunc func = new UserFunc(this.info(), name, args, this.optAsType(), ann, true);
        if (func.updating) {
            this.ctx.updating(true);
        }
        if (!this.wsConsumeWs("external")) {
            this.ctx.funcs.add(func, this.info());
            func.expr = this.enclosed(Err.NOFUNBODY);
            this.ctx.vars.reset(vl);
        }
    }

    private static boolean keyword(QNm name) {
        if (name.hasPrefix()) {
            return false;
        }
        byte[] str = name.string();
        for (byte[] key : KEYWORDS) {
            if (!Token.eq(key, str)) continue;
            return true;
        }
        return false;
    }

    private Var[] paramList() throws QueryException {
        Var[] args = new Var[]{};
        this.skipWS();
        while (true) {
            if (this.curr() != '$') {
                if (args.length == 0) break;
                this.check(36);
            }
            Var var = this.typedVar(null);
            this.ctx.vars.add(var);
            for (Var v : args) {
                if (!v.name.eq(var.name)) continue;
                this.error(Err.FUNCDUPL, var);
            }
            args = Array.add(args, var);
            if (!this.consume(44)) break;
            this.skipWS();
        }
        return args;
    }

    private Expr enclosed(Err err) throws QueryException {
        this.wsCheck("{");
        Expr e = this.check(this.expr(), err);
        this.wsCheck("}");
        return e;
    }

    private Expr expr() throws QueryException {
        Expr e = this.single();
        if (e == null) {
            if (this.more()) {
                return null;
            }
            if (this.alter != null) {
                this.error();
            } else {
                this.error(Err.NOEXPR, new Object[0]);
            }
        }
        if (!this.wsConsume(",")) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.single());
        } while (this.wsConsume(","));
        return new List(this.info(), el.finish());
    }

    private Expr single() throws QueryException {
        this.alter = null;
        Expr e = this.flwor();
        if (e == null) {
            e = this.quantified();
        }
        if (e == null) {
            e = this.switchh();
        }
        if (e == null) {
            e = this.typeswitch();
        }
        if (e == null) {
            e = this.iff();
        }
        if (e == null) {
            e = this.tryCatch();
        }
        if (e == null) {
            e = this.insert();
        }
        if (e == null) {
            e = this.deletee();
        }
        if (e == null) {
            e = this.rename();
        }
        if (e == null) {
            e = this.replace();
        }
        if (e == null) {
            e = this.transform();
        }
        if (e == null) {
            e = this.or();
        }
        return e;
    }

    private Expr flwor() throws QueryException {
        int s = this.ctx.vars.size();
        ForLet[] fl = this.forLet();
        if (fl == null) {
            return null;
        }
        Expr where = null;
        if (this.wsConsumeWs("where")) {
            this.ap = this.ip;
            where = this.check(this.single(), Err.NOWHERE);
            this.alter = Err.NOWHERE;
        }
        Group group = null;
        if (this.ctx.sc.xquery3 && this.wsConsumeWs("group")) {
            this.wsCheck("by");
            this.ap = this.ip;
            GroupSpec[] grp = null;
            do {
                grp = this.groupSpec(fl, grp);
            } while (this.wsConsume(","));
            ArrayList<Var> ng = new ArrayList<Var>();
            TokenSet set = new TokenSet();
            for (GroupSpec spec : grp) {
                if (spec.assign) continue;
                set.add(spec.var.name.eqname());
            }
            int i = fl.length;
            while (--i >= 0) {
                for (Var v : fl[i].vars()) {
                    byte[] eqn = v.name.eqname();
                    if (set.contains(eqn)) continue;
                    ng.add(v);
                    set.add(eqn);
                }
            }
            Var[] ngrp = new Var[ng.size()];
            int i2 = ng.size();
            while (--i2 >= 0) {
                Var v = (Var)ng.get(i2);
                ngrp[i2] = Var.create(this.ctx, this.info(), v.name, v.type != null && v.type.one() ? SeqType.get(v.type.type, SeqType.Occ.ONE_MORE) : null, null);
                this.ctx.vars.add(ngrp[i2]);
            }
            group = new Group(grp[0].info, grp, new Var[][]{ng.toArray(new Var[ng.size()]), ngrp});
            this.alter = Err.GRPBY;
        }
        Order order = null;
        boolean stable = this.wsConsumeWs("stable");
        if (stable) {
            this.wsCheck("order");
        }
        if (stable || this.wsConsumeWs("order")) {
            this.wsCheck("by");
            this.ap = this.ip;
            OrderBy[] ob = null;
            do {
                ob = this.orderSpec(ob);
            } while (this.wsConsume(","));
            if (ob != null) {
                ob = Array.add(ob, new OrderByStable(this.info()));
                order = new Order(ob[0].info, ob);
            }
            this.alter = Err.ORDERBY;
        }
        if (!this.wsConsumeWs("return")) {
            if (this.alter != null) {
                this.error();
            }
            this.error(where == null ? Err.FLWORWHERE : (order == null ? Err.FLWORORD : Err.FLWORRET), new Object[0]);
        }
        Expr ret = this.check(this.single(), Err.NORETURN);
        this.ctx.vars.size(s);
        return GFLWOR.get(fl, where, order, group, ret, this.info());
    }

    private ForLet[] forLet() throws QueryException {
        ForLet[] fl = null;
        boolean comma = false;
        while (true) {
            boolean fr;
            boolean score;
            boolean bl = score = !(fr = this.wsConsumeWs("for", "$", Err.NOFOR)) && this.wsConsumeWs("let", "score", Err.NOLET);
            if (score) {
                this.wsCheck("score");
            } else if (!fr && !this.wsConsumeWs("let", "$", Err.NOLET)) {
                return fl;
            }
            do {
                if (comma && !fr) {
                    score = this.wsConsumeWs("score");
                }
                QNm name = this.varName();
                SeqType type = score ? SeqType.DBL : this.optAsType();
                Var var = Var.create(this.ctx, this.info(), name, type, null);
                Var ps = fr && this.wsConsumeWs("at") ? Var.create(this.ctx, this.info(), this.varName(), SeqType.ITR, null) : null;
                Var sc = fr && this.wsConsumeWs("score") ? Var.create(this.ctx, this.info(), this.varName(), SeqType.DBL, null) : null;
                this.wsCheck(fr ? "in" : ":=");
                Expr e = this.check(this.single(), Err.NOVARDECL);
                this.ctx.vars.add(var);
                if (ps != null) {
                    if (name.eq(ps.name)) {
                        this.error(Err.DUPLVAR, var);
                    }
                    this.ctx.vars.add(ps);
                }
                if (sc != null) {
                    if (name.eq(sc.name)) {
                        this.error(Err.DUPLVAR, var);
                    }
                    if (ps != null && ps.name.eq(sc.name)) {
                        this.error(Err.DUPLVAR, ps);
                    }
                    this.ctx.vars.add(sc);
                }
                fl = fl == null ? new ForLet[1] : Arrays.copyOf(fl, fl.length + 1);
                fl[fl.length - 1] = fr ? new For(this.info(), e, var, ps, sc) : new Let(this.info(), e, var, score);
                score = false;
                comma = true;
            } while (this.wsConsume(","));
            comma = false;
        }
    }

    private OrderBy[] orderSpec(OrderBy[] order) throws QueryException {
        OrderBy[] orderByArray;
        byte[] coll;
        boolean least;
        Expr e = this.check(this.single(), Err.ORDERBY);
        boolean desc = false;
        if (!this.wsConsumeWs("ascending")) {
            desc = this.wsConsumeWs("descending");
        }
        boolean bl = least = !this.ctx.sc.orderGreatest;
        if (this.wsConsumeWs("empty")) {
            boolean bl2 = least = !this.wsConsumeWs("greatest");
            if (least) {
                this.wsCheck("least");
            }
        }
        if (this.wsConsumeWs("collation") && !Token.eq(QueryText.URLCOLL, coll = this.stringLiteral())) {
            this.error(Err.WHICHCOLL, new Object[]{coll});
        }
        if (e.isEmpty()) {
            return order;
        }
        OrderByExpr ord = new OrderByExpr(this.info(), e, desc, least);
        if (order == null) {
            OrderBy[] orderByArray2 = new OrderBy[1];
            orderByArray = orderByArray2;
            orderByArray2[0] = ord;
        } else {
            orderByArray = Array.add(order, ord);
        }
        return orderByArray;
    }

    private GroupSpec[] groupSpec(ForLet[] fl, GroupSpec[] group) throws QueryException {
        GroupSpec[] groupSpecArray;
        byte[] coll;
        boolean assign;
        Expr by;
        InputInfo ii = this.info();
        QNm name = this.varName();
        SeqType type = this.optAsType();
        Var var = Var.create(this.ctx, ii, name, type, null);
        if (type != null || this.wsConsume(":=")) {
            if (type != null) {
                this.wsCheck(":=");
            }
            by = this.check(this.single(), Err.NOVARDECL);
            assign = true;
        } else {
            Var v = this.checkVar(var.name, Err.GVARNOTDEFINED);
            boolean dec = false;
            for (ForLet f : fl) {
                if (!f.declares(v)) continue;
                dec = true;
                break;
            }
            if (!dec) {
                throw this.error(Err.GVARNOTDEFINED, v);
            }
            by = new VarRef(ii, v);
            assign = false;
        }
        if (this.wsConsumeWs("collation") && !Token.eq(QueryText.URLCOLL, coll = this.stringLiteral())) {
            throw this.error(Err.WHICHCOLL, new Object[]{coll});
        }
        this.ctx.vars.add(var);
        GroupSpec grp = new GroupSpec(ii, var, by, assign);
        if (group == null) {
            GroupSpec[] groupSpecArray2 = new GroupSpec[1];
            groupSpecArray = groupSpecArray2;
            groupSpecArray2[0] = grp;
        } else {
            groupSpecArray = Array.add(group, grp);
        }
        return groupSpecArray;
    }

    private Expr quantified() throws QueryException {
        boolean some = this.wsConsumeWs("some", "$", Err.NOSOME);
        if (!some && !this.wsConsumeWs("every", "$", Err.NOSOME)) {
            return null;
        }
        int s = this.ctx.vars.size();
        For[] fl = new For[]{};
        do {
            Var var = this.typedVar(null);
            this.wsCheck("in");
            Expr e = this.check(this.single(), Err.NOSOME);
            this.ctx.vars.add(var);
            fl = Array.add(fl, new For(this.info(), e, var));
        } while (this.wsConsume(","));
        this.wsCheck("satisfies");
        Expr e = this.check(this.single(), Err.NOSOME);
        this.ctx.vars.size(s);
        return new Quantifier(this.info(), fl, e, !some);
    }

    private Expr switchh() throws QueryException {
        ExprList cases;
        if (!this.ctx.sc.xquery3 || !this.wsConsumeWs("switch", "(", Err.TYPEPAR)) {
            return null;
        }
        this.wsCheck("(");
        Expr expr = this.check(this.expr(), Err.NOSWITCH);
        SwitchCase[] exprs = new SwitchCase[]{};
        this.wsCheck(")");
        do {
            cases = new ExprList(null);
            while (this.wsConsumeWs("case")) {
                this.add(cases, this.single());
            }
            if (cases.size() == 1) {
                if (exprs.length == 0) {
                    this.error(Err.WRONGCHAR, "case", this.found());
                }
                this.wsCheck("default");
            }
            this.wsCheck("return");
            cases.set(0, this.single());
            exprs = Array.add(exprs, new SwitchCase(this.info(), cases.finish()));
        } while (cases.size() != 1);
        return new Switch(this.info(), expr, exprs);
    }

    private Expr typeswitch() throws QueryException {
        boolean cs;
        if (!this.wsConsumeWs("typeswitch", "(", Err.TYPEPAR)) {
            return null;
        }
        this.wsCheck("(");
        Expr ts = this.check(this.expr(), Err.NOTYPESWITCH);
        this.wsCheck(")");
        TypeCase[] cases = new TypeCase[]{};
        int s = this.ctx.vars.size();
        do {
            if (!(cs = this.wsConsumeWs("case"))) {
                this.wsCheck("default");
            }
            this.skipWS();
            QNm name = null;
            if (this.curr(36)) {
                name = this.varName();
                if (cs) {
                    this.wsCheck("as");
                }
            }
            Var v = Var.create(this.ctx, this.info(), name, cs ? this.sequenceType() : null, null);
            if (name != null) {
                this.ctx.vars.add(v);
            }
            this.wsCheck("return");
            Expr ret = this.check(this.single(), Err.NOTYPESWITCH);
            cases = Array.add(cases, new TypeCase(this.info(), v, ret));
            this.ctx.vars.size(s);
        } while (cs);
        if (cases.length == 1) {
            this.error(Err.NOTYPESWITCH, new Object[0]);
        }
        return new TypeSwitch(this.info(), ts, cases);
    }

    private Expr iff() throws QueryException {
        if (!this.wsConsumeWs("if", "(", Err.IFPAR)) {
            return null;
        }
        this.wsCheck("(");
        Expr iff = this.check(this.expr(), Err.NOIF);
        this.wsCheck(")");
        if (!this.wsConsumeWs("then")) {
            this.error(Err.NOIF, new Object[0]);
        }
        Expr thn = this.check(this.single(), Err.NOIF);
        if (!this.wsConsumeWs("else")) {
            this.error(Err.NOIF, new Object[0]);
        }
        Expr els = this.check(this.single(), Err.NOIF);
        return new If(this.info(), iff, thn, els);
    }

    private Expr or() throws QueryException {
        Expr e = this.and();
        if (!this.wsConsumeWs("or")) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.and());
        } while (this.wsConsumeWs("or"));
        return new Or(this.info(), el.finish());
    }

    private Expr and() throws QueryException {
        Expr e = this.comparison();
        if (!this.wsConsumeWs("and")) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.comparison());
        } while (this.wsConsumeWs("and"));
        return new And(this.info(), el.finish());
    }

    private Expr comparison() throws QueryException {
        Expr e = this.ftContains();
        if (e != null) {
            for (CmpV.OpV opV : CmpV.OpV.values()) {
                if (!this.wsConsumeWs(opV.name)) continue;
                return new CmpV(e, this.check(this.ftContains(), Err.CMPEXPR), opV, this.info());
            }
            for (Enum enum_ : CmpN.OpN.values()) {
                if (!this.wsConsumeWs(((CmpN.OpN)enum_).name)) continue;
                return new CmpN(e, this.check(this.ftContains(), Err.CMPEXPR), (CmpN.OpN)enum_, this.info());
            }
            for (Enum enum_ : CmpG.OpG.values()) {
                if (!this.wsConsumeWs(((CmpG.OpG)enum_).name)) continue;
                return new CmpG(e, this.check(this.ftContains(), Err.CMPEXPR), (CmpG.OpG)enum_, this.info());
            }
        }
        return e;
    }

    private Expr ftContains() throws QueryException {
        Expr e = this.stringConcat();
        int i = this.ip;
        if (this.consume(61) && this.consume(62) || this.consume(60) && this.consume(45)) {
            this.skipWS();
        } else if (!this.wsConsumeWs("contains") || !this.wsConsumeWs("text")) {
            this.ip = i;
            return e;
        }
        FTExpr select = this.ftSelection(false);
        if (this.wsConsumeWs("without")) {
            this.wsCheck("content");
            this.union();
            this.error(Err.FTIGNORE, new Object[0]);
        }
        return new FTContains(e, select, this.info());
    }

    private Expr stringConcat() throws QueryException {
        Expr e = this.range();
        if (e == null || !this.consume("||")) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.range());
        } while (this.wsConsume("||"));
        return Function.CONCAT.get(this.info(), el.finish());
    }

    private Expr range() throws QueryException {
        Expr e = this.additive();
        if (!this.wsConsumeWs("to")) {
            return e;
        }
        return new Range(this.info(), e, this.check(this.additive(), Err.INCOMPLETE));
    }

    private Expr additive() throws QueryException {
        Expr e = this.multiplicative();
        while (e != null) {
            Calc c;
            Calc calc = this.consume(43) ? Calc.PLUS : (c = this.consume(45) ? Calc.MINUS : null);
            if (c == null) break;
            e = new Arith(this.info(), e, this.check(this.multiplicative(), Err.CALCEXPR), c);
        }
        return e;
    }

    private Expr multiplicative() throws QueryException {
        Expr e = this.union();
        while (e != null) {
            Calc c;
            Calc calc = this.consume(42) ? Calc.MULT : (this.wsConsumeWs("div") ? Calc.DIV : (this.wsConsumeWs("idiv") ? Calc.IDIV : (c = this.wsConsumeWs("mod") ? Calc.MOD : null)));
            if (c == null) break;
            e = new Arith(this.info(), e, this.check(this.union(), Err.CALCEXPR), c);
        }
        return e;
    }

    private Expr union() throws QueryException {
        Expr e = this.intersect();
        if (e == null || !this.isUnion()) {
            return e;
        }
        ExprList el = new ExprList(e);
        do {
            this.add(el, this.intersect());
        } while (this.isUnion());
        return new Union(this.info(), el.finish());
    }

    private boolean isUnion() throws QueryException {
        if (this.wsConsumeWs("union")) {
            return true;
        }
        int i = this.ip;
        if (this.consume("|") && !this.consume("|")) {
            return true;
        }
        this.ip = i;
        return false;
    }

    private Expr intersect() throws QueryException {
        Expr e = this.instanceoff();
        if (this.wsConsumeWs("intersect")) {
            ExprList el = new ExprList(e);
            do {
                this.add(el, this.instanceoff());
            } while (this.wsConsumeWs("intersect"));
            return new InterSect(this.info(), el.finish());
        }
        if (this.wsConsumeWs("except")) {
            ExprList el = new ExprList(e);
            do {
                this.add(el, this.instanceoff());
            } while (this.wsConsumeWs("except"));
            return new Except(this.info(), el.finish());
        }
        return e;
    }

    private Expr instanceoff() throws QueryException {
        Expr e = this.treat();
        if (!this.wsConsumeWs("instance")) {
            return e;
        }
        this.wsCheck("of");
        return new Instance(this.info(), e, this.sequenceType());
    }

    private Expr treat() throws QueryException {
        Expr e = this.castable();
        if (!this.wsConsumeWs("treat")) {
            return e;
        }
        this.wsCheck("as");
        return new Treat(this.info(), e, this.sequenceType());
    }

    private Expr castable() throws QueryException {
        Expr e = this.cast();
        if (!this.wsConsumeWs("castable")) {
            return e;
        }
        this.wsCheck("as");
        return new Castable(this.info(), e, this.simpleType());
    }

    private Expr cast() throws QueryException {
        Expr e = this.unary();
        if (!this.wsConsumeWs("cast")) {
            return e;
        }
        this.wsCheck("as");
        return new Cast(this.info(), e, this.simpleType());
    }

    private Expr unary() throws QueryException {
        boolean minus = false;
        boolean found = false;
        while (true) {
            this.skipWS();
            if (this.consume(45)) {
                minus ^= true;
                found = true;
                continue;
            }
            if (!this.consume(43)) break;
            found = true;
        }
        Expr e = this.value();
        return found ? new Unary(this.info(), this.check(e, Err.EVALUNARY), minus) : e;
    }

    private Expr value() throws QueryException {
        this.validate();
        Expr e = this.path();
        return e != null ? e : this.extension();
    }

    private void validate() throws QueryException {
        int i = this.ip;
        if (!this.wsConsumeWs("validate")) {
            return;
        }
        boolean brace = true;
        if (this.consume("{")) {
            brace = false;
        } else if (this.consume("type")) {
            QNm qnm = this.eQName(Err.QNAMEINV, SKIPCHECK);
            this.names.add(new QNmCheck(qnm));
        } else if (!this.consume("strict") && !this.consume("lax")) {
            this.ip = i;
            return;
        }
        if (brace) {
            this.wsCheck("{");
        }
        this.check(this.single(), Err.NOVALIDATE);
        this.wsCheck("}");
        this.error(Err.IMPLVAL, new Object[0]);
    }

    private Expr extension() throws QueryException {
        Pragma[] pragmas = this.pragma();
        return pragmas == null ? null : new Extension(this.info(), pragmas, this.enclosed(Err.NOPRAGMA));
    }

    private Pragma[] pragma() throws QueryException {
        if (!this.wsConsumeWs("(#")) {
            return null;
        }
        ArrayList<Pragma> el = new ArrayList<Pragma>();
        do {
            QNm name = this.eQName(Err.QNAMEINV, URICHECK);
            char c = this.curr();
            if (c != '#' && !Token.ws(c)) {
                this.error(Err.PRAGMAINV, new Object[0]);
            }
            this.tok.reset();
            while (c != '#' || this.next() != ')') {
                if (c == '\u0000') {
                    this.error(Err.PRAGMAINV, new Object[0]);
                }
                this.tok.add(this.consume());
                c = this.curr();
            }
            el.add(new Pragma(name, this.tok.trim().finish()));
            this.ip += 2;
        } while (this.wsConsumeWs("(#"));
        return el.toArray(new Pragma[el.size()]);
    }

    private Expr path() throws QueryException {
        ExprList el;
        this.checkInit();
        Expr root = null;
        if (this.consume(47)) {
            Expr ex;
            root = new Root(this.info());
            el = new ExprList();
            if (this.consume(47)) {
                this.checkAxis(Axis.DESC);
                this.add(el, this.descOrSelf());
                this.mark();
                ex = this.step();
                if (ex == null) {
                    if (this.more()) {
                        this.checkInit();
                    }
                    this.error(Err.PATHMISS, new Object[]{this.found()});
                }
            } else {
                this.checkAxis(Axis.CHILD);
                this.mark();
                ex = this.step();
                if (ex == null) {
                    return root;
                }
            }
            this.add(el, ex);
            this.relativePath(el);
        } else {
            boolean nostep;
            this.mark();
            Expr ex = this.step();
            if (ex == null) {
                return null;
            }
            boolean bl = nostep = this.curr() != '/' && (this.curr() != '!' || this.next() == '=');
            if (nostep && !(ex instanceof AxisStep)) {
                return ex;
            }
            el = new ExprList();
            if (ex instanceof AxisStep) {
                this.add(el, ex);
            } else {
                root = ex;
            }
            this.relativePath(el);
        }
        return Path.get(this.info(), root, el.finish());
    }

    void relativePath(ExprList el) throws QueryException {
        while (true) {
            boolean b = false;
            if (this.consume(47)) {
                if (this.consume(47)) {
                    this.add(el, this.descOrSelf());
                    this.checkAxis(Axis.DESC);
                } else {
                    this.checkAxis(Axis.CHILD);
                }
            } else if (this.next() != '=' && this.consume(33)) {
                b = true;
            } else {
                return;
            }
            this.mark();
            Expr st = this.step();
            if (st == null) {
                this.error(Err.PATHMISS, new Object[]{this.found()});
            }
            if (b) {
                st = new Bang(this.info(), st);
            }
            this.add(el, st);
        }
    }

    private AxisStep descOrSelf() {
        return AxisStep.get(this.info(), Axis.DESCORSELF, Test.NOD, new Expr[0]);
    }

    protected void checkInit() {
    }

    protected void checkAxis(Axis axis) {
    }

    protected void checkTest(Test test, boolean attr) {
    }

    protected void checkPred(boolean open) {
    }

    private Expr step() throws QueryException {
        Expr e = this.postfix();
        return e != null ? e : this.axisStep();
    }

    private AxisStep axisStep() throws QueryException {
        Axis ax = null;
        Test test = null;
        if (this.wsConsume("..")) {
            ax = Axis.PARENT;
            test = Test.NOD;
            this.checkTest(test, false);
        } else if (this.consume(64)) {
            ax = Axis.ATTR;
            test = this.nodeTest(true, true);
            this.checkTest(test, true);
            if (test == null) {
                --this.ip;
                this.error(Err.NOATTNAME, new Object[0]);
            }
        } else {
            for (Axis a : Axis.values()) {
                int i = this.ip;
                if (!this.wsConsumeWs(a.name)) continue;
                this.alter = Err.NOLOCSTEP;
                if (this.wsConsumeWs("::")) {
                    this.ap = this.ip;
                    ax = a;
                    test = this.nodeTest(a == Axis.ATTR, true);
                    this.checkTest(test, a == Axis.ATTR);
                    break;
                }
                this.ip = i;
            }
        }
        if (ax == null) {
            ax = Axis.CHILD;
            test = this.nodeTest(false, true);
            if (test != null && test.type == NodeType.ATT) {
                ax = Axis.ATTR;
            }
            this.checkTest(test, ax == Axis.ATTR);
        }
        if (test == null) {
            return null;
        }
        ExprList el = new ExprList();
        while (this.wsConsume("[")) {
            this.checkPred(true);
            this.add(el, this.expr());
            this.wsCheck("]");
            this.checkPred(false);
        }
        return AxisStep.get(this.info(), ax, test, el.finish());
    }

    private Test nodeTest(boolean att, boolean all) throws QueryException {
        QNm name;
        int i = this.ip;
        if (this.consume(42)) {
            if (!this.consume(58)) {
                return new NameTest(att);
            }
            return new NameTest(new QNm(this.ncName(Err.QNAMEINV)), Test.Mode.NAME, att);
        }
        if (this.ctx.sc.xquery3 && this.consume("Q{")) {
            byte[] uri = this.bracedURILiteral();
            if (this.consume(42)) {
                QNm nm = new QNm(Token.COLON, uri);
                return new NameTest(nm, Test.Mode.NS, att);
            }
        }
        if ((name = this.eQName(null, SKIPCHECK)) != null) {
            int i2 = this.ip;
            if (all && this.wsConsumeWs("(")) {
                NodeType type = NodeType.find(name);
                if (type != null) {
                    return this.kindTest(type);
                }
            } else {
                this.ip = i2;
                if (name.hasPrefix() || !this.consume(58)) {
                    this.skipWS();
                    this.names.add(new QNmCheck(name, !att));
                    return new NameTest(name, Test.Mode.STD, att);
                }
                if (this.consume(42)) {
                    QNm nm = new QNm(Token.concat(name.string(), Token.COLON));
                    this.names.add(new QNmCheck(nm, !att));
                    return new NameTest(nm, Test.Mode.NS, att);
                }
            }
        }
        this.ip = i;
        return null;
    }

    private Expr postfix() throws QueryException {
        Expr old;
        Expr e = this.primary();
        do {
            old = e;
            if (this.wsConsume("[")) {
                if (e == null) {
                    this.error(Err.PREDMISSING, new Object[0]);
                }
                ExprList el = new ExprList();
                do {
                    this.add(el, this.expr());
                    this.wsCheck("]");
                } while (this.wsConsume("["));
                e = new Filter(this.info(), e, el.finish());
                continue;
            }
            if (e == null) continue;
            Expr[] args = this.argumentList(e);
            if (args == null) break;
            Var[] part = new Var[args.length];
            boolean pt = this.partial(args, part);
            e = new DynamicFunc(this.info(), e, args);
            if (!pt) continue;
            e = new PartFunc(this.info(), e, part);
        } while (e != old);
        return e;
    }

    private boolean partial(Expr[] args, Var[] vars) {
        InputInfo ii = this.info();
        boolean found = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            vars[i] = this.ctx.uniqueVar(ii, null);
            args[i] = new VarRef(ii, vars[i]);
            found = true;
        }
        return found;
    }

    private Expr primary() throws QueryException {
        Expr e;
        this.skipWS();
        char c = this.curr();
        if (c == '$') {
            return new VarRef(this.info(), this.checkVar(this.varName(), Err.VARUNDEF));
        }
        if (c == '(' && this.next() != '#') {
            return this.parenthesized();
        }
        if (c == '<') {
            return this.constructor();
        }
        if (this.ctx.sc.xquery3 && (e = this.functionItem()) != null) {
            return e;
        }
        e = this.functionCall();
        if (e != null) {
            return e;
        }
        e = this.compConstructor();
        if (e != null) {
            return e;
        }
        if (this.wsConsumeWs("ordered", "{", Err.INCOMPLETE) || this.wsConsumeWs("unordered", "{", Err.INCOMPLETE)) {
            return this.enclosed(Err.NOENCLEXPR);
        }
        if (this.wsConsumeWs("map", "{", Err.INCOMPLETE)) {
            return this.mapLiteral();
        }
        if (c == '.' && !Token.digit(this.next())) {
            if (this.next() == '.') {
                return null;
            }
            this.consume(46);
            return new Context(this.info());
        }
        return this.literal();
    }

    private Expr mapLiteral() throws QueryException {
        this.wsCheck("{");
        ExprList el = new ExprList();
        if (!this.wsConsume("}")) {
            do {
                this.add(el, this.check(this.single(), Err.INVMAPKEY));
                this.wsCheck(":=");
                this.add(el, this.check(this.single(), Err.INVMAPVAL));
            } while (this.wsConsume(","));
            this.wsCheck("}");
        }
        return new LitMap(this.info(), el.finish());
    }

    private Expr functionItem() throws QueryException {
        Ann ann;
        this.skipWS();
        int pos = this.ip;
        Ann ann2 = ann = this.ctx.sc.xquery3 && this.curr(37) ? this.annotations() : null;
        if (this.wsConsume("function") && this.wsConsume("(")) {
            int s = this.ctx.vars.size();
            Var[] args = this.paramList();
            this.wsCheck(")");
            SeqType type = this.optAsType();
            Expr body = this.enclosed(Err.NOFUNBODY);
            this.ctx.vars.size(s);
            return new InlineFunc(this.info(), type, args, body, ann);
        }
        if (ann != null) {
            this.error(Err.NOANN, new Object[0]);
        }
        this.ip = pos;
        QNm name = this.eQName(null, this.ctx.sc.nsFunc);
        if (name != null && this.consume(35)) {
            long card = ((Int)this.numericLiteral(true)).itr();
            if (card < 0L || card > Integer.MAX_VALUE) {
                this.error(Err.FUNCUNKNOWN, name);
            }
            return Functions.get(name, card, false, this.ctx, this.info());
        }
        this.ip = pos;
        return null;
    }

    private Item literal() throws QueryException {
        char c = this.curr();
        if (Token.digit(c) || c == '.') {
            return this.numericLiteral(false);
        }
        if (!QueryParser.quote(c)) {
            return null;
        }
        int i = this.ip;
        byte[] s = this.stringLiteral();
        int p2 = this.ip;
        if (this.consume(58)) {
            if (!this.consume(61)) {
                this.ip = i;
                return null;
            }
            this.ip = p2;
        }
        return Str.get(s);
    }

    private Item numericLiteral(boolean itr) throws QueryException {
        this.tok.reset();
        while (Token.digit(this.curr())) {
            this.tok.add(this.consume());
        }
        boolean dec = this.consume(46);
        if (dec) {
            if (itr) {
                this.error(Err.NUMBERITR, new Object[0]);
            }
            this.tok.add(46);
            while (Token.digit(this.curr())) {
                this.tok.add(this.consume());
            }
        }
        if (XMLToken.isNCStartChar(this.curr())) {
            return this.checkDbl();
        }
        if (dec) {
            return new Dec(this.tok.finish());
        }
        long l = Token.toLong(this.tok.finish());
        if (l == Long.MIN_VALUE) {
            this.error(Err.RANGE, this.tok);
        }
        return Int.get(l);
    }

    private Dbl checkDbl() throws QueryException {
        if (!this.consume(101) && !this.consume(69)) {
            this.error(Err.NUMBERWS, new Object[0]);
        }
        this.tok.add(101);
        if (this.curr(43) || this.curr(45)) {
            this.tok.add(this.consume());
        }
        int s = this.tok.size();
        while (Token.digit(this.curr())) {
            this.tok.add(this.consume());
        }
        if (s == this.tok.size()) {
            this.error(Err.NUMBERINC, this.tok);
        }
        if (XMLToken.isNCStartChar(this.curr())) {
            this.error(Err.NUMBERWS, new Object[0]);
        }
        return Dbl.get(this.tok.finish(), this.info());
    }

    private byte[] stringLiteral() throws QueryException {
        this.skipWS();
        char del = this.curr();
        if (!QueryParser.quote(del)) {
            this.error(Err.NOQUOTE, new Object[]{this.found()});
        }
        this.consume();
        this.tok.reset();
        while (true) {
            if (!this.consume(del)) {
                if (!this.more()) {
                    this.error(Err.NOQUOTE, new Object[]{this.found()});
                }
                this.entity(this.tok);
                continue;
            }
            if (!this.consume(del)) break;
            this.tok.add(del);
        }
        return this.tok.finish();
    }

    private byte[] bracedURILiteral() throws QueryException {
        this.tok.reset();
        while (!this.consume(125)) {
            if (!this.more()) {
                this.error(Err.WRONGCHAR, "}", this.found());
            }
            this.entity(this.tok);
        }
        return this.tok.finish();
    }

    private QNm varName() throws QueryException {
        this.wsCheck("$");
        this.skipWS();
        return this.eQName(Err.NOVARNAME, null);
    }

    private Expr parenthesized() throws QueryException {
        this.wsCheck("(");
        Expr e = this.expr();
        this.wsCheck(")");
        return e == null ? Empty.SEQ : e;
    }

    private Expr functionCall() throws QueryException {
        Expr[] args;
        int i = this.ip;
        QNm name = this.eQName(null, this.ctx.sc.nsFunc);
        if (name != null && !QueryParser.keyword(name) && (args = this.argumentList(name.string())) != null) {
            this.alter = Err.FUNCUNKNOWN;
            this.alterFunc = name;
            this.ap = this.ip;
            Var[] vars = new Var[args.length];
            boolean part = this.partial(args, vars);
            TypedFunc f = Functions.get(name, args, false, this.ctx, this.info());
            if (f != null) {
                this.alter = null;
                return part ? new PartFunc(this.info(), f, vars) : f.fun;
            }
        }
        this.ip = i;
        return null;
    }

    private Expr[] argumentList(Object name) throws QueryException {
        if (!this.wsConsume("(")) {
            return null;
        }
        Expr[] args = new Expr[]{};
        if (!this.wsConsume(")")) {
            do {
                Expr arg = null;
                if (!this.wsConsume("?") && (arg = this.single()) == null) {
                    this.error(Err.FUNCMISS, name);
                }
                int a = args.length;
                Expr[] tmp = new Expr[a + 1];
                System.arraycopy(args, 0, tmp, 0, a);
                tmp[a] = arg;
                args = tmp;
            } while (this.wsConsume(","));
            if (!this.wsConsume(")")) {
                this.error(Err.FUNCMISS, name);
            }
        }
        return args;
    }

    private Expr constructor() throws QueryException {
        this.check(60);
        return this.consume(33) ? this.dirComment() : (this.consume(63) ? this.dirPI() : this.dirElement());
    }

    private Expr dirElement() throws QueryException {
        byte[] atn;
        int s = this.ctx.sc.ns.size();
        byte[] nse = this.ctx.sc.nsElem;
        int npos = this.names.size();
        QNm tag = new QNm(this.qName(Err.TAGNAME));
        this.names.add(new QNmCheck(tag));
        this.consumeWS();
        Atts ns = new Atts();
        ExprList cont = new ExprList();
        boolean xmlDecl = false;
        while ((atn = this.qName(null)).length != 0) {
            boolean pr;
            ExprList attv = new ExprList();
            this.consumeWS();
            this.check(61);
            this.consumeWS();
            char delim = this.consume();
            if (!QueryParser.quote(delim)) {
                this.error(Err.NOQUOTE, new Object[]{this.found()});
            }
            TokenBuilder tb = new TokenBuilder();
            boolean simple = true;
            while (true) {
                if (!this.consume(delim)) {
                    char ch = this.curr();
                    if (ch == '{') {
                        if (this.next() == '{') {
                            tb.add(this.consume());
                            this.consume();
                            continue;
                        }
                        byte[] text = tb.finish();
                        if (text.length != 0) {
                            this.add(attv, Str.get(text));
                        } else {
                            this.add(attv, this.enclosed(Err.NOENCLEXPR));
                            simple = false;
                        }
                        tb.reset();
                        continue;
                    }
                    if (ch == '}') {
                        this.consume();
                        this.check(125);
                        tb.add(125);
                        continue;
                    }
                    if (ch == '<' || ch == '\u0000') {
                        this.error(Err.NOQUOTE, new Object[]{this.found()});
                        continue;
                    }
                    if (ch == '\n' || ch == '\t') {
                        tb.add(32);
                        this.consume();
                        continue;
                    }
                    if (ch == '\r') {
                        if (this.next() != '\n') {
                            tb.add(32);
                        }
                        this.consume();
                        continue;
                    }
                    this.entity(tb);
                    continue;
                }
                if (!this.consume(delim)) break;
                tb.add(delim);
            }
            if (!tb.isEmpty()) {
                this.add(attv, Str.get(tb.finish()));
            }
            if ((pr = Token.startsWith(atn, Token.XMLNSC)) || Token.eq(atn, Token.XMLNS)) {
                byte[] uri;
                if (!simple) {
                    this.error(Err.NSCONS, new Object[0]);
                }
                byte[] pref = pr ? Token.local(atn) : Token.EMPTY;
                byte[] byArray = uri = attv.isEmpty() ? Token.EMPTY : ((Str)attv.get(0)).string();
                if (Token.eq(pref, Token.XML) && Token.eq(uri, QueryText.XMLURI)) {
                    if (xmlDecl) {
                        this.error(Err.DUPLNSDEF, new Object[]{Token.XML});
                    }
                    xmlDecl = true;
                } else {
                    if (pr) {
                        if (uri.length == 0) {
                            this.error(Err.NSEMPTYURI, new Object[0]);
                        }
                        if (Token.eq(pref, Token.XML, Token.XMLNS)) {
                            this.error(Err.BINDXML, new Object[]{pref});
                        }
                        if (Token.eq(uri, QueryText.XMLURI)) {
                            this.error(Err.BINDXMLURI, uri, Token.XML);
                        }
                        if (Token.eq(uri, QueryText.XMLNSURI)) {
                            this.error(Err.BINDXMLURI, uri, Token.XMLNS);
                        }
                        this.ctx.sc.ns.add(pref, uri);
                    } else {
                        this.ctx.sc.nsElem = uri;
                    }
                    if (ns.get(pref) != -1) {
                        this.error(Err.DUPLNSDEF, new Object[]{pref});
                    }
                    ns.add(pref, uri);
                }
            } else {
                QNm attn = new QNm(atn);
                this.names.add(new QNmCheck(attn, false));
                this.add(cont, new CAttr(this.info(), false, (Expr)attn, attv.finish()));
            }
            if (this.consumeWS()) continue;
            break;
        }
        if (this.consume(47)) {
            this.check(62);
        } else {
            this.check(62);
            while (this.curr() != '<' || this.next() != '/') {
                Expr e = this.dirElemContent(tag.string());
                if (e == null) continue;
                this.add(cont, e);
            }
            this.ip += 2;
            byte[] close = this.qName(Err.TAGNAME);
            this.consumeWS();
            this.check(62);
            if (!Token.eq(tag.string(), close)) {
                this.error(Err.TAGWRONG, tag.string(), close);
            }
        }
        this.assignURI(npos);
        this.ctx.sc.ns.size(s);
        this.ctx.sc.nsElem = nse;
        return new CElem(this.info(), (Expr)tag, ns, cont.finish());
    }

    private Expr dirElemContent(byte[] tag) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        boolean strip = true;
        while (true) {
            char c;
            if ((c = this.curr()) == '<') {
                if (this.wsConsume("<![CDATA[")) {
                    tb.add(this.cDataSection());
                    strip = false;
                    continue;
                }
                Str txt = this.text(tb, strip);
                return txt != null ? txt : (this.next() == '/' ? null : this.constructor());
            }
            if (c == '{') {
                if (this.next() == '{') {
                    tb.add(this.consume());
                    this.consume();
                    continue;
                }
                Str txt = this.text(tb, strip);
                return txt != null ? txt : this.enclosed(Err.NOENCLEXPR);
            }
            if (c == '}') {
                this.consume();
                this.check(125);
                tb.add(125);
                continue;
            }
            if (c != '\u0000') {
                strip &= !this.entity(tb);
                continue;
            }
            this.error(Err.NOCLOSING, new Object[]{tag});
        }
    }

    private Str text(TokenBuilder tb, boolean strip) {
        byte[] t = tb.finish();
        return t.length == 0 || strip && !this.ctx.sc.spaces && Token.ws(t) ? null : Str.get(t);
    }

    private Expr dirComment() throws QueryException {
        this.check(45);
        this.check(45);
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            if (this.not('-')) {
                tb.add(this.consume());
                continue;
            }
            this.consume();
            if (this.consume(45)) {
                this.check(62);
                return new CComm(this.info(), (Expr)Str.get(tb.finish()));
            }
            tb.add(45);
        }
    }

    private Expr dirPI() throws QueryException {
        byte[] str = this.ncName(Err.INVALPI);
        if (Token.eq(Token.lc(str), Token.XML)) {
            this.error(Err.PIXML, new Object[]{str});
        }
        boolean space = this.skipWS();
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            if (this.not('?')) {
                if (!space) {
                    this.error(Err.PIWRONG, new Object[0]);
                }
                tb.add(this.consume());
                continue;
            }
            this.consume();
            if (this.consume(62)) {
                return new CPI(this.info(), (Expr)Str.get(str), (Expr)Str.get(tb.finish()));
            }
            tb.add(63);
        }
    }

    private byte[] cDataSection() throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        while (true) {
            if (this.not(']')) {
                int ch = this.consume();
                if (ch == 13 && this.curr(ch = 10)) {
                    this.consume();
                }
                tb.add(ch);
                continue;
            }
            this.consume();
            if (this.curr(93) && this.next() == '>') {
                this.ip += 2;
                return tb.finish();
            }
            tb.add(93);
        }
    }

    private Expr compConstructor() throws QueryException {
        int i = this.ip;
        if (this.wsConsumeWs("document")) {
            return this.consume(this.compDoc(), i);
        }
        if (this.wsConsumeWs("element")) {
            return this.consume(this.compElement(), i);
        }
        if (this.wsConsumeWs("attribute")) {
            return this.consume(this.compAttribute(), i);
        }
        if (this.wsConsumeWs("namespace")) {
            return this.consume(this.compNamespace(), i);
        }
        if (this.wsConsumeWs("text")) {
            return this.consume(this.compText(), i);
        }
        if (this.wsConsumeWs("comment")) {
            return this.consume(this.compComment(), i);
        }
        if (this.wsConsumeWs("processing-instruction")) {
            return this.consume(this.compPI(), i);
        }
        return null;
    }

    private Expr consume(Expr expr, int p) {
        if (expr == null) {
            this.ip = p;
        }
        return expr;
    }

    private Expr compDoc() throws QueryException {
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.check(this.expr(), Err.NODOCCONS);
        this.wsCheck("}");
        return new CDoc(this.info(), e);
    }

    private Expr compElement() throws QueryException {
        Expr[] exprArray;
        Expr name;
        this.skipWS();
        QNm qn = this.eQName(null, SKIPCHECK);
        if (qn != null) {
            name = qn;
            this.names.add(new QNmCheck(qn));
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), Err.NOTAG);
            this.wsCheck("}");
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        InputInfo inputInfo = this.info();
        if (e == null) {
            exprArray = new Expr[]{};
        } else {
            Expr[] exprArray2 = new Expr[1];
            exprArray = exprArray2;
            exprArray2[0] = e;
        }
        return new CElem(inputInfo, name, null, exprArray);
    }

    private Expr compAttribute() throws QueryException {
        Expr name;
        this.skipWS();
        QNm qn = this.eQName(null, SKIPCHECK);
        if (qn != null) {
            name = qn;
            this.names.add(new QNmCheck(qn, false));
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.expr();
            this.wsCheck("}");
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        return new CAttr(this.info(), true, name, e == null ? Empty.SEQ : e);
    }

    private Expr compNamespace() throws QueryException {
        Expr name;
        if (!this.ctx.sc.xquery3) {
            return null;
        }
        this.skipWS();
        byte[] str = this.ncName(null);
        if (str.length != 0) {
            name = Str.get(str);
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), Err.NSWRONG);
            this.wsCheck("}");
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        return new CNSpace(this.info(), name, e == null ? Empty.SEQ : e);
    }

    private Expr compText() throws QueryException {
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.check(this.expr(), Err.NOTXTCONS);
        this.wsCheck("}");
        return new CTxt(this.info(), e);
    }

    private Expr compComment() throws QueryException {
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.check(this.expr(), Err.NOCOMCONS);
        this.wsCheck("}");
        return new CComm(this.info(), e);
    }

    private Expr compPI() throws QueryException {
        Expr name;
        this.skipWS();
        byte[] str = this.ncName(null);
        if (str.length != 0) {
            name = Str.get(str);
        } else {
            if (!this.wsConsume("{")) {
                return null;
            }
            name = this.check(this.expr(), Err.PIWRONG);
            this.wsCheck("}");
        }
        if (!this.wsConsume("{")) {
            return null;
        }
        Expr e = this.expr();
        this.wsCheck("}");
        return new CPI(this.info(), name, e == null ? Empty.SEQ : e);
    }

    private SeqType simpleType() throws QueryException {
        this.skipWS();
        QNm name = this.eQName(Err.TYPEINVALID, this.ctx.sc.nsElem);
        AtomType t = AtomType.find(name, false);
        if (t == null) {
            this.error(Err.TYPEUNKNOWN, name);
        }
        if (t == AtomType.AAT || t == AtomType.NOT) {
            this.error(Err.CASTUNKNOWN, name);
        }
        this.skipWS();
        return SeqType.get((Type)t, this.consume(63) ? SeqType.Occ.ZERO_ONE : SeqType.Occ.ONE);
    }

    private SeqType sequenceType() throws QueryException {
        if (this.wsConsumeWs("empty-sequence", "(", null)) {
            this.wsCheck("(");
            this.wsCheck(")");
            return SeqType.get(AtomType.ITEM, SeqType.Occ.ZERO, null);
        }
        TypeWrapper tw = this.itemType();
        this.skipWS();
        SeqType.Occ occ = this.consume(63) ? SeqType.Occ.ZERO_ONE : (this.consume(43) ? SeqType.Occ.ONE_MORE : (this.consume(42) ? SeqType.Occ.ZERO_MORE : SeqType.Occ.ONE));
        this.skipWS();
        return SeqType.get(tw.type, occ, tw.test);
    }

    private TypeWrapper itemType() throws QueryException {
        this.skipWS();
        if (this.consume("(")) {
            TypeWrapper ret = this.itemType();
            this.wsCheck(")");
            return ret;
        }
        Ann ann = this.ctx.sc.xquery3 && this.curr(37) ? this.annotations() : null;
        QNm name = this.eQName(Err.TYPEINVALID, null);
        this.skipWS();
        boolean func = this.curr(40);
        Type t = null;
        if (func) {
            this.consume("(");
            if (name.eq(AtomType.ITEM.name)) {
                t = AtomType.ITEM;
            }
            if (t == null) {
                t = NodeType.find(name);
            }
            if (t == null && (t = FuncType.find(name)) != null) {
                return new TypeWrapper(this.functionTest(t));
            }
            if (t == null) {
                this.error(Err.NOTYPE, new Object[]{name.string()});
            }
        } else {
            if (!name.hasURI()) {
                name.uri(this.ctx.sc.nsElem);
            }
            if ((t = AtomType.find(name, false)) == null) {
                this.error(Err.TYPEUNKNOWN, name);
            }
        }
        if (ann != null) {
            this.error(Err.NOANN, new Object[0]);
        }
        if (!func || this.wsConsume(")")) {
            return new TypeWrapper(t);
        }
        if (!(t instanceof NodeType)) {
            this.wsCheck(")");
        }
        return new TypeWrapper(t, this.kindTest((NodeType)t));
    }

    private Type functionTest(Type t) throws QueryException {
        if (this.wsConsume("*")) {
            this.wsCheck(")");
            return t;
        }
        if (t.isMap()) {
            Type key = this.itemType().type;
            if (!key.instanceOf(AtomType.AAT)) {
                this.error(Err.MAPTAAT, key);
            }
            this.wsCheck(",");
            MapType tp = MapType.get((AtomType)key, this.sequenceType());
            this.wsCheck(")");
            return tp;
        }
        SeqType[] args = new SeqType[]{};
        if (!this.wsConsume(")")) {
            do {
                args = Array.add(args, this.sequenceType());
            } while (this.wsConsume(","));
            this.wsCheck(")");
        }
        this.wsCheck("as");
        SeqType st = this.sequenceType();
        return FuncType.get(st, args);
    }

    private Test kindTest(NodeType t) throws QueryException {
        Test tp = null;
        switch (t) {
            case DOC: {
                tp = this.documentTest();
                break;
            }
            case ELM: {
                tp = this.elementTest();
                break;
            }
            case ATT: {
                tp = this.attributeTest();
                break;
            }
            case PI: {
                tp = this.piTest();
                break;
            }
            case SCE: 
            case SCA: {
                tp = this.schemaTest();
                break;
            }
        }
        this.wsCheck(")");
        return tp == null ? Test.get(t) : tp;
    }

    private Test documentTest() throws QueryException {
        boolean elem = this.consume("element");
        if (!elem && !this.consume("schema-element")) {
            return null;
        }
        this.wsCheck("(");
        Test t = elem ? this.elementTest() : this.schemaTest();
        this.wsCheck(")");
        return new DocTest(t != null ? t : Test.ELM);
    }

    private Test elementTest() throws QueryException {
        QNm name = this.eQName(null, this.ctx.sc.nsElem);
        if (name == null && !this.consume("*")) {
            return null;
        }
        AtomType type = null;
        if (this.wsConsumeWs(",")) {
            QNm tn = this.eQName(Err.QNAMEINV, this.ctx.sc.nsElem);
            type = AtomType.find(tn, true);
            if (type == null) {
                this.error(Err.TYPEUNDEF, tn);
            }
            this.wsConsume("?");
        }
        return new ExtTest(NodeType.ELM, name, type, this.ctx.sc.strip);
    }

    private Test schemaTest() throws QueryException {
        QNm name = this.eQName(Err.QNAMEINV, this.ctx.sc.nsElem);
        throw this.error(Err.SCHEMAINV, name);
    }

    private Test attributeTest() throws QueryException {
        QNm tn;
        QNm name = this.eQName(null, null);
        if (name == null && !this.consume("*")) {
            return null;
        }
        AtomType type = null;
        if (this.wsConsumeWs(",") && (type = AtomType.find(tn = this.eQName(Err.QNAMEINV, this.ctx.sc.nsElem), true)) == null) {
            this.error(Err.TYPEUNDEF, tn);
        }
        return new ExtTest(NodeType.ATT, name, type, this.ctx.sc.strip);
    }

    private Test piTest() throws QueryException {
        byte[] nm;
        this.tok.reset();
        if (QueryParser.quote(this.curr())) {
            nm = Token.trim(this.stringLiteral());
            if (!XMLToken.isNCName(nm)) {
                this.error(Err.INVNCNAME, new Object[]{nm});
            }
        } else if (this.ncName()) {
            nm = this.tok.finish();
        } else {
            return null;
        }
        return new ExtTest(NodeType.PI, new QNm(nm));
    }

    private Expr tryCatch() throws QueryException {
        if (!this.ctx.sc.xquery3 || !this.wsConsumeWs("try")) {
            return null;
        }
        Expr tr = this.enclosed(Err.NOENCLEXPR);
        this.wsCheck("catch");
        Catch[] ct = new Catch[]{};
        do {
            QNm[] codes = new QNm[]{};
            do {
                this.skipWS();
                Test test = this.nodeTest(false, false);
                if (test == null) {
                    this.error(Err.NOCATCH, new Object[0]);
                }
                codes = Array.add(codes, test.name);
            } while (this.wsConsumeWs("|"));
            Catch c = new Catch(this.info(), codes, this.ctx);
            int s = c.prepare(this.ctx);
            c.expr = this.enclosed(Err.NOENCLEXPR);
            this.ctx.vars.size(s);
            ct = Array.add(ct, c);
        } while (this.wsConsumeWs("catch"));
        return new Try(this.info(), tr, ct);
    }

    private FTExpr ftSelection(boolean prg) throws QueryException {
        FTExpr old;
        FTExpr expr = this.ftOr(prg);
        FTExpr first = null;
        boolean ordered = false;
        do {
            old = expr;
            if (this.wsConsumeWs("ordered")) {
                ordered = true;
                old = null;
            } else if (this.wsConsumeWs("window")) {
                expr = new FTWindow(this.info(), expr, this.additive(), this.ftUnit());
            } else if (this.wsConsumeWs("distance")) {
                Expr[] rng = this.ftRange(false);
                if (rng == null) {
                    this.error(Err.FTRANGE, new Object[0]);
                }
                expr = new FTDistance(this.info(), expr, rng, this.ftUnit());
            } else if (this.wsConsumeWs("at")) {
                boolean end;
                boolean start = this.wsConsumeWs("start");
                boolean bl = end = !start && this.wsConsumeWs("end");
                if (!start && !end) {
                    this.error(Err.INCOMPLETE, new Object[0]);
                }
                expr = new FTContent(this.info(), expr, start, end);
            } else if (this.wsConsumeWs("entire")) {
                this.wsCheck("content");
                expr = new FTContent(this.info(), expr, false, false);
            } else {
                boolean diff;
                boolean same = this.wsConsumeWs("same");
                boolean bl = diff = !same && this.wsConsumeWs("different");
                if (same || diff) {
                    FTUnit unit = null;
                    if (this.wsConsumeWs("sentence")) {
                        unit = FTUnit.SENTENCE;
                    } else if (this.wsConsumeWs("paragraph")) {
                        unit = FTUnit.PARAGRAPH;
                    } else {
                        this.error(Err.INCOMPLETE, new Object[0]);
                    }
                    expr = new FTScope(this.info(), expr, unit, same);
                }
            }
            if (first != null || old == null || old == expr) continue;
            first = expr;
        } while (old != expr);
        if (ordered) {
            if (first == null) {
                return new FTOrder(this.info(), expr);
            }
            first.expr[0] = new FTOrder(this.info(), first.expr[0]);
        }
        return expr;
    }

    private FTExpr ftOr(boolean prg) throws QueryException {
        FTExpr e = this.ftAnd(prg);
        if (!this.wsConsumeWs("ftor")) {
            return e;
        }
        FTExpr[] list = new FTExpr[]{e};
        do {
            list = Array.add(list, this.ftAnd(prg));
        } while (this.wsConsumeWs("ftor"));
        return new FTOr(this.info(), list);
    }

    private FTExpr ftAnd(boolean prg) throws QueryException {
        FTExpr e = this.ftMildNot(prg);
        if (!this.wsConsumeWs("ftand")) {
            return e;
        }
        FTExpr[] list = new FTExpr[]{e};
        do {
            list = Array.add(list, this.ftMildNot(prg));
        } while (this.wsConsumeWs("ftand"));
        return new FTAnd(this.info(), list);
    }

    private FTExpr ftMildNot(boolean prg) throws QueryException {
        FTExpr e = this.ftUnaryNot(prg);
        if (!this.wsConsumeWs("not")) {
            return e;
        }
        FTExpr[] list = new FTExpr[]{};
        do {
            this.wsCheck("in");
            list = Array.add(list, this.ftUnaryNot(prg));
        } while (this.wsConsumeWs("not"));
        return new FTMildNot(this.info(), e, list.length == 1 ? list[0] : new FTOr(this.info(), list));
    }

    private FTExpr ftUnaryNot(boolean prg) throws QueryException {
        boolean not = this.wsConsumeWs("ftnot");
        FTExpr e = this.ftPrimaryWithOptions(prg);
        return not ? new FTNot(this.info(), e) : e;
    }

    private FTExpr ftPrimaryWithOptions(boolean prg) throws QueryException {
        FTExpr expr = this.ftPrimary(prg);
        FTOpt fto = new FTOpt();
        boolean found = false;
        while (this.ftMatchOption(fto)) {
            found = true;
        }
        if (fto.ln == null) {
            fto.ln = Language.def();
        }
        if (!Tokenizer.supportFor(fto.ln)) {
            this.error(Err.FTNOTOK, fto.ln);
        }
        if (fto.is(FTFlag.ST) && fto.sd == null && !Stemmer.supportFor(fto.ln)) {
            this.error(Err.FTNOSTEM, fto.ln);
        }
        if (this.wsConsumeWs("weight")) {
            expr = new FTWeight(this.info(), expr, this.enclosed(Err.NOENCLEXPR));
        }
        return found ? new FTOptions(this.info(), expr, fto) : expr;
    }

    private FTExpr ftPrimary(boolean prg) throws QueryException {
        Expr e;
        Pragma[] pragmas = this.pragma();
        if (pragmas != null) {
            this.wsCheck("{");
            FTExpr e2 = this.ftSelection(true);
            this.wsCheck("}");
            return new FTExtensionSelection(this.info(), pragmas, e2);
        }
        if (this.wsConsumeWs("(")) {
            FTExpr e3 = this.ftSelection(false);
            this.wsCheck(")");
            return e3;
        }
        this.skipWS();
        Expr expr = this.curr(123) ? this.enclosed(Err.NOENCLEXPR) : (e = QueryParser.quote(this.curr()) ? Str.get(this.stringLiteral()) : null);
        if (e == null) {
            this.error(prg ? Err.NOPRAGMA : Err.NOENCLEXPR, new Object[0]);
        }
        FTMode mode = FTMode.ANY;
        if (this.wsConsumeWs("all")) {
            mode = this.wsConsumeWs("words") ? FTMode.ALL_WORDS : FTMode.ALL;
        } else if (this.wsConsumeWs("any")) {
            mode = this.wsConsumeWs("word") ? FTMode.ANY_WORD : FTMode.ANY;
        } else if (this.wsConsumeWs("phrase")) {
            mode = FTMode.PHRASE;
        }
        Expr[] occ = null;
        if (this.wsConsumeWs("occurs")) {
            occ = this.ftRange(false);
            if (occ == null) {
                this.error(Err.FTRANGE, new Object[0]);
            }
            this.wsCheck("times");
        }
        return new FTWords(this.info(), e, mode, occ);
    }

    private Expr[] ftRange(boolean i) throws QueryException {
        Expr[] occ = new Expr[]{Int.get(1L), Int.get(Long.MAX_VALUE)};
        if (this.wsConsumeWs("exactly")) {
            occ[0] = this.ftAdditive(i);
            occ[1] = occ[0];
        } else if (this.wsConsumeWs("at")) {
            if (this.wsConsumeWs("least")) {
                occ[0] = this.ftAdditive(i);
            } else {
                this.wsCheck("most");
                occ[0] = Int.get(0L);
                occ[1] = this.ftAdditive(i);
            }
        } else if (this.wsConsumeWs("from")) {
            occ[0] = this.ftAdditive(i);
            this.wsCheck("to");
            occ[1] = this.ftAdditive(i);
        } else {
            return null;
        }
        return occ;
    }

    private Expr ftAdditive(boolean i) throws QueryException {
        if (!i) {
            return this.additive();
        }
        this.skipWS();
        this.tok.reset();
        while (Token.digit(this.curr())) {
            this.tok.add(this.consume());
        }
        if (this.tok.isEmpty()) {
            this.error(Err.INTEXP, new Object[0]);
        }
        return Int.get(Token.toLong(this.tok.finish()));
    }

    private FTUnit ftUnit() throws QueryException {
        if (this.wsConsumeWs("words")) {
            return FTUnit.WORD;
        }
        if (this.wsConsumeWs("sentences")) {
            return FTUnit.SENTENCE;
        }
        if (this.wsConsumeWs("paragraphs")) {
            return FTUnit.PARAGRAPH;
        }
        this.error(Err.INCOMPLETE, new Object[0]);
        return null;
    }

    private boolean ftMatchOption(FTOpt opt) throws QueryException {
        if (!this.wsConsumeWs("using")) {
            return false;
        }
        if (this.wsConsumeWs("lowercase")) {
            if (opt.isSet(FTFlag.LC) || opt.isSet(FTFlag.UC) || opt.isSet(FTFlag.CS)) {
                this.error(Err.FTDUP, "case");
            }
            opt.set(FTFlag.CS, true);
            opt.set(FTFlag.LC, true);
        } else if (this.wsConsumeWs("uppercase")) {
            if (opt.isSet(FTFlag.LC) || opt.isSet(FTFlag.UC) || opt.isSet(FTFlag.CS)) {
                this.error(Err.FTDUP, "case");
            }
            opt.set(FTFlag.CS, true);
            opt.set(FTFlag.UC, true);
        } else if (this.wsConsumeWs("case")) {
            if (opt.isSet(FTFlag.LC) || opt.isSet(FTFlag.UC) || opt.isSet(FTFlag.CS)) {
                this.error(Err.FTDUP, "case");
            }
            opt.set(FTFlag.CS, this.wsConsumeWs("sensitive"));
            if (!opt.is(FTFlag.CS)) {
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("diacritics")) {
            if (opt.isSet(FTFlag.DC)) {
                this.error(Err.FTDUP, "diacritics");
            }
            opt.set(FTFlag.DC, this.wsConsumeWs("sensitive"));
            if (!opt.is(FTFlag.DC)) {
                this.wsCheck("insensitive");
            }
        } else if (this.wsConsumeWs("language")) {
            if (opt.ln != null) {
                this.error(Err.FTDUP, "language");
            }
            byte[] lan = this.stringLiteral();
            opt.ln = Language.get(Token.string(lan));
            if (opt.ln == null) {
                this.error(Err.FTNOTOK, new Object[]{lan});
            }
        } else if (this.wsConsumeWs("option")) {
            this.optionDecl();
        } else {
            boolean using;
            boolean bl = using = !this.wsConsumeWs("no");
            if (this.wsConsumeWs("stemming")) {
                if (opt.isSet(FTFlag.ST)) {
                    this.error(Err.FTDUP, "stemming");
                }
                opt.set(FTFlag.ST, using);
            } else if (this.wsConsumeWs("thesaurus")) {
                if (opt.th != null) {
                    this.error(Err.FTDUP, "thesaurus");
                }
                opt.th = new ThesQuery();
                if (using) {
                    boolean par = this.wsConsume("(");
                    if (!this.wsConsumeWs("default")) {
                        this.ftThesaurusID(opt.th);
                    }
                    while (par && this.wsConsume(",")) {
                        this.ftThesaurusID(opt.th);
                    }
                    if (par) {
                        this.wsCheck(")");
                    }
                }
            } else if (this.wsConsumeWs("stop")) {
                this.wsCheck("words");
                if (opt.sw != null) {
                    this.error(Err.FTDUP, "stop words");
                }
                opt.sw = new StopWords();
                if (this.wsConsumeWs("default")) {
                    if (!using) {
                        this.error(Err.FTSTOP, new Object[0]);
                    }
                } else {
                    boolean union = false;
                    boolean except = false;
                    while (using) {
                        if (this.wsConsume("(")) {
                            do {
                                byte[] sl = this.stringLiteral();
                                if (except) {
                                    opt.sw.delete(sl);
                                    continue;
                                }
                                if (union && opt.sw.contains(sl)) continue;
                                opt.sw.add(sl);
                            } while (this.wsConsume(","));
                            this.wsCheck(")");
                        } else if (this.wsConsumeWs("at")) {
                            IO fl;
                            String fn = Token.string(this.stringLiteral());
                            IO iO = fl = this.ctx.stop != null ? this.ctx.stop.get(fn) : this.ctx.sc.io(fn);
                            if (!opt.sw.read(fl, except)) {
                                this.error(Err.NOSTOPFILE, fl);
                            }
                        } else if (!union && !except) {
                            this.error(Err.FTSTOP, new Object[0]);
                        }
                        union = this.wsConsumeWs("union");
                        boolean bl2 = except = !union && this.wsConsumeWs("except");
                        if (union || except) continue;
                        break;
                    }
                }
            } else if (this.wsConsumeWs("wildcards")) {
                if (opt.isSet(FTFlag.WC)) {
                    this.error(Err.FTDUP, "wildcards");
                }
                if (opt.is(FTFlag.FZ)) {
                    this.error(Err.BXFT_MATCH, new Object[0]);
                }
                opt.set(FTFlag.WC, using);
            } else if (this.wsConsumeWs("fuzzy")) {
                if (opt.isSet(FTFlag.FZ)) {
                    this.error(Err.FTDUP, "fuzzy");
                }
                if (opt.is(FTFlag.WC)) {
                    this.error(Err.BXFT_MATCH, new Object[0]);
                }
                opt.set(FTFlag.FZ, using);
            } else {
                this.error(Err.FTMATCH, Character.valueOf(this.consume()));
                return false;
            }
        }
        return true;
    }

    private void ftThesaurusID(ThesQuery thes) throws QueryException {
        this.wsCheck("at");
        String fn = Token.string(this.stringLiteral());
        IO fl = this.ctx.thes != null ? this.ctx.thes.get(fn) : this.ctx.sc.io(fn);
        byte[] rel = this.wsConsumeWs("relationship") ? this.stringLiteral() : Token.EMPTY;
        Expr[] range = this.ftRange(true);
        long min = 0L;
        long max = Long.MAX_VALUE;
        if (range != null) {
            this.wsCheck("levels");
            min = ((Int)range[0]).itr();
            max = ((Int)range[1]).itr();
        }
        thes.add(new Thesaurus(fl, rel, min, max, this.ctx.context));
    }

    private Expr insert() throws QueryException {
        int i = this.ip;
        if (!this.wsConsumeWs("insert") || !this.wsConsumeWs("node") && !this.wsConsumeWs("nodes")) {
            this.ip = i;
            return null;
        }
        Expr s = this.check(this.single(), Err.INCOMPLETE);
        boolean first = false;
        boolean last = false;
        boolean before = false;
        boolean after = false;
        if (this.wsConsumeWs("as")) {
            first = this.wsConsumeWs("first");
            if (!first) {
                this.wsCheck("last");
                last = true;
            }
            this.wsCheck("into");
        } else if (!this.wsConsumeWs("into")) {
            after = this.wsConsumeWs("after");
            boolean bl = before = !after && this.wsConsumeWs("before");
            if (!after && !before) {
                this.error(Err.INCOMPLETE, new Object[0]);
            }
        }
        Expr trg = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating(true);
        return new Insert(this.info(), s, first, last, before, after, trg);
    }

    private Expr deletee() throws QueryException {
        int i = this.ip;
        if (!this.wsConsumeWs("delete") || !this.wsConsumeWs("nodes") && !this.wsConsumeWs("node")) {
            this.ip = i;
            return null;
        }
        this.ctx.updating(true);
        return new Delete(this.info(), this.check(this.single(), Err.INCOMPLETE));
    }

    private Expr rename() throws QueryException {
        int i = this.ip;
        if (!this.wsConsumeWs("rename") || !this.wsConsumeWs("node")) {
            this.ip = i;
            return null;
        }
        Expr trg = this.check(this.single(), Err.INCOMPLETE);
        this.wsCheck("as");
        Expr n = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating(true);
        return new Rename(this.info(), trg, n);
    }

    private Expr replace() throws QueryException {
        int i = this.ip;
        if (!this.wsConsumeWs("replace")) {
            return null;
        }
        boolean v = this.wsConsumeWs("value");
        if (v) {
            this.wsCheck("of");
            this.wsCheck("node");
        } else if (!this.wsConsumeWs("node")) {
            this.ip = i;
            return null;
        }
        Expr t = this.check(this.single(), Err.INCOMPLETE);
        this.wsCheck("with");
        Expr r = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.updating(true);
        return new Replace(this.info(), t, r, v);
    }

    private Expr transform() throws QueryException {
        if (!this.wsConsumeWs("copy", "$", Err.INCOMPLETE)) {
            return null;
        }
        int s = this.ctx.vars.size();
        boolean u = this.ctx.updating;
        this.ctx.updating(false);
        Let[] fl = new Let[]{};
        do {
            Var v = Var.create(this.ctx, this.info(), this.varName(), null);
            this.wsCheck(":=");
            Expr e = this.check(this.single(), Err.INCOMPLETE);
            this.ctx.vars.add(v);
            fl = Array.add(fl, new Let(this.info(), e, v));
        } while (this.wsConsumeWs(","));
        this.wsCheck("modify");
        Expr m = this.check(this.single(), Err.INCOMPLETE);
        this.wsCheck("return");
        Expr r = this.check(this.single(), Err.INCOMPLETE);
        this.ctx.vars.size(s);
        this.ctx.updating = u;
        return new Transform(this.info(), fl, m, r);
    }

    private byte[] ncName(Err err) throws QueryException {
        this.tok.reset();
        if (this.ncName()) {
            return this.tok.finish();
        }
        if (err != null) {
            this.error(err, this.tok);
        }
        return Token.EMPTY;
    }

    private QNm eQName(Err err, byte[] def) throws QueryException {
        byte[] nm;
        Object name;
        int i = this.ip;
        if (this.ctx.sc.xquery3 && this.consume("Q{")) {
            byte[] uri = this.bracedURILiteral();
            name = this.ncName(null);
            if (((byte[])name).length != 0) {
                if (def == URICHECK && uri.length == 0) {
                    this.error(Err.NOURI, name);
                }
                return new QNm((byte[])name, uri);
            }
            this.ip = i;
        }
        if ((nm = this.qName(err)).length == 0) {
            return null;
        }
        if (def == SKIPCHECK) {
            return new QNm(nm);
        }
        name = new QNm(nm, this.ctx);
        if (!name.hasURI()) {
            if (def == URICHECK) {
                this.error(Err.NSMISS, name);
            }
            if (name.hasPrefix()) {
                this.error(Err.NOURI, name);
            }
            name.uri(def);
        }
        return name;
    }

    private byte[] qName(Err err) throws QueryException {
        this.tok.reset();
        if (!this.ncName()) {
            if (err != null) {
                this.error(err, Character.valueOf(this.consume()));
            }
        } else if (this.consume(58)) {
            if (!XMLToken.isNCStartChar(this.curr())) {
                --this.ip;
            } else {
                this.tok.add(58);
                do {
                    this.tok.add(this.consume());
                } while (XMLToken.isNCChar(this.curr()));
            }
        }
        return this.tok.finish();
    }

    private boolean ncName() {
        if (!XMLToken.isNCStartChar(this.curr())) {
            return false;
        }
        do {
            this.tok.add(this.consume());
        } while (XMLToken.isNCChar(this.curr()));
        return true;
    }

    private boolean entity(TokenBuilder tb) throws QueryException {
        int i = this.ip;
        boolean ent = this.consume(38);
        if (ent) {
            if (this.consume(35)) {
                int b = this.consume(120) ? 16 : 10;
                int n = 0;
                do {
                    boolean h;
                    char c = this.curr();
                    boolean m = Token.digit(c);
                    boolean bl = h = b == 16 && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F');
                    if (!m && !h) {
                        this.entityError(i, Err.INVENTITY);
                    }
                    long nn = n;
                    if ((long)(n = n * b + (this.consume() & 0xF)) < nn) {
                        this.entityError(i, Err.INVCHARREF);
                    }
                    if (m) continue;
                    n += 9;
                } while (!this.consume(59));
                if (!XMLToken.valid(n)) {
                    this.entityError(i, Err.INVCHARREF);
                }
                tb.add(n);
            } else {
                if (this.consume("lt")) {
                    tb.add(60);
                } else if (this.consume("gt")) {
                    tb.add(62);
                } else if (this.consume("amp")) {
                    tb.add(38);
                } else if (this.consume("quot")) {
                    tb.add(34);
                } else if (this.consume("apos")) {
                    tb.add(39);
                } else {
                    this.entityError(i, Err.INVENTITY);
                }
                if (!this.consume(59)) {
                    this.entityError(i, Err.INVENTITY);
                }
            }
        } else {
            char c = this.consume();
            char ch = c;
            if (Character.isHighSurrogate(c) && this.curr() != '\u0000' && Character.isLowSurrogate(this.curr())) {
                ch = Character.toCodePoint(c, this.consume());
            }
            if (ch == '\r' && this.curr(ch = '\n')) {
                this.consume();
            }
            tb.add(ch);
        }
        return ent;
    }

    private void entityError(int p, Err c) throws QueryException {
        String sub = this.input.substring(p, Math.min(p + 20, this.il));
        int sc = sub.indexOf(59);
        String ent = sc != -1 ? sub.substring(0, sc + 1) : sub;
        this.error(c, ent);
    }

    private <E extends Expr> E check(E expr, Err err) throws QueryException {
        if (expr == null) {
            this.error(err, new Object[0]);
        }
        return expr;
    }

    private void check(int ch) throws QueryException {
        if (!this.consume(ch)) {
            this.error(Err.WRONGCHAR, Character.valueOf((char)ch), this.found());
        }
    }

    private void wsCheck(String s) throws QueryException {
        if (!this.wsConsume(s)) {
            this.error(Err.WRONGCHAR, s, this.found());
        }
    }

    private Var checkVar(QNm name, Err err) throws QueryException {
        Var v = this.ctx.vars.get(name);
        if (v == null) {
            this.error(err, '$' + Token.string(name.string()));
        }
        return v;
    }

    private boolean not(char ch) throws QueryException {
        char c = this.curr();
        if (c == '\u0000') {
            this.error(Err.WRONGCHAR, Character.valueOf(ch), this.found());
        }
        return c != ch;
    }

    private boolean wsConsumeWs(String t) throws QueryException {
        int i = this.ip;
        if (!this.wsConsume(t)) {
            return false;
        }
        if (this.skipWS() || !XMLToken.isNCStartChar(t.charAt(0)) || !XMLToken.isNCChar(this.curr())) {
            return true;
        }
        this.ip = i;
        return false;
    }

    private boolean wsConsumeWs(String s1, String s2, Err expr) throws QueryException {
        int i = this.ip;
        if (!this.wsConsumeWs(s1)) {
            return false;
        }
        this.alter = expr;
        this.ap = this.ip;
        int i2 = this.ip;
        boolean ok = this.wsConsume(s2);
        this.ip = ok ? i2 : i;
        return ok;
    }

    private boolean wsConsume(String str) throws QueryException {
        this.skipWS();
        return this.consume(str);
    }

    private boolean skipWS() throws QueryException {
        int i = this.ip;
        while (this.more()) {
            char c = this.curr();
            if (c == '(' && this.next() == ':') {
                this.comment();
                continue;
            }
            if (c <= '\u0000' || c > ' ') {
                return i != this.ip;
            }
            ++this.ip;
        }
        return i != this.ip;
    }

    private void comment() throws QueryException {
        ++this.ip;
        while (++this.ip < this.il) {
            if (this.curr(40) && this.next() == ':') {
                this.comment();
            }
            if (!this.curr(58) || this.next() != ')') continue;
            this.ip += 2;
            return;
        }
        this.error(Err.COMCLOSE, new Object[0]);
    }

    private boolean consumeWS() {
        int i = this.ip;
        while (this.more()) {
            char c = this.curr();
            if (c <= '\u0000' || c > ' ') {
                return i != this.ip;
            }
            ++this.ip;
        }
        return true;
    }

    private void error() throws QueryException {
        this.ip = this.ap;
        if (this.alter != Err.FUNCUNKNOWN) {
            throw this.error(this.alter, new Object[0]);
        }
        this.ctx.funcs.funError(this.alterFunc, this.info());
        throw this.error(this.alter, new Object[]{this.alterFunc.string()});
    }

    private void add(ExprList ar, Expr e) throws QueryException {
        if (e == null) {
            this.error(Err.INCOMPLETE, new Object[0]);
        }
        ar.add(e);
    }

    public QueryException error(Err err, Object ... arg) throws QueryException {
        throw err.thrw(this.info(), arg);
    }

    private void assignURI(int npos) throws QueryException {
        for (int i = npos; i < this.names.size(); ++i) {
            if (!this.names.get(i).assign(npos == 0)) continue;
            this.names.remove(i--);
        }
    }

    private class QNmCheck {
        final QNm name;
        final boolean nsElem;

        QNmCheck(QNm nm) {
            this(nm, true);
        }

        QNmCheck(QNm nm, boolean nse) {
            this.name = nm;
            this.nsElem = nse;
        }

        boolean assign(boolean check) throws QueryException {
            if (this.name.hasURI()) {
                return true;
            }
            if (this.name.hasPrefix()) {
                this.name.uri(QueryParser.this.ctx.sc.ns.uri(this.name.prefix()));
                if (check && !this.name.hasURI()) {
                    QueryParser.this.error(Err.NOURI, this.name);
                }
            } else if (this.nsElem) {
                this.name.uri(QueryParser.this.ctx.sc.nsElem);
            }
            return this.name.hasURI();
        }
    }

    private static class TypeWrapper {
        final Type type;
        final Test test;

        TypeWrapper(Type t) {
            this(t, null);
        }

        TypeWrapper(Type t, Test k) {
            this.type = t;
            this.test = k;
        }
    }
}

