/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.SwitchCase;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class Switch
extends ParseExpr {
    private final SwitchCase[] cases;
    private Expr cond;

    public Switch(InputInfo ii, Expr c, SwitchCase[] sc) {
        super(ii);
        this.cases = sc;
        this.cond = c;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        for (SwitchCase sc : this.cases) {
            sc.checkUp();
        }
        Expr[] tmp = new Expr[this.cases.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.cases[i].expr[0];
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        this.cond = this.cond.compile(ctx);
        for (SwitchCase sc : this.cases) {
            sc.compile(ctx);
        }
        Expr ex = this;
        if (this.cond.isValue()) {
            Item it = this.cond.item(ctx, this.info);
            block1: for (SwitchCase sc : this.cases) {
                int sl = sc.expr.length;
                for (int e = 1; e < sl; ++e) {
                    if (!sc.expr[e].isValue()) break block1;
                    Item cs = sc.expr[e].item(ctx, this.info);
                    if (it != cs && (cs == null || it == null || !it.equiv(this.info, cs))) continue;
                    ex = sc.expr[0];
                    break block1;
                }
                if (sl != 1) continue;
                ex = sc.expr[0];
            }
        }
        if (ex != this) {
            return this.optPre(ex, ctx);
        }
        this.type = this.cases[0].expr[0].type();
        for (int c = 1; c < this.cases.length; ++c) {
            this.type = this.type.intersect(this.cases[c].expr[0].type());
        }
        return ex;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return ctx.iter(this.getCase(ctx));
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return ctx.value(this.getCase(ctx));
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.getCase(ctx).item(ctx, ii);
    }

    @Override
    public boolean uses(Expr.Use u) {
        for (SwitchCase sc : this.cases) {
            if (!sc.uses(u)) continue;
            return true;
        }
        return this.cond.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = this.cond.count(v);
        for (SwitchCase sc : this.cases) {
            c += sc.count(v);
        }
        return c;
    }

    @Override
    public boolean removable(Var v) {
        for (SwitchCase sc : this.cases) {
            if (sc.removable(v)) continue;
            return false;
        }
        return this.cond.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        for (SwitchCase sc : this.cases) {
            sc.remove(v);
        }
        this.cond = this.cond.remove(v);
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        for (SwitchCase sc : this.cases) {
            if (sc.databases(db)) continue;
            return false;
        }
        return this.cond.databases(db);
    }

    private Expr getCase(QueryContext ctx) throws QueryException {
        Item it = this.cond.item(ctx, this.info);
        for (SwitchCase sc : this.cases) {
            int sl = sc.expr.length;
            for (int e = 1; e < sl; ++e) {
                Item cs = sc.expr[e].item(ctx, this.info);
                if (it != cs && (it == null || cs == null || !it.equiv(this.info, cs))) continue;
                return sc.expr[0];
            }
            if (sl != 1) continue;
            return sc.expr[0];
        }
        return null;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.cond, this.cases});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("switch(" + this.cond + ")");
        for (SwitchCase sc : this.cases) {
            sb.append(sc.toString());
        }
        return sb.toString();
    }

    @Override
    public Expr markTailCalls() {
        for (SwitchCase sc : this.cases) {
            sc.markTailCalls();
        }
        return this;
    }
}

