/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Simple;
import org.basex.query.ft.FTExpr;
import org.basex.query.func.Function;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class FTIndexAccess
extends Simple {
    private final FTExpr ftexpr;
    private final IndexContext ictx;

    public FTIndexAccess(InputInfo ii, FTExpr ex, IndexContext ic) {
        super(ii);
        this.ftexpr = ex;
        this.ictx = ic;
    }

    @Override
    public NodeIter iter(final QueryContext ctx) throws QueryException {
        final FTIter ir = this.ftexpr.iter(ctx);
        return new NodeIter(){

            @Override
            public ANode next() throws QueryException {
                FTNode it = ir.next();
                if (it != null) {
                    if (ctx.ftpos != null) {
                        ctx.ftpos.add(it.data, it.pre, it.all);
                    }
                    it.score();
                    it.all = null;
                }
                return it;
            }
        };
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.ftexpr.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.ftexpr.count(v);
    }

    @Override
    public boolean removable(Var v) {
        return this.ftexpr.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        this.ftexpr.remove(v);
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        db.add(this.ictx.data.meta.name);
        return this.ftexpr.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.DATA, this.ictx.data.meta.name), this.ftexpr);
    }

    @Override
    public boolean iterable() {
        return this.ictx.iterable;
    }

    @Override
    public String toString() {
        return Function._DB_FULLTEXT.get(this.info, Str.get(this.ictx.data.meta.name), this.ftexpr).toString();
    }
}

