/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.io.IOException;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.data.ExprInfo;
import org.basex.data.MemData;
import org.basex.io.IO;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.Scoring;
import org.basex.util.list.ByteList;

public class DBNode
extends ANode {
    public final Data data;
    public int pre;
    private Atts nsp;

    public DBNode(Data d) {
        this(d, 0);
    }

    public DBNode(Data d, int p) {
        this(d, p, d.kind(p));
    }

    public DBNode(Data d, int p, int k) {
        this(d, p, null, DBNode.type(k));
    }

    DBNode(Data d, int p, ANode r, NodeType t) {
        super(t);
        this.data = d;
        this.pre = p;
        this.par = r;
    }

    public DBNode(IO input, Prop prop) throws IOException {
        this(Parser.xmlParser(input, prop));
    }

    public DBNode(Parser parser) throws IOException {
        this(MemBuilder.build("", parser));
    }

    public final void set(int p, int k) {
        this.type = DBNode.type(k);
        this.par = null;
        this.val = null;
        this.nsp = null;
        this.pre = p;
    }

    @Override
    public final Data data() {
        return this.data;
    }

    @Override
    public final byte[] string() {
        if (this.val == null) {
            this.val = this.data.atom(this.pre);
        }
        return this.val;
    }

    @Override
    public final long itr(InputInfo ii) throws QueryException {
        long l;
        boolean txt;
        boolean bl = txt = this.type == NodeType.TXT || this.type == NodeType.COM;
        if ((txt || this.type == NodeType.ATT) && (l = this.data.textItr(this.pre, txt)) != Long.MIN_VALUE) {
            return l;
        }
        return Int.parse(this.data.atom(this.pre), ii);
    }

    @Override
    public final double dbl(InputInfo ii) throws QueryException {
        double d;
        boolean txt;
        boolean bl = txt = this.type == NodeType.TXT || this.type == NodeType.COM;
        if ((txt || this.type == NodeType.ATT) && !Double.isNaN(d = this.data.textDbl(this.pre, txt))) {
            return d;
        }
        return Dbl.parse(this.data.atom(this.pre), ii);
    }

    @Override
    public final byte[] name() {
        NodeType t = this.nodeType();
        switch (t) {
            case ELM: 
            case ATT: 
            case PI: {
                return this.data.name(this.pre, DBNode.kind(t));
            }
        }
        return Token.EMPTY;
    }

    @Override
    public final QNm qname() {
        return this.qname(new QNm());
    }

    @Override
    public final QNm qname(QNm name) {
        boolean pref;
        byte[] nm = this.name();
        byte[] uri = Token.EMPTY;
        boolean bl = pref = Token.indexOf(nm, 58) != -1;
        if (pref || this.data.nspaces.size() != 0) {
            byte[] u;
            int n;
            int n2 = n = pref ? this.data.nspaces.uri(nm, this.pre) : this.data.uri(this.pre, this.data.kind(this.pre));
            byte[] byArray = n > 0 ? this.data.nspaces.uri(n) : (u = pref ? NSGlobal.uri(Token.prefix(nm)) : null);
            if (u != null) {
                uri = u;
            }
        }
        name.update(nm, uri);
        return name;
    }

    @Override
    public final Atts namespaces() {
        if (this.type == NodeType.ELM && this.nsp == null) {
            this.nsp = this.data.ns(this.pre);
        }
        return this.nsp;
    }

    @Override
    public final byte[] baseURI() {
        if (this.type == NodeType.DOC) {
            byte[] base = this.data.text(this.pre, true);
            if (this.data.inMemory()) {
                String dir = this.data.meta.original;
                String bs = Token.string(base);
                return Token.token(dir.isEmpty() ? bs : IO.get(dir).merge(bs).url());
            }
            return new TokenBuilder(this.data.meta.name).add(47).add(base).finish();
        }
        byte[] b = this.attribute(new QNm(QueryText.BASE, QueryText.XMLURI));
        return b != null ? b : Token.EMPTY;
    }

    @Override
    public final boolean is(ANode node) {
        return node == this || node instanceof DBNode && this.data == node.data() && this.pre == ((DBNode)node).pre;
    }

    @Override
    public final int diff(ANode node) {
        return !(node instanceof DBNode) || this.data != node.data() ? this.id - node.id : this.pre - ((DBNode)node).pre;
    }

    @Override
    public final DBNode copy() {
        DBNode n = new DBNode(this.data, this.pre, this.par, this.nodeType());
        n.score = this.score;
        return n;
    }

    @Override
    public final ANode deepCopy() {
        MemData md = this.data.inMemory() ? new MemData(this.data) : new MemData(this.data.meta.prop);
        new DataBuilder(md).build(this);
        return new DBNode(md);
    }

    @Override
    public final DBNode finish() {
        return this.copy();
    }

    @Override
    public final ANode parent() {
        if (this.par != null) {
            return this.par;
        }
        int p = this.data.parent(this.pre, this.data.kind(this.pre));
        if (p == -1) {
            return null;
        }
        DBNode node = this.copy();
        node.set(p, this.data.kind(p));
        node.score(Scoring.step(node.score()));
        return node;
    }

    @Override
    public DBNode parent(ANode p) {
        this.par = p;
        return this;
    }

    @Override
    public final boolean hasChildren() {
        int k = this.data.kind(this.pre);
        return this.data.attSize(this.pre, k) != this.data.size(this.pre, k);
    }

    @Override
    public final AxisIter ancestor() {
        return new AxisIter(){
            private final DBNode node;
            int p;
            int k;
            final double sc;
            {
                this.node = DBNode.this.copy();
                this.p = DBNode.this.pre;
                this.k = DBNode.this.data.kind(this.p);
                this.sc = this.node.score();
            }

            @Override
            public ANode next() {
                this.p = DBNode.this.data.parent(this.p, this.k);
                if (this.p == -1) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.node.score(Scoring.step(this.sc));
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter ancestorOrSelf() {
        return new AxisIter(){
            private final DBNode node;
            int p;
            int k;
            final double sc;
            {
                this.node = DBNode.this.copy();
                this.p = DBNode.this.pre;
                this.k = DBNode.this.data.kind(this.p);
                this.sc = this.node.score();
            }

            @Override
            public ANode next() {
                if (this.p == -1) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.node.score(Scoring.step(this.sc));
                this.p = DBNode.this.data.parent(this.p, this.k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisMoreIter attributes() {
        return new AxisMoreIter(){
            final DBNode node;
            final int s;
            int p;
            {
                this.node = DBNode.this.copy();
                this.s = DBNode.this.pre + DBNode.this.data.attSize(DBNode.this.pre, DBNode.this.data.kind(DBNode.this.pre));
                this.p = DBNode.this.pre + 1;
            }

            @Override
            public boolean more() {
                return this.p != this.s;
            }

            @Override
            public DBNode next() {
                if (!this.more()) {
                    return null;
                }
                this.node.set(this.p++, 3);
                return this.node;
            }
        };
    }

    @Override
    public final AxisMoreIter children() {
        return new AxisMoreIter(){
            int k;
            int p;
            final int s;
            final DBNode node;
            final double sc;
            {
                this.k = DBNode.this.data.kind(DBNode.this.pre);
                this.p = DBNode.this.pre + DBNode.this.data.attSize(DBNode.this.pre, this.k);
                this.s = DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, this.k);
                this.node = DBNode.this.copy();
                this.sc = this.node.score();
            }

            @Override
            public boolean more() {
                return this.p != this.s;
            }

            @Override
            public ANode next() {
                if (!this.more()) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.node.score(Scoring.step(this.sc));
                this.p += DBNode.this.data.size(this.p, this.k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter descendant() {
        return new AxisIter(){
            int k;
            int p;
            final int s;
            final DBNode node;
            final double sc;
            {
                this.k = DBNode.this.data.kind(DBNode.this.pre);
                this.p = DBNode.this.pre + DBNode.this.data.attSize(DBNode.this.pre, this.k);
                this.s = DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, this.k);
                this.node = DBNode.this.copy();
                this.sc = this.node.score();
            }

            @Override
            public DBNode next() {
                if (this.p == this.s) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.p += DBNode.this.data.attSize(this.p, this.k);
                this.node.score(Scoring.step(this.sc));
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter descendantOrSelf() {
        return new AxisIter(){
            final DBNode node;
            final int s;
            int p;
            {
                this.node = DBNode.this.copy();
                this.s = DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, DBNode.this.data.kind(DBNode.this.pre));
                this.p = DBNode.this.pre;
            }

            @Override
            public ANode next() {
                if (this.p == this.s) {
                    return null;
                }
                int k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, k);
                this.p += DBNode.this.data.attSize(this.p, k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter following() {
        return new AxisIter(){
            private final DBNode node;
            final int s;
            int k;
            int p;
            {
                this.node = DBNode.this.copy();
                this.s = DBNode.this.data.meta.size;
                this.k = DBNode.this.data.kind(DBNode.this.pre);
                this.p = DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, this.k);
            }

            @Override
            public ANode next() {
                if (this.p == this.s) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.p += DBNode.this.data.attSize(this.p, this.k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter followingSibling() {
        return new AxisIter(){
            private final DBNode node;
            int k;
            private final int pp;
            final int s;
            int p;
            {
                this.node = DBNode.this.copy();
                this.k = DBNode.this.data.kind(DBNode.this.pre);
                this.pp = DBNode.this.data.parent(DBNode.this.pre, this.k);
                this.s = this.pp == -1 ? 0 : this.pp + DBNode.this.data.size(this.pp, DBNode.this.data.kind(this.pp));
                this.p = this.pp == -1 ? 0 : DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, this.k);
            }

            @Override
            public ANode next() {
                if (this.p == this.s) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.p += DBNode.this.data.size(this.p, this.k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter parentIter() {
        return new AxisIter(){
            private boolean more;

            @Override
            public ANode next() {
                if (this.more) {
                    return null;
                }
                this.more = true;
                return DBNode.this.parent();
            }
        };
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        return cmp instanceof DBNode && this.data == ((DBNode)cmp).data && this.pre == ((DBNode)cmp).pre;
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this.data.meta.name, QueryText.PRE, this.pre), new ExprInfo[0]);
    }

    @Override
    public byte[] xdmInfo() {
        ByteList bl = new ByteList().add(this.typeId());
        if (this.type == NodeType.DOC) {
            bl.add(this.baseURI()).add(0);
        } else if (this.type == NodeType.ATT) {
            bl.add(this.qname().uri()).add(0);
        }
        return bl.toArray();
    }

    @Override
    public byte typeId() {
        AxisMoreIter ai;
        byte t = this.type.id();
        if (this.type == NodeType.DOC && (ai = this.children()).more() && ai.next().type == NodeType.ELM && !ai.more()) {
            t = NodeType.DEL.id();
        }
        return t;
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.type.string()).add(32);
        switch ((NodeType)this.type) {
            case ATT: 
            case PI: {
                tb.add(this.name()).add(" { \"").add(Token.chop(this.string(), 64)).add("\" }");
                break;
            }
            case ELM: {
                tb.add(this.name()).add(" { ... }");
                break;
            }
            case DOC: {
                tb.add("{ \"").add(this.data.text(this.pre, true)).add("\" }");
                break;
            }
            default: {
                tb.add("{ \"").add(Token.chop(this.string(), 64)).add("\" }");
            }
        }
        return tb.toString();
    }
}

