/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogMessage;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Util;

public abstract class BaseXDialog
extends JDialog {
    public final StringBuilder mnem = new StringBuilder();
    public GUI gui;
    public boolean ok;
    public BaseXBack panel;
    private int[] loc;
    public final KeyAdapter keys = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (!BaseXKeys.modifier(e)) {
                BaseXDialog.this.action(e.getSource());
            }
        }
    };

    public BaseXDialog(BaseXDialog d, String title) {
        super(d, title, true);
        this.init(d.gui);
    }

    public BaseXDialog(GUI main, String title) {
        this(main, title, true);
    }

    public BaseXDialog(GUI main, String title, boolean modal) {
        super(main, title, modal);
        this.init(main);
    }

    void init(GUI main) {
        this.gui = main;
        this.panel = new BaseXBack(new BorderLayout()).border(10, 10, 10, 10);
        this.add((Component)this.panel, "Center");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BaseXDialog.this.cancel();
            }
        });
    }

    public final void set(Component comp, String pos) {
        this.panel.add(comp, pos);
    }

    public final void finish(int[] l) {
        this.pack();
        if (l == null) {
            this.setLocationRelativeTo(this.gui);
        } else {
            this.setLocation(this.gui.getX() + l[0], this.gui.getY() + l[1]);
        }
        this.loc = l;
        this.setVisible(true);
    }

    @Override
    public void setLocation(int x, int y) {
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int xx = Math.max(0, Math.min(scr.width - this.getWidth(), x));
        int yy = Math.max(0, Math.min(scr.height - this.getHeight(), y));
        super.setLocation(xx, yy);
    }

    public void action(Object comp) {
    }

    public void cancel() {
        this.ok = false;
        this.dispose();
    }

    public void close() {
        this.ok = true;
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.loc != null) {
            Container par = this.getParent();
            this.loc[0] = this.getX() - par.getX();
            this.loc[1] = this.getY() - par.getY();
            this.gui.gprop.write();
        }
        super.dispose();
    }

    public final boolean ok() {
        return this.ok;
    }

    public BaseXBack okCancel() {
        return this.newButtons(Text.B_OK, Text.B_CANCEL);
    }

    public BaseXBack newButtons(Object ... buttons) {
        BaseXBack pnl = new BaseXBack(GUIConstants.Fill.NONE).border(12, 0, 0, 0).layout(new TableLayout(1, buttons.length, 8, 0));
        for (Object obj : buttons) {
            BaseXButton b = obj instanceof BaseXButton ? (BaseXButton)obj : new BaseXButton(obj.toString(), this);
            pnl.add(b);
        }
        BaseXBack but = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        but.add((Component)pnl, "East");
        return but;
    }

    public static void enableOK(JComponent panel, String label, boolean enabled) {
        for (Component c : panel.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            if (c instanceof BaseXButton) {
                BaseXButton b = (BaseXButton)c;
                if (!b.getText().equals(label)) continue;
                b.setEnabled(enabled);
                continue;
            }
            BaseXDialog.enableOK((JComponent)c, label, enabled);
        }
    }

    public static Boolean yesNoCancel(GUI gui, String text) {
        DialogMessage msg = new DialogMessage(gui, text.trim(), GUIConstants.Msg.YESNOCANCEL);
        return msg.canceled() ? null : Boolean.valueOf(msg.ok());
    }

    public static boolean confirm(GUI gui, String text) {
        return new DialogMessage(gui, text.trim(), GUIConstants.Msg.QUESTION).ok();
    }

    public static void info(GUI gui, String text) {
        new DialogMessage(gui, text.trim(), GUIConstants.Msg.SUCCESS);
    }

    public static void error(GUI gui, String text) {
        new DialogMessage(gui, text.trim(), GUIConstants.Msg.ERROR);
    }

    public static void browse(GUI gui, String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception ex) {
            BaseXDialog.error(gui, Util.info(Text.H_BROWSER_ERROR_X, Text.URL));
        }
    }
}

