/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.gui.layout.BaseXTree;
import org.basex.gui.layout.TreeLeaf;
import org.basex.gui.layout.TreeNode;
import org.basex.index.resource.Resources;
import org.basex.util.Token;
import org.basex.util.hash.TokenBoolMap;
import org.basex.util.list.TokenList;

public class TreeFolder
extends TreeNode {
    private boolean loaded;

    public TreeFolder(byte[] nm, byte[] pth, BaseXTree t, Data d) {
        super(nm, pth, t, d);
    }

    @Override
    void load() {
        if (this.loaded) {
            return;
        }
        for (byte[] b : TreeFolder.folders(this)) {
            this.add(new TreeFolder(b, this.subfolder(), this.tree, this.data));
        }
        for (TreeLeaf l : TreeFolder.leaves(this)) {
            this.add(l);
        }
        this.loaded = true;
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this);
    }

    private static byte[][] folders(TreeFolder node) {
        Resources res = node.data.resources;
        TokenBoolMap ts = res.children(node.subfolder(), true);
        return new TokenList(ts.keys()).sort(!Prop.WIN).toArray();
    }

    public static TreeLeaf[] leaves(TreeFolder node) {
        Resources res = node.data.resources;
        TokenBoolMap tbm = res.children(node.subfolder(), false);
        int ts = tbm.size();
        TreeLeaf[] leaves = new TreeLeaf[ts];
        for (int t = 0; t < ts; ++t) {
            leaves[t] = new TreeLeaf(tbm.key(t + 1), node.subfolder(), tbm.value(t + 1), node.tree, node.data);
        }
        Arrays.sort(leaves, new Comparator<TreeLeaf>(){

            @Override
            public int compare(TreeLeaf l1, TreeLeaf l2) {
                byte[] n1 = l1.name;
                byte[] n2 = l2.name;
                return Prop.WIN ? Token.diff(Token.lc(n1), Token.lc(n2)) : Token.diff(n1, n2);
            }
        });
        return leaves;
    }

    byte[] subfolder() {
        return this.path.length > 1 ? Token.concat(Token.concat(this.path, Token.SLASH), this.name) : Token.concat(this.path, this.name);
    }

    public static byte[] name(byte[] path) {
        byte[][] s = Token.split(path, 47);
        if (s.length == 0) {
            return Token.EMPTY;
        }
        return s[s.length - 1];
    }

    public static byte[] path(byte[] path) {
        if (path.length == 0) {
            return path;
        }
        byte[] r = Token.substring(path, 0, Token.lastIndexOf(path, 47));
        return r.length == 0 ? Token.SLASH : r;
    }

    public void removeChildren() {
        this.removeAllChildren();
        this.loaded = false;
    }

    public void reload() {
        this.removeChildren();
        this.load();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

