/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.MetaData;
import org.basex.io.out.DataOutput;
import org.basex.util.list.IntList;

public final class TableOutput
extends OutputStream {
    private final byte[] buffer = new byte[4096];
    private final IntList fpres = new IntList();
    private final IntList pages = new IntList();
    private final OutputStream os;
    private final MetaData meta;
    private final String file;
    private int pos;
    private int fpre;

    public TableOutput(MetaData md, String fn) throws IOException {
        this.os = new FileOutputStream(md.dbfile(fn).file());
        this.meta = md;
        this.file = fn;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos == 4096) {
            this.flush();
        }
        this.buffer[this.pos++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
        if (this.pos == 0) {
            return;
        }
        this.os.write(this.buffer);
        this.fpres.add(this.fpre);
        this.pages.add(this.pages.size());
        this.fpre += this.pos >>> 4;
        this.pos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean empty;
        boolean bl = empty = this.fpre + this.pos == 0;
        if (empty) {
            ++this.pos;
        }
        this.flush();
        this.os.close();
        DataOutput out = new DataOutput(this.meta.dbfile(this.file + 'i'));
        try {
            out.writeNum(this.pages.size());
            out.writeNum(empty ? 0 : this.pages.size());
            out.writeNums(this.fpres.toArray());
            out.writeNums(this.pages.toArray());
        }
        finally {
            out.close();
        }
    }
}

