/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNInfo;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FNOut
extends StandardFunc {
    private static final Str NL = Str.get("\n");
    private static final Str TAB = Str.get("\t");

    public FNOut(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _OUT_NL: {
                return NL;
            }
            case _OUT_TAB: {
                return TAB;
            }
            case _OUT_FORMAT: {
                return this.format(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Str format(QueryContext ctx) throws QueryException {
        String form = Token.string(this.checkStr(this.expr[0], ctx));
        Object[] args = new Object[this.expr.length - 1];
        for (int e = 1; e < this.expr.length; ++e) {
            args[e - 1] = this.expr[e].item(ctx, this.info).toJava();
        }
        try {
            return Str.get(String.format(form, args));
        }
        catch (RuntimeException ex) {
            throw Err.ERRFORM.thrw(this.info, Util.name(ex), ex);
        }
    }

    static void dump(long min, byte[] msg, QueryContext ctx) {
        Performance.gc(2);
        long max = Performance.memory();
        long mb = Math.max(0L, max - min);
        FNInfo.dump(Token.token(Performance.format(mb)), msg, ctx);
    }
}

