/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNInfo;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FNProf
extends StandardFunc {
    public FNProf(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _PROF_MEM: {
                return this.mem(ctx);
            }
            case _PROF_TIME: {
                return this.time(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _PROF_SLEEP: {
                return this.sleep(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    Expr comp(QueryContext ctx) throws QueryException {
        Expr e = super.comp(ctx);
        if (this.sig == Function._XQUERY_TYPE) {
            FNInfo.dump(Util.inf("{ type: %, size: % }", this.expr[0].type(), this.expr[0].size()), Token.token(this.expr[0].toString()), ctx);
            return this.expr[0];
        }
        return e;
    }

    private Iter mem(final QueryContext ctx) throws QueryException {
        byte[] msg;
        Performance.gc(3);
        final long min = Performance.memory();
        byte[] byArray = msg = this.expr.length > 2 ? this.checkStr(this.expr[2], ctx) : null;
        if (this.expr.length > 1 && this.checkBln(this.expr[1], ctx)) {
            Value v = ctx.value(this.expr[0]).cache().value();
            FNProf.dump(min, msg, ctx);
            return v.iter();
        }
        return new Iter(){
            final Iter ir;
            {
                this.ir = FNProf.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                Item i = this.ir.next();
                if (i == null) {
                    FNProf.dump(min, msg, ctx);
                }
                return i;
            }
        };
    }

    static void dump(long min, byte[] msg, QueryContext ctx) {
        Performance.gc(2);
        long max = Performance.memory();
        long mb = Math.max(0L, max - min);
        FNInfo.dump(Token.token(Performance.format(mb)), msg, ctx);
    }

    private Iter time(final QueryContext ctx) throws QueryException {
        byte[] msg;
        final Performance p = new Performance();
        byte[] byArray = msg = this.expr.length > 2 ? this.checkStr(this.expr[2], ctx) : null;
        if (this.expr.length > 1 && this.checkBln(this.expr[1], ctx)) {
            Value v = ctx.value(this.expr[0]).cache().value();
            FNInfo.dump(Token.token(p.getTime()), msg, ctx);
            return v.iter();
        }
        return new Iter(){
            final Iter ir;
            {
                this.ir = FNProf.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                Item i = this.ir.next();
                if (i == null) {
                    FNInfo.dump(Token.token(p.getTime()), msg, ctx);
                }
                return i;
            }
        };
    }

    private Item sleep(QueryContext ctx) throws QueryException {
        Performance.sleep(this.checkItr(this.expr[0], ctx));
        return null;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.NDT && FNProf.oneOf(this.sig, Function._PROF_SLEEP, Function._PROF_MEM, Function._PROF_TIME) || super.uses(u);
    }
}

