/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Locale;
import org.basex.build.Parser;
import org.basex.core.Prop;
import org.basex.io.IOContent;
import org.basex.io.MimeTypes;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.ANodeList;
import org.basex.query.util.Err;
import org.basex.query.util.http.HTTPText;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FElem;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.ByteList;

public final class HTTPResponse {
    private final InputInfo info;
    private final Prop prop;

    public HTTPResponse(InputInfo ii, Prop pr) {
        this.info = ii;
        this.prop = pr;
    }

    public ValueIter getResponse(HttpURLConnection conn, byte[] status, byte[] mediaTypeOvr) throws IOException, QueryException {
        FElem body;
        boolean s;
        ANodeList attrs = HTTPResponse.extractAttrs(conn);
        ANodeList hdrs = HTTPResponse.extractHdrs(conn);
        String cType = mediaTypeOvr == null ? HTTPResponse.extractContentType(conn.getContentType()) : Token.string(mediaTypeOvr);
        ValueBuilder payloads = new ValueBuilder();
        boolean bl = s = status != null && Bln.parse(status, this.info);
        if (cType.startsWith("multipart")) {
            byte[] boundary = this.extractBoundary(conn.getContentType());
            ANodeList a = new ANodeList(new FAttr(HTTPText.Q_MEDIA_TYPE, Token.token(cType)), new FAttr(HTTPText.Q_BOUNDARY, boundary));
            body = new FElem(HTTPText.HTTP_MULTIPART, this.extractParts(conn.getInputStream(), s, payloads, Token.concat(Token.token("--"), boundary)), a, new Atts(QueryText.HTTP, QueryText.HTTPURI));
        } else {
            body = HTTPResponse.createBody(cType);
            if (!s) {
                payloads.add(this.interpretPayload(HTTPResponse.extractPayload(conn.getInputStream(), cType, HTTPResponse.extractCharset(conn.getContentType())), cType));
            }
        }
        FElem responseEl = new FElem(HTTPText.HTTP_RESPONSE, hdrs, attrs, new Atts(QueryText.HTTP, QueryText.HTTPURI));
        responseEl.add(body);
        ValueBuilder result = new ValueBuilder();
        result.add(responseEl);
        result.add(payloads.value());
        return result;
    }

    private static ANodeList extractAttrs(HttpURLConnection conn) throws IOException {
        return new ANodeList(new FAttr(HTTPText.Q_STATUS, Token.token(conn.getResponseCode())), new FAttr(HTTPText.Q_MESSAGE, Token.token(conn.getResponseMessage())));
    }

    private static ANodeList extractHdrs(HttpURLConnection conn) {
        ANodeList h = new ANodeList();
        for (String headerName : conn.getHeaderFields().keySet()) {
            if (headerName == null) continue;
            FElem hdr = new FElem(HTTPText.HTTP_HEADER, new Atts(QueryText.HTTP, QueryText.HTTPURI));
            hdr.add(HTTPText.Q_NAME, Token.token(headerName));
            hdr.add(HTTPText.Q_VALUE, Token.token(conn.getHeaderField(headerName)));
            h.add(hdr);
        }
        return h;
    }

    private static FElem createBody(String mediaType) {
        FElem b = new FElem(HTTPText.HTTP_BODY, new Atts(QueryText.HTTP, QueryText.HTTPURI));
        b.add(HTTPText.Q_MEDIA_TYPE, Token.token(mediaType));
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] extractPayload(InputStream io, String c, String ce) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(io);
        try {
            int i;
            ByteList bl = new ByteList();
            while ((i = bis.read()) != -1) {
                bl.add(i);
            }
            if (MimeTypes.isXML(c) || c.equals("text/html") || c.startsWith("text/")) {
                byte[] byArray = new NewlineInput(new IOContent(bl.toArray())).encoding(ce).content();
                return byArray;
            }
            byte[] byArray = bl.toArray();
            return byArray;
        }
        finally {
            bis.close();
        }
    }

    private Item interpretPayload(byte[] p, String ct) {
        try {
            IOContent io = new IOContent(p);
            io.name("payload.xml");
            return Parser.item(io, this.prop, ct);
        }
        catch (IOException ex) {
            return new B64(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ANodeList extractParts(InputStream io, boolean status, ValueBuilder payloads, byte[] sep) throws IOException, QueryException {
        try {
            byte[] next = HTTPResponse.readLine(io);
            while (next != null && !Token.eq(sep, next)) {
                next = HTTPResponse.readLine(io);
            }
            if (next == null) {
                Err.HC_REQ.thrw(this.info, "No body specified for http:part");
            }
            byte[] end = Token.concat(sep, Token.token("--"));
            FElem nextPart = this.extractNextPart(io, status, payloads, sep, end);
            ANodeList p = new ANodeList();
            while (nextPart != null) {
                p.add(nextPart);
                nextPart = this.extractNextPart(io, status, payloads, sep, end);
            }
            ANodeList aNodeList = p;
            return aNodeList;
        }
        finally {
            io.close();
        }
    }

    private FElem extractNextPart(InputStream io, boolean status, ValueBuilder payloads, byte[] sep, byte[] end) throws IOException {
        String partCType = "text/plain";
        String charset = null;
        byte[] firstLine = HTTPResponse.readLine(io);
        if (firstLine == null || Token.eq(firstLine, end)) {
            return null;
        }
        FElem root = new FElem(HTTPText.Q_PART, new Atts(QueryText.HTTP, QueryText.HTTPURI));
        if (firstLine.length == 0) {
            byte[] p = HTTPResponse.extractPartPayload(io, sep, end, null);
            if (!status) {
                payloads.add(this.interpretPayload(p, partCType));
            }
        } else {
            byte[] nextHdr = firstLine;
            while (nextHdr != null && nextHdr.length > 0) {
                int pos;
                if (Token.startsWith(Token.lc(nextHdr), HTTPText.CONTENT_TYPE_LC)) {
                    charset = HTTPResponse.extractCharset(Token.string(nextHdr));
                }
                if ((pos = Token.indexOf(nextHdr, 58)) > 0) {
                    byte[] name = Token.substring(nextHdr, 0, pos);
                    if (pos + 1 < nextHdr.length) {
                        byte[] value = Token.trim(Token.substring(nextHdr, pos + 1, nextHdr.length));
                        FElem hdr = new FElem(HTTPText.HTTP_HEADER);
                        hdr.add(HTTPText.Q_NAME, name);
                        hdr.add(HTTPText.Q_VALUE, value);
                        root.add(hdr);
                        if (Token.eq(Token.lc(name), HTTPText.CONTENT_TYPE_LC)) {
                            partCType = Token.string(value);
                        }
                    }
                }
                nextHdr = HTTPResponse.readLine(io);
            }
            byte[] p = HTTPResponse.extractPartPayload(io, sep, end, charset);
            if (!status) {
                payloads.add(this.interpretPayload(p, partCType));
            }
        }
        root.add(HTTPResponse.createBody(partCType));
        return root;
    }

    private static byte[] readLine(InputStream in) throws IOException {
        int b;
        TokenBuilder tb = new TokenBuilder();
        while ((b = in.read()) != -1) {
            if (b == 13) {
                int b2;
                while (true) {
                    if ((b2 = in.read()) == 10) {
                        return tb.finish();
                    }
                    if (b2 == -1) {
                        return tb.add(b).finish();
                    }
                    if (b2 != 13) break;
                    tb.add(b);
                }
                tb.add(b).add(b2);
                continue;
            }
            tb.add(b);
        }
        return tb.isEmpty() ? null : tb.finish();
    }

    private static byte[] extractPartPayload(InputStream io, byte[] sep, byte[] end, String ce) throws IOException {
        byte[] next;
        ByteList bl = new ByteList();
        while ((next = HTTPResponse.readLine(io)) != null && !Token.eq(next, sep)) {
            if (Token.eq(next, end)) {
                while (HTTPResponse.readLine(io) != null) {
                }
                break;
            }
            bl.add(next).add(10);
        }
        return new NewlineInput(new IOContent(bl.toArray())).encoding(ce).content();
    }

    private static String extractContentType(String c) {
        if (c == null) {
            return "application/octet-stream";
        }
        int end = c.indexOf(59);
        return end == -1 ? c : c.substring(0, end);
    }

    private byte[] extractBoundary(String c) throws QueryException {
        String b;
        int index = c.toLowerCase(Locale.ENGLISH).lastIndexOf("boundary=");
        if (index == -1) {
            Err.HC_REQ.thrw(this.info, "No separation boundary specified");
        }
        if ((b = c.substring(index + 9)).charAt(0) == '\"') {
            index = b.lastIndexOf(34);
            b = b.substring(1, index);
        }
        return Token.token(b);
    }

    private static String extractCharset(String c) {
        if (c == null) {
            return null;
        }
        String cs = "charset=";
        int i = c.toLowerCase(Locale.ENGLISH).lastIndexOf("charset=");
        return i == -1 ? null : c.substring(i + "charset=".length());
    }
}

