/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Err;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class ByteSeq
extends Seq {
    private final byte[] bytes;
    private final SeqType seq = SeqType.get((Type)AtomType.BYT, SeqType.Occ.ONE_MORE);

    public ByteSeq(byte[] b) {
        super(b.length);
        this.bytes = b;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.thrw(ii, this);
    }

    @Override
    public SeqType type() {
        return this.seq;
    }

    @Override
    public boolean iterable() {
        return false;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof ByteSeq && Token.eq(this.bytes, ((ByteSeq)cmp).bytes);
    }

    @Override
    public int writeTo(Item[] arr, int start) {
        int i = 0;
        while ((long)i < this.size) {
            arr[start + i] = new Int(this.bytes[i], AtomType.BYT);
            ++i;
        }
        return (int)this.size;
    }

    @Override
    public Item itemAt(long pos) {
        return new Int(this.bytes[(int)pos], AtomType.BYT);
    }

    @Override
    public boolean homogenous() {
        return true;
    }

    public byte[] bytes() {
        return this.bytes;
    }
}

