/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;

public final class BitArray {
    private static final int WORD_POWER = 6;
    private static final int WORD_SIZE = 64;
    private static final long WORD_MASK = -1L;
    private long[] words;
    private int size;
    private boolean all;

    public BitArray() {
        this(64);
    }

    public BitArray(int n) {
        this.init(n);
    }

    public BitArray(long[] a, int l) {
        this.init(a, l);
    }

    public void init() {
        this.init(new long[1], 0);
    }

    void init(int n) {
        this.init(new long[(Math.max(0, n - 1) >>> 6) + 1], n);
    }

    public void init(long[] a, int l) {
        this.words = a;
        this.size = l;
        this.all = false;
    }

    public long[] toArray() {
        if (this.all) {
            long[] result = new long[this.words.length];
            Arrays.fill(result, -1L);
            return result;
        }
        int i = this.words.length;
        while (--i >= 0 && this.words[i] == 0L) {
        }
        long[] result = new long[++i];
        System.arraycopy(this.words, 0, result, 0, i);
        return result;
    }

    public boolean get(int i) {
        if (i >= this.size) {
            return false;
        }
        if (this.all) {
            return true;
        }
        int wi = i >>> 6;
        return (this.words[wi] & 1L << i) != 0L;
    }

    public void set(int i) {
        int wi;
        int oi = this.size >>> 6;
        if (this.all && i >= this.size) {
            for (int j = 0; j < oi; ++j) {
                this.words[j] = -1L;
            }
            this.words[oi] = Long.MAX_VALUE >> this.size % 64 - 1;
            boolean bl = this.all = i <= this.size;
        }
        if ((wi = i >>> 6) >= this.words.length) {
            this.resize(wi + 1);
        }
        int n = wi;
        this.words[n] = this.words[n] | 1L << i;
        if (i >= this.size) {
            this.size = i + 1;
        }
    }

    public void setAll() {
        this.all = true;
    }

    public boolean getAll() {
        return this.all || this.nextFree(0) == this.size;
    }

    public void clear(int i) {
        int wi;
        if (this.all) {
            this.all = false;
            Arrays.fill(this.words, -1L);
        }
        if ((wi = i >>> 6) >= this.words.length) {
            this.resize(wi + 1);
        }
        int n = wi;
        this.words[n] = this.words[n] & (1L << i ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int nextFree(int i) {
        if (this.all) {
            return this.size;
        }
        int wi = i >>> 6;
        long word = (this.words[wi] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << i;
        if (word != 0L) {
            return (wi << 6) + Long.numberOfTrailingZeros(word);
        }
        while (++wi < this.words.length) {
            word = this.words[wi] ^ 0xFFFFFFFFFFFFFFFFL;
            if (word == 0L) continue;
            return (wi << 6) + Long.numberOfTrailingZeros(word);
        }
        return wi << 6;
    }

    private void resize(int s) {
        long[] tmp = new long[Math.max(this.words.length << 1, s)];
        System.arraycopy(this.words, 0, tmp, 0, this.words.length);
        this.words = tmp;
    }
}

