/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.projects;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.projects.RecentProjects;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.ProjectPreviewPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectManager {
    private final File recentProjectsFile;
    private ProjectRecord defaultProject = null;
    private HashMap<ProjectRecord, EntityCollection> projectEntityCollectionMap = new HashMap();
    private final ArbilWindowManager dialogHandler;
    public static final String kinoathproj = "kinoath.proj";
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Widgets");

    public ProjectManager(SessionStorage sessionStorage, ArbilWindowManager dialogHandler) {
        this.recentProjectsFile = new File(sessionStorage.getApplicationSettingsDirectory(), "RecentProjects.xml");
        this.dialogHandler = dialogHandler;
    }

    @Deprecated
    public ProjectRecord getDefaultProject(SessionStorage sessionStorage) {
        if (this.defaultProject == null) {
            try {
                this.defaultProject = this.loadProjectRecord(sessionStorage.getProjectDirectory());
            }
            catch (JAXBException exception) {
                this.defaultProject = new ProjectRecord(sessionStorage.getProjectDirectory(), sessionStorage.getProjectDirectory().getName(), "nl-mpi-kinnate");
                try {
                    this.saveProjectRecord(this.defaultProject, true, true);
                }
                catch (JAXBException saveRecordException) {
                    this.dialogHandler.addMessageDialogToQueue("Save project record failed: " + (Object)((Object)saveRecordException), "KinOath Project Check");
                    BugCatcherManager.getBugCatcher().logError((Exception)((Object)saveRecordException));
                }
            }
        }
        return this.defaultProject;
    }

    public List<ProjectRecord> getProjectRecords(SessionStorage sessionStorage) throws JAXBException {
        return this.getRecentProjectsList().getProjectRecords();
    }

    public void moveProjectRecordToTop(ProjectRecord projectRecord, KinDiagramPanel diagramPanel) throws JAXBException {
        RecentProjects recentProjectsList = this.getRecentProjectsList();
        this.checkProjectChangeDate(recentProjectsList, projectRecord, diagramPanel);
        recentProjectsList.moveProjectRecordToTop(projectRecord);
        this.saveRecentProjectsList(recentProjectsList);
    }

    public void clearRecentProjectsList() throws JAXBException {
        RecentProjects recentProjectsList = this.getRecentProjectsList();
        recentProjectsList.clearList();
        this.saveRecentProjectsList(recentProjectsList);
    }

    public EntityCollection getEntityCollectionForProject(ProjectRecord projectRecord) throws EntityServiceException {
        if (this.projectEntityCollectionMap.containsKey(projectRecord)) {
            return this.projectEntityCollectionMap.get(projectRecord);
        }
        EntityCollection entityCollection = new EntityCollection(this, projectRecord);
        this.projectEntityCollectionMap.put(projectRecord, entityCollection);
        return entityCollection;
    }

    public RecentProjects getRecentProjectsList() throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RecentProjects.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        if (this.recentProjectsFile.exists()) {
            RecentProjects recentProjects = (RecentProjects)unmarshaller.unmarshal(this.recentProjectsFile);
            recentProjects.removeMissingProjects();
            return recentProjects;
        }
        return new RecentProjects();
    }

    private void saveRecentProjectsList(RecentProjects recentProjects) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RecentProjects.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)recentProjects, this.recentProjectsFile);
    }

    public void saveProjectRecord(ProjectRecord projectRecord, boolean updateInRecentList, boolean updateInProjectDirectory) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProjectRecord.class});
        if (updateInProjectDirectory) {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)projectRecord, new File(projectRecord.projectDirectory, kinoathproj));
        }
        if (updateInRecentList) {
            RecentProjects recentProjectsList = this.getRecentProjectsList();
            recentProjectsList.updateProjectRecord(projectRecord);
            this.saveRecentProjectsList(recentProjectsList);
        }
    }

    public ProjectRecord checkForMissingProject(ProjectRecord projectRecord) throws JAXBException {
        if (projectRecord.getProjectDirectory().exists()) {
            return projectRecord;
        }
        try {
            RecentProjects recentProjectsList = this.getRecentProjectsList();
            for (ProjectRecord recentProject : recentProjectsList.recentProjects) {
                if (!recentProject.getProjectUUID().equals(projectRecord.getProjectUUID()) || !recentProject.getProjectDirectory().exists()) continue;
                return recentProject;
            }
        }
        catch (JAXBException exception) {
            // empty catch block
        }
        ProjectPreviewPanel previewPanel = new ProjectPreviewPanel(this, false);
        this.dialogHandler.showDialogBox(widgets.getString("THE PROJECT FOR THIS DIAGRAM COULD NOT BE FOUND.PLEASE BROWSE FOR THE REQUIRED PROJECT."), widgets.getString("OPEN PROJECT ERROR"), 0, 1);
        File[] selectedFilesArray = this.dialogHandler.showFileSelectBox(widgets.getString("OPEN PROJECT"), false, false, this.getProjectFileFilter(), PluginDialogHandler.DialogueType.open, (JComponent)previewPanel);
        if (selectedFilesArray != null) {
            System.out.println(selectedFilesArray[0].getAbsolutePath());
            return this.loadProjectRecord(selectedFilesArray[0]);
        }
        return projectRecord;
    }

    public ProjectRecord loadProjectRecord(File projectDirectory) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProjectRecord.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        File projectFile = projectDirectory.isFile() && kinoathproj.equals(projectDirectory.getName()) ? projectDirectory : new File(projectDirectory, kinoathproj);
        ProjectRecord projectRecord = (ProjectRecord)unmarshaller.unmarshal(projectFile);
        projectRecord.setProjectDirectory(projectFile.getParentFile());
        return projectRecord;
    }

    private void checkProjectChangeDate(RecentProjects recentProjectsList, ProjectRecord projectRecord, KinDiagramPanel diagramPanel) {
        for (ProjectRecord recentProjectRecord : recentProjectsList.getProjectRecords()) {
            if (!recentProjectRecord.equals(projectRecord)) continue;
            this.checkProjectChangeDate(recentProjectRecord, projectRecord, diagramPanel);
            return;
        }
        this.recreateDatabse(projectRecord, diagramPanel);
    }

    private void checkProjectChangeDate(ProjectRecord databaseProjectRecord, final ProjectRecord projectRecord, final KinDiagramPanel diagramPanel) {
        if (!databaseProjectRecord.getLastChangeId().equals(projectRecord.getLastChangeId())) {
            new Thread(new Runnable(){

                public void run() {
                    String message = MessageFormat.format(widgets.getString("THE PROJECT '{0}' HAS BEEN MODIFIED EXTERNALLY,DO YOU WANT TO UPDATE THE DATABASE SO THAT THE CHANGES ARE VISIBLE?"), projectRecord.projectName);
                    if (0 == ProjectManager.this.dialogHandler.showDialogBox(message, widgets.getString("KINOATH PROJECT CHECK"), 2, 3)) {
                        try {
                            diagramPanel.showProgressBar();
                            ProjectManager.this.getEntityCollectionForProject(projectRecord).recreateDatabase();
                        }
                        catch (EntityServiceException exception) {
                            ProjectManager.this.dialogHandler.addMessageDialogToQueue("Database update failed: " + exception, "KinOath Project Check");
                        }
                        diagramPanel.clearProgressBar();
                    }
                }
            }).start();
        }
    }

    private void recreateDatabse(final ProjectRecord projectRecord, final KinDiagramPanel diagramPanel) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    diagramPanel.showProgressBar();
                    ProjectManager.this.getEntityCollectionForProject(projectRecord).recreateDatabase();
                }
                catch (EntityServiceException exception) {
                    ProjectManager.this.dialogHandler.addMessageDialogToQueue("Database update failed: " + exception, "KinOath Project Check");
                }
                diagramPanel.clearProgressBar();
            }
        }).start();
    }

    public HashMap<String, FileFilter> getProjectFileFilter() {
        HashMap<String, FileFilter> fileFilterMap = new HashMap<String, FileFilter>(2);
        for (final String[] currentType : new String[][]{{widgets.getString("KINOATH PROJECT"), kinoathproj}}) {
            fileFilterMap.put(currentType[0], new FileFilter(){

                public boolean accept(File selectedFile) {
                    if (selectedFile.isDirectory()) {
                        return true;
                    }
                    try {
                        ProjectRecord projectRecord = ProjectManager.this.loadProjectRecord(selectedFile);
                        return projectRecord != null;
                    }
                    catch (JAXBException exception) {
                        return false;
                    }
                }

                public String getDescription() {
                    return currentType[0];
                }
            });
        }
        return fileFilterMap;
    }
}

