/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class ArchiveMenu
extends JMenu {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    AbstractDiagramManager diagramWindowManager;
    KinTermSavePanel currentKinTermSavePanel;
    JCheckBoxMenuItem hideShowMenu;
    JMenuItem showRemoteTreeMenu;
    JMenuItem showLocalTreeMenu;
    JMenu showResultsMenu;
    JMenu closeResultsMenu;

    public ArchiveMenu(AbstractDiagramManager diagramWindowManager, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.initMenu(parentComponent);
    }

    private void initMenu(final Component parentComponent) {
        this.hideShowMenu = new JCheckBoxMenuItem(menus.getString("SHOW"));
        this.showRemoteTreeMenu = new JMenuItem(menus.getString("ARCHIVE TREE"));
        this.showLocalTreeMenu = new JMenuItem(menus.getString("LOCAL TREE"));
        this.closeResultsMenu = new JMenu(menus.getString("CLOSE RESULTS"));
        this.showResultsMenu = new JMenu(menus.getString("SHOW RESULTS"));
        this.setText(menus.getString("ARCHIVE LINKER"));
        this.add(this.hideShowMenu);
        this.add(this.showRemoteTreeMenu);
        this.add(this.showLocalTreeMenu);
        this.add(this.closeResultsMenu);
        this.add(this.showResultsMenu);
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent evt) {
                ArchiveMenu.this.currentKinTermSavePanel = ArchiveMenu.this.diagramWindowManager.getKinTermPanel(parentComponent);
                if (ArchiveMenu.this.currentKinTermSavePanel != null) {
                    if (ArchiveMenu.this.currentKinTermSavePanel.getPanelState(VisiblePanelSetting.PanelType.ArchiveLinker)) {
                        ArchiveMenu.this.hideShowMenu.setSelected(true);
                    } else {
                        ArchiveMenu.this.hideShowMenu.setSelected(false);
                    }
                }
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuCanceled(MenuEvent evt) {
            }
        });
        this.hideShowMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArchiveMenu.this.currentKinTermSavePanel.setPanelState(VisiblePanelSetting.PanelType.ArchiveLinker, ArchiveMenu.this.hideShowMenu.isSelected());
            }
        });
    }
}

