/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.xml.bind.JAXBException;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.ui.ProjectPreviewPanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class ProjectFileMenu
extends JMenu
implements ActionListener {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    private final AbstractDiagramManager diagramWindowManager;
    private final Component parentComponent;
    private final MessageDialogHandler dialogHandler;
    private final ProjectManager projectManager;

    public ProjectFileMenu(AbstractDiagramManager diagramWindowManager, Component parentComponent, MessageDialogHandler dialogHandler, ProjectManager projectManager) {
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        this.dialogHandler = dialogHandler;
        this.projectManager = projectManager;
        this.setText(menus.getString("OPEN RECENT PROJECT"));
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                ProjectFileMenu.this.setupMenu();
            }
        });
    }

    private void setupMenu() {
        this.removeAll();
        try {
            for (ProjectRecord projectRecord : this.projectManager.getRecentProjectsList().getProjectRecords()) {
                JMenuItem currentMenuItem = new JMenuItem(projectRecord.getProjectName());
                currentMenuItem.setToolTipText(projectRecord.getProjectDirectory().getAbsolutePath());
                currentMenuItem.setActionCommand(projectRecord.getProjectDirectory().getAbsolutePath());
                currentMenuItem.addActionListener(this);
                this.add(currentMenuItem);
            }
            this.add(new JSeparator());
            JMenuItem clearMenuItem = new JMenuItem(menus.getString("CLEAR LIST"));
            clearMenuItem.setActionCommand("Clear List");
            clearMenuItem.addActionListener(this);
            this.add(clearMenuItem);
        }
        catch (JAXBException exception) {
            JMenuItem currentMenuItem = new JMenuItem(menus.getString("<RECENT PROJECTS COULD NOT BE FOUND>"));
            currentMenuItem.setEnabled(false);
            this.add(currentMenuItem);
        }
    }

    private void openProject(ProjectRecord projectRecord) {
        Dimension parentSize = this.parentComponent.getSize();
        Point parentLocation = this.parentComponent.getLocation();
        int offset = 10;
        try {
            this.diagramWindowManager.newDiagram(new Rectangle(parentLocation.x + offset, parentLocation.y + offset, parentSize.width - offset, parentSize.height - offset), projectRecord);
        }
        catch (EntityServiceException entityServiceException) {
            this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO CREATE A NEW DIAGRAM: {0}"), entityServiceException.getMessage()), "Open Diagram Error");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("new".equals(e.getActionCommand())) {
            File[] selectedFilesArray = this.dialogHandler.showFileSelectBox(menus.getString("NEW PROJECT"), true, false, this.projectManager.getProjectFileFilter(), PluginDialogHandler.DialogueType.save, null);
            if (selectedFilesArray != null) {
                File selecteFile = selectedFilesArray[0];
                System.out.println(selecteFile.getAbsolutePath());
                if (selecteFile.exists()) {
                    this.dialogHandler.addMessageDialogToQueue(menus.getString("THE SELECTED FILE ALREADY EXISTS, PLEASE ENTER A UNIQUE NAME."), menus.getString("CREATE PROJECT"));
                } else {
                    ProjectRecord projectRecord = new ProjectRecord(selecteFile, selecteFile.getName());
                    try {
                        selecteFile.mkdir();
                        this.projectManager.saveProjectRecord(projectRecord, true, true);
                        this.openProject(projectRecord);
                    }
                    catch (JAXBException exception) {
                        this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Create Project Error");
                    }
                }
            }
        } else if ("browse".equals(e.getActionCommand())) {
            ProjectPreviewPanel previewPanel = new ProjectPreviewPanel(this.projectManager, false);
            File[] selectedFilesArray = this.dialogHandler.showFileSelectBox(menus.getString("OPEN PROJECT"), false, false, this.projectManager.getProjectFileFilter(), PluginDialogHandler.DialogueType.open, (JComponent)previewPanel);
            if (selectedFilesArray != null) {
                System.out.println(selectedFilesArray[0].getAbsolutePath());
                try {
                    this.openProject(this.projectManager.loadProjectRecord(selectedFilesArray[0]));
                }
                catch (JAXBException exception) {
                    this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Read Project Record Error");
                }
            }
        } else if ("Clear List".equals(e.getActionCommand())) {
            try {
                this.projectManager.clearRecentProjectsList();
            }
            catch (JAXBException exception) {
                BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            }
        } else {
            try {
                String actionString = e.getActionCommand();
                File recentProjectFile = new File(actionString);
                ProjectRecord selectedProjectRecord = this.projectManager.loadProjectRecord(recentProjectFile);
                this.openProject(selectedProjectRecord);
            }
            catch (JAXBException exception) {
                this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO OPEN PROJECT: {0}"), exception.getMessage()), "Open Project Error");
            }
        }
    }
}

