/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.plugins.export;

import java.io.File;
import java.util.Date;
import nl.mpi.flap.kinnate.entityindexer.QueryException;
import nl.mpi.kinnate.entityindexer.CollectionExport;

public class GedcomExport {
    private CollectionExport entityCollection;

    public GedcomExport(CollectionExport entityCollection) {
        this.entityCollection = entityCollection;
    }

    private String getHeader() {
        return "let $headerString := \"0 HEAD\n1 ExportDate " + new Date().toString() + "\n\"\n";
    }

    private String getQueryFunctions() {
        return "declare function local:getSubFields($levelCounter, $currentNode) {\nif ($currentNode/descendant-or-self::*/text() != \"\") then (\nlet $fieldText := replace($currentNode/text(), \"\n\", concat(\"\n\", $levelCounter+1,\" CONT \"))\nlet $result := concat($levelCounter, \" \", $currentNode/name(), \" \",$fieldText,\"\n\",\nstring-join(for $subNode in $currentNode/*\n return local:getSubFields($levelCounter + 1, $subNode)))\nreturn $result\n) else ( )};\n";
    }

    private String getRelationFields() {
        return "string-join(for $relationNode in $kinnateNode/*:Entity/*:Relations/*return concat(\"1 \",\n$relationNode/@*:Type/string(),\n\":\",$relationNode/@*:CustomType/string(),\":\",$relationNode/@*:dcr/string(),\n\" @\",$relationNode/*:Identifier/@*:type/string(),\n\"_\",$relationNode/*:Identifier/text(),\"@\n\"\n))\n";
    }

    private String getEntityFields() {
        return "string-join(for $dataField in $kinnateNode/*:CustomData/* return local:getSubFields(1, $dataField))\n";
    }

    private String getIndividual() {
        return "return concat(\"0 @\",$kinnateNode/*:Entity/*:Identifier/@*:type/string(), \"_\", $kinnateNode/*:Entity/*:Identifier/text(),\"@ INDI\n\",\n" + this.getEntityFields() + ",\n" + this.getRelationFields() + ")\n";
    }

    public String getGedcomQuery() {
        return this.getQueryFunctions() + this.getHeader() + "let $entitySection := for $kinnateNode in collection('" + this.entityCollection.getDatabaseName() + "')/*:Kinnate\n" + this.getIndividual() + "return concat($headerString, string-join($entitySection))\n";
    }

    private String getCvsQuery() {
        return "let $colNames := distinct-values(collection('" + this.entityCollection.getDatabaseName() + "')/*:Kinnate/*:CustomData/*//local-name())\n" + "let $fileHeader := concat(string-join($colNames, \",\"), \"&#10;\")\n" + "let $fileLines :=\n" + "for $entityNode in collection('" + this.entityCollection.getDatabaseName() + "')/*:Kinnate\n" + "let $lineString := \n" + "for $column in $colNames\n" + "return concat('\"', $entityNode/*:CustomData/*[local-name()=$column]/text(), '\"')\n" + "return string-join($lineString, \",\")\n" + "let $fileBody := string-join($fileLines, \"&#10;\")\n" + "return concat($fileHeader, $fileBody)\n";
    }

    public String getCsvDemoQuery() {
        return "let $colNames := collection('SimpleExportTemp')[1]\nreturn  $colNames\n";
    }

    public String getHeaderQuery() {
        return "for $xpathString in distinct-values(\nfor $entityNode in collection('" + this.entityCollection.getDatabaseName() + "')/*:Kinnate/*:CustomData/descendant-or-self::*[text() != '']\n" + "return path($entityNode)\n" + ")\n" + "return\n" + "$xpathString";
    }

    public String getXPaths() {
        return "for $elementName in collection('" + this.entityCollection.getDatabaseName() + "')/*:Kinnate/*:CustomData\n" + "return fn:path($elementName)\n";
    }

    public String dropAndImportCsv(File importDirectory, String fileFilter) throws QueryException {
        return this.entityCollection.dropAndImportCsv(importDirectory, fileFilter);
    }

    public void dropAndCreate(File importDirectory, String fileFilter) throws QueryException {
        this.entityCollection.createExportDatabase(importDirectory, fileFilter);
    }

    public String generateExport(String[] selectedFieldNames, String[] selectedFieldPath) throws QueryException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String currentHeader : selectedFieldNames) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\",\"");
            } else {
                stringBuilder.append("let $headerString := '\"");
            }
            stringBuilder.append(currentHeader);
        }
        stringBuilder.append("\"\n'\n");
        stringBuilder.append("let $bodyString := for $documentNode in collection('");
        stringBuilder.append(this.entityCollection.getDatabaseName());
        stringBuilder.append("')\nreturn\nconcat(\n'\"',\n");
        boolean firstColumn = true;
        for (String currentField : selectedFieldPath) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                stringBuilder.append(",'\",\"',\n");
            }
            stringBuilder.append("$documentNode");
            stringBuilder.append(currentField);
            stringBuilder.append("/text()");
        }
        stringBuilder.append(",'\"')\n");
        stringBuilder.append("return concat($headerString, string-join($bodyString,\"\n\"))\n");
        return stringBuilder.toString();
    }

    public String generateExport(String exportQuery) throws QueryException {
        return this.entityCollection.performExportQuery(exportQuery);
    }

    public boolean databaseReady() {
        return true;
    }
}

