/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Perm;
import org.basex.core.ProgressException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.data.MemData;
import org.basex.data.MetaData;
import org.basex.index.IndexType;
import org.basex.index.ft.FTBuilder;
import org.basex.index.value.ValueBuilder;
import org.basex.io.IO;
import org.basex.io.IOStream;
import org.basex.io.in.LookupInput;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class CreateDB
extends ACreate {
    private Parser parser;

    public CreateDB(String name) {
        this(name, (String)null);
    }

    public CreateDB(String name, String input) {
        super(name, input);
    }

    public void setParser(Parser p) {
        this.parser = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!MetaData.validName(name, false)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        IO io = null;
        try {
            io = this.sourceToIO(name);
            if (this.in != null) {
                LookupInput li = new LookupInput(io.inputStream());
                io = li.lookup() == -1 ? null : new IOStream(li, io.name());
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(Util.message(ex), new Object[0]);
        }
        if (io != null) {
            if (!io.exists()) {
                return this.error(Text.RES_NOT_FOUND_X, io);
            }
            this.parser = new DirParser(io, this.prop, this.mprop.dbpath(name));
        } else if (this.parser == null) {
            this.parser = Parser.emptyParser(this.context.prop);
        }
        new Close().run(this.context);
        try {
            if (this.prop.is(Prop.MAINMEM)) {
                MemData data = this.progress(new MemBuilder(name, this.parser)).build();
                this.context.openDB(data);
                this.context.pin(data);
            } else {
                if (this.context.pinned(name)) {
                    return this.error(Text.DB_PINNED_X, name);
                }
                this.progress(new DiskBuilder(name, this.parser, this.context)).build().close();
                Open open = new Open(name);
                if (!open.run(this.context)) {
                    return this.error(open.info(), new Object[0]);
                }
                Data data = this.context.data();
                try {
                    if (data.meta.createtext) {
                        CreateDB.create(IndexType.TEXT, data, this);
                    }
                    if (data.meta.createattr) {
                        CreateDB.create(IndexType.ATTRIBUTE, data, this);
                    }
                    if (data.meta.createftxt) {
                        CreateDB.create(IndexType.FULLTEXT, data, this);
                    }
                }
                finally {
                    data.finishUpdate();
                }
                this.context.databases().add(name);
            }
            return this.info(this.parser.info() + Text.DB_CREATED_X_X, name, this.perf);
        }
        catch (ProgressException ex) {
            throw ex;
        }
        catch (IOException ex) {
            Util.debug(ex);
            this.abort();
            String msg = ex.getMessage();
            return this.error(msg != null && !msg.isEmpty() ? msg : Util.info(Text.NOT_PARSED_X, this.parser.src), new Object[0]);
        }
        catch (Exception ex) {
            Util.debug(ex);
            this.abort();
            return this.error(Util.info(Text.NOT_PARSED_X, this.parser.src), new Object[0]);
        }
    }

    @Override
    protected boolean databases(StringList db) {
        db.add("").add(this.args[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Data create(String name, Parser parser, Context ctx) throws IOException {
        if (!ctx.user.has(Perm.CREATE)) {
            throw new BaseXException(Text.PERM_REQUIRED_X, new Object[]{Perm.CREATE});
        }
        Prop prop = ctx.prop;
        if (prop.is(Prop.MAINMEM)) {
            return MemBuilder.build(name, parser);
        }
        if (ctx.pinned(name)) {
            throw new BaseXException(Text.DB_PINNED_X, name);
        }
        DiskBuilder builder = new DiskBuilder(name, parser, ctx);
        try {
            DiskData data = builder.build();
            if (data.meta.createtext) {
                ((Data)data).setIndex(IndexType.TEXT, new ValueBuilder(data, true).build());
            }
            if (data.meta.createattr) {
                ((Data)data).setIndex(IndexType.ATTRIBUTE, new ValueBuilder(data, false).build());
            }
            if (data.meta.createftxt) {
                ((Data)data).setIndex(IndexType.FULLTEXT, new FTBuilder(data).build());
            }
            ((Data)data).close();
        }
        finally {
            builder.close();
        }
        ctx.databases().add(name);
        return Open.open(name, ctx);
    }

    public static synchronized MemData mainMem(Parser parser, Context ctx) throws IOException {
        if (ctx.user.has(Perm.CREATE)) {
            return MemBuilder.build(parser);
        }
        throw new BaseXException(Text.PERM_REQUIRED_X, new Object[]{Perm.CREATE});
    }

    public static synchronized MemData mainMem(IO source, Context ctx) throws IOException {
        if (!source.exists()) {
            throw new BaseXException(Text.RES_NOT_FOUND_X, source);
        }
        return CreateDB.mainMem(new DirParser(source, ctx.prop, null), ctx);
    }

    public static synchronized Data create(IO source, boolean single, Context ctx) throws IOException {
        if (!source.exists() || single && source.isDir()) {
            throw new BaseXException(Text.RES_NOT_FOUND_X, source);
        }
        if (!ctx.prop.is(Prop.FORCECREATE)) {
            return CreateDB.mainMem(source, ctx);
        }
        String nm = source.dbname();
        DirParser dp = new DirParser(source, ctx.prop, ctx.mprop.dbpath(nm));
        return CreateDB.create(nm, dp, ctx);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.DB)).args();
    }
}

