/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.AQuery;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.Nodes;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class InfoStorage
extends AQuery {
    public InfoStorage(String ... arg) {
        super(Perm.READ, true, arg.length > 0 ? arg[0] : null, arg.length > 1 ? arg[1] : null);
    }

    @Override
    protected boolean run() throws IOException {
        String start = this.args[0];
        String end = this.args[1];
        if (start != null && Token.toInt(start) == Integer.MIN_VALUE) {
            this.queryNodes();
            if (this.result == null) {
                return false;
            }
        }
        Data data = this.context.data();
        if (this.result != null) {
            Table table = InfoStorage.th();
            for (int n : ((Nodes)this.result).pres) {
                InfoStorage.table(table, data, n);
            }
            this.out.print(table.finish());
            this.result = null;
        } else {
            int ps = 0;
            int pe = 1000;
            if (start != null) {
                if (end != null) {
                    ps = Token.toInt(start);
                    pe = Token.toInt(end) + 1;
                } else {
                    ps = Token.toInt(start);
                    pe = ps + 1;
                }
            }
            this.out.print(InfoStorage.table(data, ps, pe));
        }
        return true;
    }

    @Override
    protected boolean databases(StringList db) {
        db.add("");
        return true;
    }

    public static byte[] table(Data data, int s, int e) {
        TokenBuilder tb = new TokenBuilder();
        int ps = Math.max(0, s);
        int pe = Math.min(data.meta.size, e);
        Table table = InfoStorage.th();
        for (int p = ps; p < pe; ++p) {
            InfoStorage.table(table, data, p);
        }
        tb.add(table.finish());
        byte[] ns = data.nspaces.table(ps, pe);
        if (ns.length != 0) {
            tb.add(Text.NL).add(ns).add(data.nspaces.toString(ps, pe)).add(Text.NL);
        }
        return tb.finish();
    }

    private static Table th() {
        Table t = new Table();
        t.header.add(DataText.TABLEPRE);
        t.header.add(DataText.TABLEDIST);
        t.header.add(DataText.TABLESIZE);
        t.header.add(DataText.TABLEATS);
        t.header.add(DataText.TABLEID);
        t.header.add(DataText.TABLENS);
        t.header.add(DataText.TABLEKND);
        t.header.add(DataText.TABLECON);
        for (int i = 0; i < 6; ++i) {
            t.align.add(true);
        }
        return t;
    }

    private static void table(Table t, Data data, int p) {
        int k = data.kind(p);
        TokenList tl = new TokenList();
        tl.add(p);
        tl.add(p - data.parent(p, k));
        tl.add(data.size(p, k));
        tl.add(data.attSize(p, k));
        tl.add(data.id(p));
        int u = data.uri(p, k);
        if (data.nsFlag(p)) {
            tl.add("+" + u);
        } else {
            tl.add(u);
        }
        tl.add(DataText.TABLEKINDS[k]);
        byte[] cont = k == 1 ? data.name(p, k) : (k == 3 ? new TokenBuilder(data.name(p, k)).add(DataText.ATT1).add(data.text(p, false)).add(DataText.ATT2).finish() : data.text(p, true));
        tl.add(Token.replace(Token.chop(cont, 64), 10, 32));
        t.contents.add(tl);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.INFO) + " " + (Object)((Object)Commands.CmdInfo.STORAGE));
        if (this.args[0] != null && Token.toInt(this.args[0]) == Integer.MIN_VALUE) {
            cb.xquery(0);
        } else {
            cb.arg(0).arg(1);
        }
    }
}

