/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class ShowUsers
extends Command {
    public ShowUsers() {
        this(null);
    }

    public ShowUsers(String db) {
        super(Perm.ADMIN, db);
    }

    @Override
    protected boolean run() throws IOException {
        String name;
        String string = name = this.args[0] == null || this.args[0].isEmpty() ? null : this.args[0];
        if (name != null && !MetaData.validName(name, false)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        if (name != null) {
            try {
                Data data = Open.open(name, this.context);
                this.out.println(data.meta.users.info(this.context.users));
                Close.close(data, this.context);
                return true;
            }
            catch (IOException ex) {
                Util.debug(ex);
                String msg = ex.getMessage();
                return msg.isEmpty() ? this.error(Text.DB_NOT_OPENED_X, name) : this.error(msg, new Object[0]);
            }
        }
        this.out.println(this.context.users.info(null));
        return true;
    }

    @Override
    protected boolean databases(StringList db) {
        return true;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.SHOW) + " " + (Object)((Object)Commands.CmdShow.USERS)).arg("ON", 0);
    }
}

