/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.basex.index.IndexEntry;
import org.basex.util.Token;

public final class IndexCache {
    private final ReferenceQueue<IndexEntry> queue = new ReferenceQueue();
    private BucketEntry[] bucket = new BucketEntry[8];
    private int size;

    public IndexEntry get(byte[] key) {
        BucketEntry e;
        this.purge();
        int hash = Token.hash(key);
        int i = IndexCache.indexFor(hash, this.bucket.length);
        BucketEntry prev = e = this.bucket[i];
        while (e != null) {
            BucketEntry next = e.next;
            IndexEntry entry = (IndexEntry)e.get();
            if (entry == null) {
                this.delete(i, e, prev, next);
            } else if (e.hash == hash && Token.eq(entry.key, key)) {
                return entry;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    public IndexEntry add(byte[] key, int s, long p) {
        BucketEntry e;
        this.purge();
        int hash = Token.hash(key);
        int i = IndexCache.indexFor(hash, this.bucket.length);
        BucketEntry prev = e = this.bucket[i];
        while (e != null) {
            BucketEntry next = e.next;
            IndexEntry ce = (IndexEntry)e.get();
            if (ce == null) {
                this.delete(i, e, prev, next);
            } else if (e.hash == hash && Token.eq(ce.key, key)) {
                ce.size = s;
                ce.pointer = p;
                return ce;
            }
            prev = e;
            e = next;
        }
        e = this.bucket[i];
        IndexEntry ce = new IndexEntry(key, s, p);
        this.bucket[i] = new BucketEntry(hash, e, ce, this.queue);
        if (++this.size == this.bucket.length) {
            this.rehash();
        }
        return ce;
    }

    public void delete(byte[] key) {
        BucketEntry e;
        this.purge();
        int hash = Token.hash(key);
        int i = IndexCache.indexFor(hash, this.bucket.length);
        BucketEntry prev = e = this.bucket[i];
        while (e != null) {
            BucketEntry next = e.next;
            IndexEntry entry = (IndexEntry)e.get();
            if (entry == null) {
                this.delete(i, e, prev, next);
            } else if (e.hash == hash && Token.eq(entry.key, key)) {
                this.delete(i, e, prev, next);
                return;
            }
            prev = e;
            e = next;
        }
    }

    private void delete(int i, BucketEntry e, BucketEntry p, BucketEntry n) {
        if (p == e) {
            this.bucket[i] = n;
        } else {
            p.next = n;
        }
        e.next = null;
        --this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        Reference<IndexEntry> x;
        while ((x = this.queue.poll()) != null) {
            ReferenceQueue<IndexEntry> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                BucketEntry prev;
                BucketEntry e = (BucketEntry)x;
                int i = IndexCache.indexFor(e.hash, this.bucket.length);
                BucketEntry p = prev = this.bucket[i];
                while (p != null) {
                    BucketEntry next = p.next;
                    if (p == e) {
                        if (prev == e) {
                            this.bucket[i] = next;
                        } else {
                            prev.next = next;
                        }
                        e.next = null;
                        --this.size;
                        break;
                    }
                    prev = p;
                    p = next;
                }
            }
        }
    }

    private static int indexFor(int h, int n) {
        return h & n - 1;
    }

    private void rehash() {
        this.purge();
        int s = this.size << 1;
        BucketEntry[] tmp = new BucketEntry[s];
        for (BucketEntry e : this.bucket) {
            this.bucket[i] = null;
            while (e != null) {
                BucketEntry next = e.next;
                int p = IndexCache.indexFor(e.hash, tmp.length);
                e.next = tmp[p];
                tmp[p] = e;
                e = next;
            }
        }
        this.bucket = tmp;
    }

    private static class BucketEntry
    extends SoftReference<IndexEntry> {
        final int hash;
        BucketEntry next;

        public BucketEntry(int h, BucketEntry n, IndexEntry v, ReferenceQueue<IndexEntry> rq) {
            super(v, rq);
            this.hash = h;
            this.next = n;
        }
    }
}

