/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import org.basex.core.BaseXException;
import org.basex.core.Text;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class QueryException
extends Exception {
    private final QNm name;
    private transient Value value = Empty.SEQ;
    private Err err;
    private String file;
    private StringList suggest;
    private int[] lineCol;
    private int markedCol;

    public QueryException(Throwable th) {
        this(Util.message(th));
        Util.debug(th);
    }

    public QueryException(String msg) {
        this(null, Err.BASX_GENERIC, msg);
    }

    public QueryException(InputInfo ii, Err er, Object ... ext) {
        this(ii, er.qname(), er.desc, ext);
        this.err = er;
    }

    public QueryException(InputInfo ii, QNm errc, String msg, Object ... ext) {
        super(BaseXException.message(msg, ext));
        this.name = errc;
        if (ii != null) {
            this.info(ii);
        }
    }

    public int col() {
        return this.lineCol == null ? 0 : this.lineCol[1];
    }

    public int markedCol() {
        return this.markedCol;
    }

    public int line() {
        return this.lineCol == null ? 0 : this.lineCol[0];
    }

    public String file() {
        return this.file;
    }

    public StringList suggest() {
        return this.suggest == null ? new StringList() : this.suggest;
    }

    public QueryException suggest(InputParser qp, StringList sug) {
        this.suggest = sug;
        this.pos(qp);
        return this;
    }

    public QueryException info(InputInfo ii) {
        this.file = ii.file;
        this.lineCol = ii.lineCol();
        return this;
    }

    public QueryException value(Value v) {
        this.value = v;
        return this;
    }

    void pos(InputParser parser) {
        this.markedCol = parser.im;
        if (this.lineCol != null) {
            return;
        }
        this.file = parser.file;
        this.lineCol = InputInfo.lineCol(parser.input, Math.min(parser.im, parser.il));
    }

    public QNm qname() {
        return this.name;
    }

    public Err err() {
        return this.err;
    }

    public Value value() {
        return this.value;
    }

    @Override
    public String getLocalizedMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        byte[] code;
        TokenBuilder tb = new TokenBuilder();
        if (this.lineCol != null) {
            tb.add(Text.STOPPED_AT).add(32).addExt(Text.LINE_X, this.lineCol[0]);
            if (this.lineCol[1] != 0) {
                tb.add(", ").addExt(Text.COLUMN_X, this.lineCol[1]);
            }
            if (this.file != null) {
                tb.add(32).addExt(Text.IN_FILE_X, this.file);
            }
            tb.add(":").add(Text.NL);
        }
        if ((code = this.name.local()).length != 0) {
            tb.add(91).add(code).add("] ");
        }
        return tb.add(this.getLocalizedMessage()).toString();
    }
}

