/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.CName;
import org.basex.query.expr.Constr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.Err;
import org.basex.query.util.NSContext;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class CElem
extends CName {
    private final Atts nspaces;
    private final boolean comp;

    public CElem(InputInfo ii, Expr t, Atts ns, Expr ... cont) {
        super("element", ii, t, cont);
        this.nspaces = ns == null ? new Atts() : ns;
        this.comp = ns == null;
        this.type = SeqType.ELM;
    }

    @Override
    public CElem compile(QueryContext ctx) throws QueryException {
        int s = this.prepare(ctx);
        super.compile(ctx);
        ctx.sc.ns.size(s);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FElem item(QueryContext ctx, InputInfo ii) throws QueryException {
        int s = this.prepare(ctx);
        try {
            int a;
            Atts ns = new Atts();
            for (int i = 0; i < this.nspaces.size(); ++i) {
                ns.add(this.nspaces.name(i), this.nspaces.string(i));
            }
            QNm nm = this.qname(ctx, ii);
            byte[] cp = nm.prefix();
            byte[] cu = nm.uri();
            if (Token.eq(cp, Token.XML) ^ Token.eq(cu, QueryText.XMLURI)) {
                Err.CEXML.thrw(this.info, cu, cp);
            }
            if (Token.eq(cu, QueryText.XMLNSURI)) {
                Err.CEINV.thrw(this.info, new Object[]{cu});
            }
            if (Token.eq(cp, Token.XMLNS)) {
                Err.CEINV.thrw(this.info, new Object[]{cp});
            }
            if (!Token.eq(cp, Token.XML)) {
                byte[] uri = ctx.sc.ns.uri(cp);
                if (nm.hasURI()) {
                    if (!(this.comp || uri != null && Token.eq(uri, cu))) {
                        ctx.sc.ns.add(cp, cu);
                    }
                    if (!ns.contains(cp)) {
                        ns.add(cp, cu);
                    }
                } else {
                    nm.uri(uri);
                }
            }
            Constr constr = new Constr(ii, ctx).add(this.expr);
            if (constr.errAtt) {
                Err.NOATTALL.thrw(this.info, new Object[0]);
            }
            if (constr.errNS) {
                Err.NONSALL.thrw(this.info, new Object[0]);
            }
            if (constr.duplAtt != null) {
                (this.comp ? Err.CATTDUPL : Err.ATTDUPL).thrw(this.info, new Object[]{constr.duplAtt});
            }
            if (constr.duplNS != null) {
                Err.DUPLNSCONS.thrw(this.info, new Object[]{constr.duplNS});
            }
            FElem node = new FElem(nm, constr.children, constr.atts, ns);
            Atts cns = constr.nspaces;
            for (a = 0; a < cns.size(); ++a) {
                CElem.addNS(cns.name(a), cns.string(a), ns);
            }
            for (a = 0; a < constr.atts.size(); ++a) {
                byte[] auri;
                byte[] npref;
                byte[] apref;
                ANode att = constr.atts.get(a);
                QNm qnm = att.qname();
                if (!qnm.hasPrefix() || !qnm.hasURI() || Token.eq(apref = qnm.prefix(), Token.XML) || (npref = CElem.addNS(apref, auri = qnm.uri(), ns)) == null) continue;
                constr.atts.set(a, new FAttr(new QNm(Token.concat(npref, Token.COLON, qnm.local()), auri), att.string()));
            }
            Atts stack = ctx.sc.ns.stack();
            for (int a2 = stack.size() - 1; a2 >= 0; --a2) {
                byte[] pref = stack.name(a2);
                if (ns.contains(pref)) continue;
                ns.add(pref, stack.string(a2));
            }
            for (int c = 0; c < constr.children.size(); ++c) {
                ANode child = constr.children.get(c);
                if (child.type != NodeType.ELM) continue;
                if (ctx.sc.nsInherit) {
                    CElem.inherit(child, ns);
                }
                if (!ctx.sc.nsPreserve) {
                    CElem.noPreserve(child);
                }
                child.optimize();
            }
            FElem fElem = node.optimize();
            return fElem;
        }
        finally {
            ctx.sc.ns.size(s);
        }
    }

    private static void noPreserve(ANode node) {
        Atts ns = node.namespaces();
        byte[] pref = node.qname().prefix();
        for (int i = ns.size() - 1; i >= 0; --i) {
            boolean f;
            ANode it;
            AxisMoreIter atts = node.attributes();
            for (f = Token.eq(ns.name(i), pref); f && (it = atts.next()) != null; f |= Token.eq(it.qname().prefix(), pref)) {
            }
            if (f) continue;
            ns.delete(i);
        }
    }

    private static void inherit(ANode node, Atts nsp) {
        Atts ns = node.namespaces();
        for (int a = nsp.size() - 1; a >= 0; --a) {
            byte[] pref = nsp.name(a);
            if (ns.contains(pref)) continue;
            ns.add(pref, nsp.string(a));
        }
    }

    private static byte[] addNS(byte[] pref, byte[] uri, Atts ns) {
        byte[] u = ns.string(pref);
        if (u == null) {
            ns.add(pref, uri);
        } else if (!Token.eq(u, uri)) {
            byte[] apref = null;
            for (int c = 0; c < ns.size(); ++c) {
                if (!Token.eq(ns.string(c), uri)) continue;
                apref = ns.name(c);
            }
            if (apref == null) {
                int i = 1;
                while (ns.contains(apref = Token.concat(pref, new byte[]{95}, Token.token(i++)))) {
                }
                ns.add(apref, uri);
            }
            return apref;
        }
        return null;
    }

    private int prepare(QueryContext ctx) {
        NSContext ns = ctx.sc.ns;
        int s = ns.size();
        for (int n = 0; n < this.nspaces.size(); ++n) {
            ns.add(this.nspaces.name(n), this.nspaces.string(n));
        }
        return s;
    }
}

