/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.flwor;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.flwor.OrderBy;
import org.basex.query.util.Var;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class OrderByExpr
extends OrderBy {
    private Expr expr;

    public OrderByExpr(InputInfo ii, Expr e, boolean d, boolean l) {
        super(ii);
        this.expr = e;
        this.desc = d;
        this.lst = l;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    public OrderByExpr compile(QueryContext ctx) throws QueryException {
        this.expr = this.expr.compile(ctx);
        this.type = this.expr.type();
        return this;
    }

    @Override
    Item key(QueryContext ctx, int i) throws QueryException {
        Item it = this.expr.item(ctx, this.info);
        if (it != null) {
            if (it.type.isNode()) {
                it = Str.get(it.string(this.info));
            } else if (it.type.isNumber() && Double.isNaN(it.dbl(this.info))) {
                it = null;
            }
        }
        return it;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.expr.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.expr.count(v);
    }

    @Override
    public boolean removable(Var v) {
        return this.expr.removable(v);
    }

    @Override
    public OrderByExpr remove(Var v) {
        this.expr = this.expr.remove(v);
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        return this.expr.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.DIR, this.desc ? "descending" : "ascending", "empty", this.lst ? "least" : "greatest"), this.expr);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.expr.toString());
        if (this.desc) {
            sb.append(" descending");
        }
        if (!this.lst) {
            sb.append(" empty greatest");
        }
        return sb.toString();
    }
}

