/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.io.IOException;
import org.basex.core.Prop;
import org.basex.core.cmd.Export;
import org.basex.data.Data;
import org.basex.query.QueryException;
import org.basex.query.up.NamePool;
import org.basex.query.up.NodeUpdates;
import org.basex.query.up.primitives.NodeCopy;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.Err;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.NodeType;
import org.basex.util.hash.IntMap;
import org.basex.util.list.IntList;

final class DatabaseUpdates {
    private final Data data;
    private IntList nodes = new IntList(0);
    private final IntMap<NodeUpdates> updatePrimitives = new IntMap();

    DatabaseUpdates(Data d) {
        this.data = d;
    }

    void add(UpdatePrimitive p) throws QueryException {
        int pre = p.pre;
        NodeUpdates pc = this.updatePrimitives.get(pre);
        if (pc == null) {
            pc = new NodeUpdates();
            this.updatePrimitives.add(pre, pc);
        }
        pc.add(p);
    }

    void check() throws QueryException {
        int i;
        int s = this.updatePrimitives.size();
        this.nodes = new IntList(s);
        for (i = 1; i <= this.updatePrimitives.size(); ++i) {
            this.nodes.add(this.updatePrimitives.key(i));
        }
        this.nodes.sort();
        for (i = 0; i < s; ++i) {
            NodeUpdates ups = this.updatePrimitives.get(this.nodes.get(i));
            for (UpdatePrimitive p : ups.prim) {
                if (p instanceof NodeCopy) {
                    ((NodeCopy)p).prepare();
                }
                if (p.type != PrimitiveType.PUT || !this.ancestorDeleted(this.nodes.get(i))) continue;
                Err.UPFOTYPE.thrw(p.info, p);
            }
        }
        int p = this.nodes.size() - 1;
        int par = -1;
        while (p >= 0 && (par != this.nodes.get(p) || --p >= 0)) {
            int pre = this.nodes.get(p);
            if (pre == -1) {
                return;
            }
            int k = this.data.kind(pre);
            if (k == 3) {
                par = this.data.parent(pre, k);
                IntList il = new IntList();
                while (p >= 0 && (pre = this.nodes.get(p)) > par) {
                    il.add(pre);
                    --p;
                }
                if (par != -1) {
                    il.add(par);
                }
                this.checkNames(il.toArray());
                continue;
            }
            if (k == 1) {
                this.checkNames(pre);
            }
            --p;
        }
    }

    void startUpdate() throws QueryException {
        if (!this.data.startUpdate()) {
            Err.BXDB_OPENED.thrw(null, this.data.meta.name);
        }
    }

    void finishUpdate() {
        this.data.finishUpdate();
    }

    Data data() {
        return this.data;
    }

    void apply() throws QueryException {
        this.optimize();
        NodeUpdates recent = null;
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            NodeUpdates current = this.updatePrimitives.get(this.nodes.get(i));
            if (recent == null) {
                current.makePrimitivesEffective();
            } else {
                recent.resolveExternalTextNodeAdjacency(current.makePrimitivesEffective());
            }
            recent = current;
        }
        recent.resolveExternalTextNodeAdjacency(0);
        if (this.data.meta.prop.is(Prop.WRITEBACK) && !this.data.meta.original.isEmpty()) {
            try {
                Export.export(this.data, this.data.meta.original, null);
            }
            catch (IOException ex) {
                Err.UPPUTERR.thrw(null, this.data.meta.original);
            }
        }
    }

    int size() {
        int s = 0;
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            for (UpdatePrimitive up : this.updatePrimitives.get((int)this.nodes.get((int)i)).prim) {
                s += up.size();
            }
        }
        return s;
    }

    private boolean ancestorDeleted(int n) {
        NodeUpdates up = this.updatePrimitives.get(n);
        if (up != null && up.updatesDestroyIdentity(n)) {
            return true;
        }
        int p = this.data.parent(n, this.data.kind(n));
        return p != -1 && this.ancestorDeleted(p);
    }

    private void checkNames(int ... pres) throws QueryException {
        NamePool pool = new NamePool();
        for (int pre : pres) {
            NodeUpdates ups = this.updatePrimitives.get(pre);
            if (ups == null) continue;
            for (UpdatePrimitive up : ups.prim) {
                up.update(pool);
            }
        }
        if (!pool.nsOK()) {
            Err.UPNSCONFL2.thrw(null, new Object[0]);
        }
        IntList il = new IntList();
        for (int pre : pres) {
            if (this.data.kind(pre) == 3) {
                il.add(pre);
                continue;
            }
            int ps = pre + this.data.attSize(pre, 1);
            for (int p = pre + 1; p < ps; ++p) {
                byte[] nm = this.data.name(p, 3);
                if (il.contains(p)) continue;
                QNm name = new QNm(nm);
                byte[] uri = this.data.nspaces.uri(this.data.nspaces.uri(nm, p));
                if (uri != null) {
                    name.uri(uri);
                }
                pool.add(name, NodeType.ATT);
            }
        }
        QNm dup = pool.duplicate();
        if (dup != null) {
            Err.UPATTDUPL.thrw(null, dup);
        }
    }

    private void optimize() {
        int l = this.nodes.size();
        int ni = 0;
        int c = 0;
        while (ni < l - 1) {
            int[] destroyed;
            int pre = this.nodes.get(ni++);
            for (int pd : destroyed = this.updatePrimitives.get(pre).destroyedNodeIdentities().toArray()) {
                int followingAxisPre = pd + this.data.size(pd, this.data.kind(pd));
                while (ni < l && this.nodes.get(ni) < followingAxisPre) {
                    this.nodes.set(ni++, -1);
                    ++c;
                }
            }
        }
        if (c == 0) {
            return;
        }
        IntList newNodes = new IntList(this.nodes.size() - c);
        for (int i = 0; i < this.nodes.size(); ++i) {
            int pre = this.nodes.get(i);
            if (pre == -1) continue;
            newNodes.add(pre);
        }
        this.nodes = newNodes;
    }
}

