/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.flwor.Let;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.up.ContextModifier;
import org.basex.query.up.TransformModifier;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class Transform
extends Arr {
    private final Let[] copies;

    public Transform(InputInfo ii, Let[] c, Expr m, Expr r) {
        super(ii, m, r);
        this.copies = c;
    }

    @Override
    public void checkUp() throws QueryException {
        for (Let c : this.copies) {
            c.checkUp();
        }
        if (!this.expr[0].isVacuous() && !this.expr[0].uses(Expr.Use.UPD)) {
            Err.UPEXPECTT.thrw(this.info, new Object[0]);
        }
        this.checkNoUp(this.expr[1]);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        int s = ctx.vars.size();
        for (Let c : this.copies) {
            c.expr = c.expr.compile(ctx);
            ctx.vars.add(c.var);
        }
        super.compile(ctx);
        ctx.vars.size(s);
        return this;
    }

    @Override
    public ValueIter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext ctx) throws QueryException {
        int s = ctx.vars.size();
        int o = (int)ctx.output.size();
        ContextModifier tmp = ctx.updates.mod;
        TransformModifier pu = new TransformModifier();
        ctx.updates.mod = pu;
        try {
            for (Let fo : this.copies) {
                Iter ir = ctx.iter(fo.expr);
                Item i = ir.next();
                if (i == null || !i.type.isNode() || ir.next() != null) {
                    Err.UPCOPYMULT.thrw(this.info, new Object[0]);
                }
                MemData md = new MemData(ctx.context.prop);
                new DataBuilder(md).build((ANode)i);
                ctx.vars.add(fo.var.bind(new DBNode(md), ctx).copy());
                pu.addData(md);
            }
            ctx.value(this.expr[0]);
            ctx.updates.apply();
            Value value = ctx.value(this.expr[1]);
            return value;
        }
        finally {
            ctx.vars.size(s);
            ctx.output.size(o);
            ctx.updates.mod = tmp;
        }
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || u != Expr.Use.UPD && super.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = 0;
        for (Let l : this.copies) {
            c += l.count(v);
        }
        return c + super.count(v);
    }

    @Override
    public boolean removable(Var v) {
        for (Let c : this.copies) {
            if (c.removable(v)) continue;
            return false;
        }
        return super.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        for (Let c : this.copies) {
            c.remove(v);
        }
        return super.remove(v);
    }

    @Override
    public boolean databases(StringList db) {
        for (Let c : this.copies) {
            if (c.databases(db)) continue;
            return false;
        }
        return super.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.copies, this.expr});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("copy ");
        for (Let t : this.copies) {
            sb.append(t.var + " " + ":=" + ' ' + t.expr + ' ');
        }
        return sb.append("modify " + this.expr[0] + ' ' + "return" + ' ' + this.expr[1]).toString();
    }
}

