/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.core.Context;
import org.basex.data.FTPosData;
import org.basex.data.MemData;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.ANodeList;
import org.basex.query.util.DataFTBuilder;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class DataBuilder {
    private final MemData data;
    private DataFTBuilder ftbuilder;
    private int marker;

    public DataBuilder(MemData md) {
        this.data = md;
    }

    public DataBuilder ftpos(byte[] tag, FTPosData pos, int len) {
        this.ftbuilder = new DataFTBuilder(pos, len);
        this.marker = this.data.tagindex.index(tag, null, false);
        return this;
    }

    public void build(ANode n) {
        this.build(new ANodeList(n));
    }

    public void build(ANodeList nl) {
        int pre = 1;
        int ns = nl.size();
        for (int n = 0; n < ns; ++n) {
            pre = this.addNode(nl.get(n), pre, 0, null);
        }
    }

    private int addNode(ANode nd, int pre, int par, ANode ndPar) {
        switch (nd.nodeType()) {
            case DOC: {
                return this.addDoc(nd, pre);
            }
            case ELM: {
                return this.addElem(nd, pre, par);
            }
            case TXT: {
                return pre + this.addText(nd, pre, par, ndPar);
            }
            case ATT: {
                return pre + this.addAttr(nd, pre, par);
            }
            case COM: {
                return pre + this.addComm(nd, pre, par);
            }
        }
        return pre + this.addPI(nd, pre, par);
    }

    private int addDoc(ANode nd, int pre) {
        ANode ch;
        int ms = this.data.meta.size;
        this.data.doc(ms, DataBuilder.size(nd, false), nd.baseURI());
        this.data.insert(ms);
        int p = pre + 1;
        AxisMoreIter ai = nd.children();
        while ((ch = ai.next()) != null) {
            p = this.addNode(ch, p, pre, null);
        }
        return p;
    }

    private int addAttr(ANode nd, int pre, int par) {
        boolean ne;
        int ms = this.data.meta.size;
        QNm q = nd.qname();
        byte[] uri = q.uri();
        int u = 0;
        boolean bl = ne = uri.length != 0;
        if (ne) {
            if (par == 0) {
                this.data.nspaces.add(ms, pre - par, q.prefix(), uri);
            }
            u = this.data.nspaces.addURI(uri);
        }
        int n = this.data.atnindex.index(q.string(), null, false);
        this.data.attr(ms, pre - par, n, nd.string(), u, ne);
        this.data.insert(ms);
        return 1;
    }

    private int addText(ANode nd, int pre, int par, ANode ndPar) {
        TokenList tl;
        int dist = pre - par;
        TokenList tokenList = tl = this.ftbuilder != null ? this.ftbuilder.build(nd) : null;
        if (tl == null) {
            return this.addText(nd.string(), dist);
        }
        int u = ndPar != null ? this.data.nspaces.uri(ndPar.name(), true) : 0;
        for (int i = 0; i < tl.size(); ++i) {
            boolean elem;
            byte[] text = tl.get(i);
            boolean bl = elem = text == null;
            if (elem) {
                this.data.elem(dist + i, this.marker, 1, 2, u, false);
                this.data.insert(this.data.meta.size);
                text = tl.get(++i);
            }
            this.addText(text, elem ? 1 : dist + i);
        }
        return tl.size();
    }

    private int addText(byte[] txt, int dist) {
        int ms = this.data.meta.size;
        this.data.text(ms, dist, txt, 2);
        this.data.insert(ms);
        return 1;
    }

    private int addPI(ANode nd, int pre, int par) {
        int ms = this.data.meta.size;
        byte[] v = Token.trim(Token.concat(nd.name(), Token.SPACE, nd.string()));
        this.data.text(ms, pre - par, v, 5);
        this.data.insert(ms);
        return 1;
    }

    private int addComm(ANode nd, int pre, int par) {
        int ms = this.data.meta.size;
        this.data.text(ms, pre - par, nd.string(), 4);
        this.data.insert(ms);
        return 1;
    }

    private int addElem(ANode nd, int pre, int par) {
        ANode ch;
        int ms = this.data.meta.size;
        this.data.nspaces.open();
        Atts ns = nd.nsScope();
        boolean ne = ns.size() > 0;
        int as = ns.size();
        for (int a = 0; a < as; ++a) {
            this.data.nspaces.add(ns.name(a), ns.string(a), ms);
        }
        QNm q = nd.qname();
        byte[] uri = q.uri();
        int u = uri.length != 0 ? this.data.nspaces.addURI(uri) : 0;
        int tn = this.data.tagindex.index(q.string(), null, false);
        int s = DataBuilder.size(nd, false);
        this.data.elem(pre - par, tn, DataBuilder.size(nd, true), s, u, ne);
        this.data.insert(ms);
        int p = pre + 1;
        AxisMoreIter ai = nd.attributes();
        while ((ch = ai.next()) != null) {
            p = this.addNode(ch, p, pre, nd);
        }
        ai = nd.children();
        while ((ch = ai.next()) != null) {
            p = this.addNode(ch, p, pre, nd);
        }
        this.data.nspaces.close(ms);
        if (s != p - pre) {
            this.data.size(ms, 1, p - pre);
        }
        return p;
    }

    private static int size(ANode n, boolean a) {
        if (n instanceof DBNode) {
            DBNode dbn = (DBNode)n;
            int k = n.kind();
            return a ? dbn.data.attSize(dbn.pre, k) : dbn.data.size(dbn.pre, k);
        }
        int s = 1;
        AxisMoreIter ai = n.attributes();
        while (ai.next() != null) {
            ++s;
        }
        if (!a) {
            ANode i;
            ai = n.children();
            while ((i = ai.next()) != null) {
                s += DataBuilder.size(i, a);
            }
        }
        return s;
    }

    public static ANode stripNS(ANode node, byte[] ns, Context ctx) {
        if (node.type != NodeType.ELM) {
            return node;
        }
        MemData md = new MemData(ctx.prop);
        DataBuilder db = new DataBuilder(md);
        db.build(node);
        boolean del = true;
        for (int pre = 0; pre < md.meta.size; ++pre) {
            byte[] uri;
            int kind = md.kind(pre);
            if (kind != 1 && kind != 3 || (uri = md.nspaces.uri(md.uri(pre, kind))) == null || !Token.eq(uri, ns)) continue;
            byte[] name = md.name(pre, kind);
            if (Token.prefix(name).length == 0) {
                if (kind != 1) continue;
                md.update(pre, kind, name, Token.EMPTY);
                md.nsFlag(pre, false);
                continue;
            }
            del = false;
        }
        if (del) {
            md.nspaces.delete(ns);
        }
        return new DBNode(md);
    }
}

