/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import java.util.HashMap;
import java.util.Locale;
import javax.xml.datatype.XMLGregorianCalendar;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.format.DateParser;
import org.basex.query.util.format.FormatParser;
import org.basex.query.util.format.FormatUtil;
import org.basex.query.util.format.FormatterEN;
import org.basex.query.value.item.ADate;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public abstract class Formatter
extends FormatUtil {
    private static final String EN = "en";
    private static final HashMap<String, Formatter> MAP = new HashMap();

    public static Formatter get(String ln) {
        String clz;
        Formatter form = MAP.get(ln);
        if (form == null && (form = (Formatter)Reflect.get(Reflect.find(clz = Util.name(Formatter.class) + ln.toUpperCase(Locale.ENGLISH)))) == null) {
            form = MAP.get(EN);
        }
        return form;
    }

    protected abstract byte[] word(long var1, byte[] var3);

    protected abstract byte[] ordinal(long var1, byte[] var3);

    protected abstract byte[] month(int var1, int var2, int var3);

    protected abstract byte[] day(int var1, int var2, int var3);

    protected abstract byte[] ampm(boolean var1);

    protected abstract byte[] calendar();

    protected abstract byte[] era(int var1);

    public final byte[] formatDate(ADate date, byte[] pic, byte[] cal, byte[] plc, InputInfo ii) throws QueryException {
        if (cal != null || plc != null) {
            // empty if block
        }
        TokenBuilder tb = new TokenBuilder();
        DateParser dp = new DateParser(ii, pic);
        while (dp.more()) {
            int ch = dp.next();
            if (ch != 0) {
                tb.add(ch);
                continue;
            }
            byte[] p = dp.marker();
            if (p.length == 0) {
                Err.PICDATE.thrw(ii, new Object[]{pic});
            }
            int spec = Formatter.ch(p, 0);
            p = Token.substring(p, Token.cl(p, 0));
            byte[] pres = Token.ONE;
            boolean max = false;
            long num = 0L;
            boolean dat = date.type == AtomType.DAT;
            boolean tim = date.type == AtomType.TIM;
            XMLGregorianCalendar gc = date.xc;
            boolean err = false;
            switch (spec) {
                case 89: {
                    num = Math.abs(gc.getYear());
                    max = true;
                    err = tim;
                    break;
                }
                case 77: {
                    num = gc.getMonth();
                    err = tim;
                    break;
                }
                case 68: {
                    num = gc.getDay();
                    err = tim;
                    break;
                }
                case 100: {
                    num = ADate.days(0, gc.getMonth(), gc.getDay());
                    err = tim;
                    break;
                }
                case 70: {
                    num = gc.toGregorianCalendar().get(7) - 1;
                    pres = new byte[]{110};
                    err = tim;
                    break;
                }
                case 87: {
                    num = gc.toGregorianCalendar().get(3);
                    err = tim;
                    break;
                }
                case 119: {
                    num = gc.toGregorianCalendar().get(4);
                    err = tim;
                    break;
                }
                case 72: {
                    num = gc.getHour();
                    err = dat;
                    break;
                }
                case 104: {
                    num = gc.getHour() % 12;
                    if (num == 0L) {
                        num = 12L;
                    }
                    err = dat;
                    break;
                }
                case 80: {
                    num = gc.getHour() / 12;
                    pres = new byte[]{110};
                    err = dat;
                    break;
                }
                case 109: {
                    num = gc.getMinute();
                    pres = Token.token("01");
                    err = dat;
                    break;
                }
                case 115: {
                    num = gc.getSecond();
                    pres = Token.token("01");
                    err = dat;
                    break;
                }
                case 102: {
                    num = gc.getMillisecond();
                    err = dat;
                    break;
                }
                case 90: 
                case 122: {
                    num = gc.getTimezone();
                    pres = Token.token("01:01");
                    break;
                }
                case 67: {
                    pres = new byte[]{110};
                    break;
                }
                case 69: {
                    num = gc.getYear();
                    pres = new byte[]{110};
                    break;
                }
                default: {
                    err = true;
                }
            }
            if (err) {
                Err.PICCOMP.thrw(ii, new Object[]{pic});
            }
            FormatParser fp = new FormatParser(p, pres, ii);
            if (max) {
                int mx = 0;
                for (int s = 0; s < fp.primary.length; s += Token.cl(fp.primary, s)) {
                    ++mx;
                }
                if (mx > 1) {
                    fp.max = mx;
                }
            }
            if (fp.digit == 110) {
                byte[] in = Token.EMPTY;
                if (spec == 77) {
                    in = this.month((int)num - 1, fp.min, fp.max);
                } else if (spec == 70) {
                    in = this.day((int)num, fp.min, fp.max);
                } else if (spec == 80) {
                    in = this.ampm(num == 0L);
                } else if (spec == 67) {
                    in = this.calendar();
                } else if (spec == 69) {
                    in = this.era((int)num);
                }
                if (fp.cs == FormatUtil.Case.LOWER) {
                    in = Token.lc(in);
                }
                if (fp.cs == FormatUtil.Case.UPPER) {
                    in = Token.uc(in);
                }
                tb.add(in);
                continue;
            }
            tb.add(this.formatInt(num, fp));
        }
        return tb.finish();
    }

    public final byte[] formatInt(long num, FormatParser fp) {
        boolean single;
        boolean sign;
        long n = num;
        boolean bl = sign = n < 0L;
        if (sign) {
            n = -n;
        }
        TokenBuilder tb = new TokenBuilder();
        int ch = fp.digit;
        boolean bl2 = single = fp.primary.length == Token.cl(fp.primary, 0);
        if (ch == 119) {
            tb.add(this.word(n, fp.ordinal));
        } else if (ch == KANJI[1]) {
            Formatter.japanese(tb, n);
        } else if (single && ch == 105) {
            Formatter.roman(tb, n);
        } else if (ch >= 9312 && ch <= 9371) {
            if (num < 1L || num > 20L) {
                tb.addLong(num);
            } else {
                tb.add((int)((long)ch + num - 1L));
            }
        } else {
            String seq = Formatter.sequence(ch);
            if (seq != null) {
                Formatter.alpha(tb, num, seq);
            } else {
                tb.add(this.number(n, fp, Formatter.zeroes(ch)));
            }
        }
        byte[] in = tb.finish();
        if (fp.cs == FormatUtil.Case.LOWER) {
            in = Token.lc(in);
        }
        if (fp.cs == FormatUtil.Case.UPPER) {
            in = Token.uc(in);
        }
        return sign ? Token.concat(new byte[]{45}, in) : in;
    }

    private static void alpha(TokenBuilder tb, long n, String a) {
        int al = a.length();
        if (n > (long)al) {
            Formatter.alpha(tb, (n - 1L) / (long)al, a);
        }
        if (n > 0L) {
            tb.add(a.charAt((int)((n - 1L) % (long)al)));
        } else {
            tb.add(Token.ZERO);
        }
    }

    private static void roman(TokenBuilder tb, long n) {
        if (n > 0L && n < 4000L) {
            int v = (int)n;
            tb.add(ROMANM[v / 1000]);
            tb.add(ROMANC[v / 100 % 10]);
            tb.add(ROMANX[v / 10 % 10]);
            tb.add(ROMANI[v % 10]);
        } else {
            tb.addLong(n);
        }
    }

    private static void japanese(TokenBuilder tb, long n) {
        if (n == 0L) {
            tb.add(KANJI[0]);
        } else {
            Formatter.jp(tb, n, false);
        }
    }

    private static void jp(TokenBuilder tb, long n, boolean i) {
        if (n != 0L) {
            if (n <= 9L) {
                if (n != 1L || !i) {
                    tb.add(KANJI[(int)n]);
                }
            } else if (n == 10L) {
                tb.add(KANJI[10]);
            } else if (n <= 99L) {
                Formatter.jp(tb, n, 10L, 10);
            } else if (n <= 999L) {
                Formatter.jp(tb, n, 100L, 11);
            } else if (n <= 9999L) {
                Formatter.jp(tb, n, 1000L, 12);
            } else if (n <= 99999999L) {
                Formatter.jp(tb, n, 10000L, 13);
            } else if (n <= 999999999999L) {
                Formatter.jp(tb, n, 100000000L, 14);
            } else if (n <= 9999999999999999L) {
                Formatter.jp(tb, n, 1000000000000L, 15);
            } else {
                tb.addLong(n);
            }
        }
    }

    private static void jp(TokenBuilder tb, long n, long f, int o) {
        Formatter.jp(tb, n / f, true);
        tb.add(KANJI[o]);
        Formatter.jp(tb, n % f, false);
    }

    private byte[] number(long num, FormatParser fp, int z) {
        int c;
        int rc;
        IntList pr = new IntList(fp.primary.length);
        for (int p = 0; p < fp.primary.length; p += Token.cl(fp.primary, p)) {
            pr.add(Token.cp(fp.primary, p));
        }
        int rp = -1;
        boolean reg = false;
        for (int p = pr.size() - 1; p >= 0; --p) {
            int ch = pr.get(p);
            if (ch == 35 || ch >= z && ch <= z + 9) continue;
            if (rp == -1) {
                rp = pr.size() - p;
            }
            reg = (pr.size() - p) % rp == 0;
        }
        int n = rc = reg ? pr.get(pr.size() - rp) : 0;
        if (!reg) {
            rp = Integer.MAX_VALUE;
        }
        IntList cache = new IntList();
        byte[] n2 = Token.token(num);
        int b = n2.length - 1;
        int p = pr.size() - 1;
        int mn = fp.min;
        int mx = fp.max;
        while ((--mn >= 0 || b >= 0 || p >= 0) && --mx >= 0) {
            boolean sep;
            boolean bl = sep = cache.size() % rp == rp - 1;
            if (p >= 0) {
                c = pr.get(p--);
                if (b >= 0) {
                    if (c == 35 && sep) {
                        cache.add(rc);
                    }
                    cache.add(c == 35 || c >= z && c <= z + 9 ? n2[b--] - 48 + z : c);
                    continue;
                }
                if (c == 35) break;
                cache.add(c >= z && c <= z + 9 ? z : c);
                continue;
            }
            if (b >= 0) {
                if (sep) {
                    cache.add(rc);
                }
                cache.add(n2[b--] - 48 + z);
                continue;
            }
            cache.add(z);
        }
        TokenBuilder tb = new TokenBuilder();
        for (c = cache.size() - 1; c >= 0; --c) {
            tb.add(cache.get(c));
        }
        return tb.add(this.ordinal(num, fp.ordinal)).finish();
    }

    static {
        MAP.put(EN, new FormatterEN());
    }
}

