/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Num;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Dbl
extends Num {
    public static final Dbl NAN = new Dbl(Double.NaN);
    private static final Dbl ZERO = new Dbl(0.0);
    private static final Dbl ONE = new Dbl(1.0);
    private final double val;

    private Dbl(double v) {
        super(AtomType.DBL);
        this.val = v;
    }

    public static Dbl get(double d) {
        return d == 0.0 && d == Double.POSITIVE_INFINITY ? ZERO : (d == 1.0 ? ONE : (Double.isNaN(d) ? NAN : new Dbl(d)));
    }

    public static Dbl get(byte[] v, InputInfo ii) throws QueryException {
        return Dbl.get(Dbl.parse(v, ii));
    }

    @Override
    public byte[] string(InputInfo ii) {
        return Token.token(this.val);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return !Double.isNaN(this.val) && this.val != 0.0;
    }

    @Override
    public long itr(InputInfo ii) {
        return (long)this.val;
    }

    @Override
    public float flt(InputInfo ii) {
        return (float)this.val;
    }

    @Override
    public double dbl(InputInfo ii) {
        return this.val;
    }

    @Override
    public BigDecimal dec(InputInfo ii) throws QueryException {
        return Dec.parse(this.val, ii);
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return this.val == it.dbl(ii);
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        double n = it.dbl(ii);
        if (Double.isNaN(n) || Double.isNaN(this.val)) {
            return Integer.MIN_VALUE;
        }
        return this.val < n ? -1 : (this.val > n ? 1 : 0);
    }

    @Override
    public Double toJava() {
        return this.val;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof Dbl && this.val == ((Dbl)cmp).val || this == NAN && cmp == NAN;
    }

    public static double parse(byte[] val, InputInfo ii) throws QueryException {
        try {
            return Double.parseDouble(Token.string(val));
        }
        catch (NumberFormatException ex) {
            if (Token.eq(Token.trim(val), Token.INF)) {
                return Double.POSITIVE_INFINITY;
            }
            if (Token.eq(Token.trim(val), Token.NINF)) {
                return Double.NEGATIVE_INFINITY;
            }
            throw ZERO.castErr(val, ii);
        }
    }
}

