/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import nu.xom.TextWriter;

class GenericWriter
extends TextWriter {
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream(32);
    private final OutputStreamWriter wout;
    private final boolean isJapanese;

    GenericWriter(Writer writer, String string) throws UnsupportedEncodingException {
        super(writer, string);
        this.wout = new OutputStreamWriter((OutputStream)this.bout, string);
        string = string.toUpperCase(Locale.ENGLISH);
        this.isJapanese = string.indexOf("EUC-JP") > -1 || string.startsWith("EUC_JP") || string.equals("SHIFT_JIS") || string.equals("SJIS") || string.equals("ISO-2022-JP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needsEscaping(char c) {
        if (c <= '\u007f') {
            return false;
        }
        if (this.isJapanese) {
            if (c == '\u00a5') {
                return true;
            }
            if (c == '\u203e') {
                return true;
            }
        }
        boolean bl = false;
        try {
            this.wout.write(c);
            this.wout.flush();
            byte[] byArray = this.bout.toByteArray();
            if (byArray.length == 0) {
                bl = true;
            } else if (byArray[0] == 63) {
                bl = true;
            } else if (this.isJapanese && byArray[0] == 33) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            boolean bl2 = true;
            return bl2;
        }
        catch (Error error) {
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.bout.reset();
        }
        return bl;
    }
}

