/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindocument.CmdiTransformer;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.kindocument.KinXsdException;
import nl.mpi.kinnate.projects.ProjectRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EntityDocument {
    final File entityFile;
    final ProjectRecord projectRecord;
    Document metadataDom = null;
    Node kinnateNode = null;
    Element metadataNode = null;
    Node currentDomNode = null;
    public EntityData entityData = null;
    private ImportTranslator importTranslator;
    public static String defaultDragType = "clarin.eu:cr1:p_1320657629627";
    public static String defaultGedcomType = "clarin.eu:cr1:p_1332345811039";
    private final SessionStorage sessionStorage;

    public EntityDocument(ImportTranslator importTranslator, SessionStorage sessionStorage, ProjectRecord projectRecord) {
        this.importTranslator = importTranslator;
        this.sessionStorage = sessionStorage;
        this.projectRecord = projectRecord;
        this.entityFile = this.assignIdentiferAndFile();
    }

    public EntityDocument(String profileId, ImportTranslator importTranslator, SessionStorage sessionStorage, ProjectRecord projectRecord) throws ImportException {
        this.importTranslator = importTranslator;
        this.sessionStorage = sessionStorage;
        this.projectRecord = projectRecord;
        this.entityFile = this.assignIdentiferAndFile();
        try {
            System.out.println("constructing the xsl file");
            long start1Time = System.currentTimeMillis();
            URI xsdUri = new CmdiTransformer(sessionStorage).getXsd(profileId, false);
            long query1Mils = System.currentTimeMillis() - start1Time;
            System.out.println("Constructing the xsl file took: " + query1Mils + "ms");
            System.out.println("Creating the component file");
            long startTime = System.currentTimeMillis();
            URI addedNodeUri = new ArbilComponentBuilder().createComponentFile(this.entityFile.toURI(), xsdUri, false);
            this.relativiseSchemaLocation(addedNodeUri);
            long queryMils = System.currentTimeMillis() - startTime;
            String queryTimeString = "ArbilComponentBuilder().createComponentFile took: " + queryMils + "ms for " + addedNodeUri.toString();
            System.out.println(queryTimeString);
        }
        catch (KinXsdException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException(exception.getMessage());
        }
        this.setDomNodesFromExistingFile();
    }

    public EntityDocument(EntityDocument entityDocumentToCopy, ImportTranslator importTranslator, SessionStorage sessionStorage, ProjectRecord projectRecord) throws ImportException {
        this.importTranslator = importTranslator;
        this.sessionStorage = sessionStorage;
        this.projectRecord = projectRecord;
        this.entityFile = this.assignIdentiferAndFile();
        try {
            this.metadataDom = ArbilComponentBuilder.getDocument((URI)entityDocumentToCopy.entityFile.toURI());
            ArbilComponentBuilder.savePrettyFormatting((Document)this.metadataDom, (File)this.entityFile);
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (ParserConfigurationException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (SAXException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        this.setDomNodesFromExistingFile();
    }

    public EntityDocument(UniqueIdentifier uniqueIdentifier, String profileId, ImportTranslator importTranslator, SessionStorage sessionStorage, ProjectRecord projectRecord) throws ImportException {
        this.importTranslator = importTranslator;
        this.sessionStorage = sessionStorage;
        this.projectRecord = projectRecord;
        this.entityData = new EntityData(uniqueIdentifier);
        this.entityFile = uniqueIdentifier.getFileInProject(projectRecord);
        File subDirectory = this.entityFile.getParentFile();
        subDirectory.mkdir();
        try {
            URI xsdUri = new CmdiTransformer(sessionStorage).getXsd(profileId, false);
            URI addedNodeUri = new ArbilComponentBuilder().createComponentFile(this.entityFile.toURI(), xsdUri, false);
            this.relativiseSchemaLocation(addedNodeUri);
        }
        catch (KinXsdException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        this.setDomNodesFromExistingFile();
    }

    public EntityDocument(URI entityUri, ImportTranslator importTranslator, SessionStorage sessionStorage, ProjectRecord projectRecord) throws ImportException {
        this.importTranslator = importTranslator;
        this.sessionStorage = sessionStorage;
        this.projectRecord = projectRecord;
        this.entityFile = new File(entityUri);
        this.setDomNodesFromExistingFile();
    }

    private void relativiseSchemaLocation(URI entityUri) {
        File originalFile = new File(entityUri);
        File outputFile = new File(originalFile.getParent(), originalFile.getName() + ".tmp");
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(originalFile));
            PrintWriter writer = new PrintWriter(new FileWriter(outputFile));
            String regexString = "xsi:schemaLocation=\"http://www.clarin.eu/cmd/[\\s]+?[\\S]+?/KmdiProfiles/";
            while ((line = reader.readLine()) != null) {
                writer.println(line.replaceFirst(regexString, "xsi:schemaLocation=\"http://www.clarin.eu/cmd/ ../../KmdiProfiles/"));
            }
            reader.close();
            writer.close();
            originalFile.delete();
            outputFile.renameTo(originalFile);
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
    }

    private File assignIdentiferAndFile() {
        this.entityData = new EntityData(new UniqueIdentifier(UniqueIdentifier.IdentifierType.lid));
        File fileInProject = this.entityData.getUniqueIdentifier().getFileInProject(this.projectRecord);
        File subDirectory = fileInProject.getParentFile();
        subDirectory.mkdir();
        return fileInProject;
    }

    private void setDomNodesFromExistingFile() throws ImportException {
        try {
            this.metadataDom = ArbilComponentBuilder.getDocument((URI)this.entityFile.toURI());
            this.kinnateNode = this.metadataDom.getDocumentElement();
            NodeList metadataNodeList = ((Element)this.kinnateNode).getElementsByTagName("CustomData");
            if (metadataNodeList.getLength() < 1) {
                throw new ImportException("Data node not found");
            }
            this.metadataNode = (Element)metadataNodeList.item(0);
            NodeList entityNodeList = ((Element)this.kinnateNode).getElementsByTagNameNS("*", "Entity");
            for (int entityCounter = 0; entityCounter < entityNodeList.getLength(); ++entityCounter) {
                if (this.entityData == null) {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EntityData.class});
                    Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                    this.entityData = (EntityData)unmarshaller.unmarshal(entityNodeList.item(entityCounter), EntityData.class).getValue();
                }
                this.kinnateNode.removeChild(entityNodeList.item(entityCounter));
            }
            this.currentDomNode = this.metadataNode;
            if (this.entityData == null) {
                throw new ImportException("Entity node not found");
            }
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (ParserConfigurationException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (SAXException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
    }

    public String getFileName() {
        return this.entityFile.getName();
    }

    public UniqueIdentifier getUniqueIdentifier() {
        return this.entityData.getUniqueIdentifier();
    }

    public void removeValue(String nodeName, String valueString) throws ImportException {
        NodeList nodeList = this.metadataNode.getElementsByTagName(nodeName);
        for (int nodeCounter = 0; nodeCounter < nodeList.getLength(); ++nodeCounter) {
            Node currentNode = nodeList.item(nodeCounter);
            if (!currentNode.getTextContent().equals(valueString)) continue;
            this.metadataNode.removeChild(currentNode);
            return;
        }
        Element currentNode = this.metadataNode;
        String consumableString = nodeName;
        while (consumableString.length() > 0 && currentNode != null) {
            String pathPart;
            int separatorIndex = consumableString.indexOf(".");
            if (separatorIndex >= 0) {
                pathPart = consumableString.substring(0, separatorIndex);
                consumableString = consumableString.substring(separatorIndex + 1);
            } else {
                pathPart = consumableString;
                consumableString = "";
            }
            int nodeIndex = 0;
            int numberStartIndex = pathPart.indexOf("(");
            if (numberStartIndex >= 0) {
                String intergerPart = pathPart.substring(numberStartIndex + 1, pathPart.length() - 1);
                pathPart = pathPart.substring(0, numberStartIndex);
                nodeIndex = Integer.decode(intergerPart);
            }
            NodeList subNodeList = currentNode.getElementsByTagName(pathPart);
            if (consumableString.length() > 0) {
                currentNode = (Element)subNodeList.item(nodeIndex);
                continue;
            }
            for (int nodeCounter = 0; nodeCounter < subNodeList.getLength(); ++nodeCounter) {
                Node targetNode = subNodeList.item(nodeCounter);
                if (!targetNode.getTextContent().equals(valueString)) continue;
                currentNode.removeChild(targetNode);
                return;
            }
        }
        throw new ImportException("Cannot find value to remove: " + nodeName + " = " + valueString);
    }

    public void insertValue(String nodeName, String valueString) throws ImportException {
        ImportTranslator.TranslationElement translationElement = this.importTranslator.translate(nodeName, valueString);
        System.out.println("insertValue: " + translationElement.fieldName + " : " + translationElement.fieldValue);
        for (Node currentNode = this.metadataNode.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (!translationElement.fieldName.equals(currentNode.getLocalName())) continue;
            if (currentNode.getTextContent() == null || currentNode.getTextContent().length() == 0) {
                currentNode.setTextContent(translationElement.fieldValue);
                return;
            }
            if (!currentNode.getTextContent().equals(translationElement.fieldValue)) continue;
            return;
        }
        try {
            Element valueElement = this.metadataDom.createElementNS("http://www.clarin.eu/cmd/", translationElement.fieldName);
            valueElement.setTextContent(translationElement.fieldValue);
            this.metadataNode.appendChild(valueElement);
        }
        catch (DOMException exception) {
            throw new ImportException("Cannot create node: " + exception.getMessage());
        }
    }

    private void importNode(Node foreignNode) {
        Node importedNode = this.metadataDom.importNode(foreignNode, true);
        while (importedNode.hasChildNodes()) {
            Node currentChild = importedNode.getFirstChild();
            this.currentDomNode.appendChild(currentChild);
        }
    }

    public Node insertNode(String nodeName, String valueString) {
        ImportTranslator.TranslationElement translationElement = this.importTranslator.translate(nodeName, valueString);
        System.out.println("nodeName: " + translationElement.fieldName + " : " + translationElement.fieldValue);
        if (!valueString.isEmpty()) {
            for (Node currentNode = this.currentDomNode.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
                if (!translationElement.fieldName.equals(currentNode.getLocalName())) continue;
                if (currentNode.getTextContent() == null || currentNode.getTextContent().length() == 0) {
                    currentNode.setTextContent(translationElement.fieldValue);
                    return currentNode;
                }
                if (!currentNode.getTextContent().equals(translationElement.fieldValue)) continue;
                return currentNode;
            }
        }
        Element valueElement = this.metadataDom.createElementNS("http://www.clarin.eu/cmd/", translationElement.fieldName);
        valueElement.setTextContent(translationElement.fieldValue);
        this.currentDomNode.appendChild(valueElement);
        return valueElement;
    }

    public void assendToLevel(int nodeLevel) throws ImportException {
        if (nodeLevel < 1) {
            BugCatcherManager.getBugCatcher().logError((Exception)new ImportException("Cannot insert elements outside the CustomData section."));
            throw new ImportException("Cannot insert elements outside the CustomData section.");
        }
        int levelCount = 0;
        for (Node counterNode = this.currentDomNode; counterNode != null; counterNode = counterNode.getParentNode()) {
            ++levelCount;
        }
        levelCount -= 2;
        while (levelCount > nodeLevel) {
            --levelCount;
            this.currentDomNode = this.currentDomNode.getParentNode();
        }
    }

    public void appendValueToLast(String defaultNode, String valueString) throws ImportException {
        System.out.println("appendValueToLast: " + valueString);
        if (this.currentDomNode.equals(this.metadataNode)) {
            this.appendValue(defaultNode, valueString, 1);
        } else {
            this.currentDomNode.setTextContent(this.currentDomNode.getTextContent() + valueString);
        }
    }

    public void appendValue(String nodeName, String valueString, int targetLevel) throws ImportException {
        String currentValue;
        System.out.println("appendValue: " + nodeName + " : " + valueString + " : " + targetLevel);
        this.assendToLevel(targetLevel);
        NodeList childNodes = this.currentDomNode.getChildNodes();
        if (childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && (currentValue = this.currentDomNode.getTextContent()) != null && currentValue.trim().length() > 0) {
            Element spacerElement = this.metadataDom.createElementNS("http://www.clarin.eu/cmd/", this.currentDomNode.getLocalName());
            Node parentNode = this.currentDomNode.getParentNode();
            parentNode.removeChild(this.currentDomNode);
            spacerElement.appendChild(this.currentDomNode);
            parentNode.appendChild(spacerElement);
            this.currentDomNode = spacerElement;
        }
        this.currentDomNode = this.insertNode(nodeName, valueString);
    }

    public File getFile() {
        return this.entityFile;
    }

    public String getFilePath() {
        return this.entityFile.getAbsolutePath();
    }

    public int getAddedFieldCount() {
        return this.metadataNode.getChildNodes().getLength();
    }

    public void saveDocument() throws ImportException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EntityData.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)this.entityData, this.kinnateNode);
        }
        catch (JAXBException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
            throw new ImportException("Error: " + exception.getMessage());
        }
        this.kinnateNode.appendChild(this.metadataNode);
        ArbilComponentBuilder.savePrettyFormatting((Document)this.metadataDom, (File)this.entityFile);
        System.out.println("saved: " + this.entityFile.toURI().toString());
    }
}

