/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.kindocument.ProfileManager;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.FieldSelectionList;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.TableCellDragHandler;
import nl.mpi.kinnate.ui.entityprofiles.CmdiProfileSelectionPanel;
import nl.mpi.kinnate.ui.kintypeeditor.KinTypeDefinitions;
import nl.mpi.kinnate.ui.relationsettings.RelationSettingsPanel;

public class DiagramSettingsPanel
extends JPanel {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Widgets");

    public DiagramSettingsPanel(KinDiagramPanel kinDiagramPanel, EntityCollection entityCollection, SessionStorage sessionStorage, GraphPanel graphPanel, ArbilWindowManager dialogHandler, TableCellDragHandler tableCellDragHandler) {
        super(new BorderLayout());
        this.setName(widgets.getString("DiagramSettingsPanel_DIAGRAM SETTINGS"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        ProfileManager profileManager = new ProfileManager(sessionStorage, (MessageDialogHandler)dialogHandler);
        CmdiProfileSelectionPanel cmdiProfileSelectionPanel = new CmdiProfileSelectionPanel(widgets.getString("DiagramSettingsPanel_ENTITY PROFILES"), profileManager, graphPanel);
        profileManager.loadProfiles(false, cmdiProfileSelectionPanel, graphPanel);
        graphPanel.getIndexParameters().symbolFieldsFields.setParent(graphPanel.getIndexParameters());
        graphPanel.getIndexParameters().labelFields.setParent(graphPanel.getIndexParameters());
        jTabbedPane.addTab(widgets.getString("DiagramSettingsPanel_KIN TYPE DEFINITIONS"), new KinTypeDefinitions(widgets.getString("DiagramSettingsPanel_KIN TYPE DEFINITIONS"), kinDiagramPanel, graphPanel.dataStoreSvg));
        jTabbedPane.addTab(widgets.getString("DiagramSettingsPanel_RELATION TYPE DEFINITIONS"), new RelationSettingsPanel(widgets.getString("DiagramSettingsPanel_RELATION TYPE DEFINITIONS"), kinDiagramPanel, graphPanel.dataStoreSvg, dialogHandler));
        if (graphPanel.dataStoreSvg.diagramMode != DataStoreSvg.DiagramMode.FreeForm) {
            JScrollPane symbolFieldsPanel = new JScrollPane(new FieldSelectionList(entityCollection, kinDiagramPanel, graphPanel.getIndexParameters().symbolFieldsFields, tableCellDragHandler));
            JScrollPane labelFieldsPanel = new JScrollPane(new FieldSelectionList(entityCollection, kinDiagramPanel, graphPanel.getIndexParameters().labelFields, tableCellDragHandler));
            symbolFieldsPanel.setName(widgets.getString("DiagramSettingsPanel_SYMBOL FIELDS"));
            labelFieldsPanel.setName(widgets.getString("DiagramSettingsPanel_LABEL FIELDS"));
            jTabbedPane.addTab(widgets.getString("DiagramSettingsPanel_SYMBOL FIELDS"), symbolFieldsPanel);
            jTabbedPane.addTab(widgets.getString("DiagramSettingsPanel_LABEL FIELDS"), labelFieldsPanel);
            jTabbedPane.addTab(widgets.getString("DiagramSettingsPanel_ENTITY PROFILES"), cmdiProfileSelectionPanel);
        }
        this.add((Component)jTabbedPane, "Center");
    }
}

