/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.kintypestrings.KinType;
import nl.mpi.kinnate.kintypestrings.KinTypeElement;
import nl.mpi.kinnate.kintypestrings.LabelStringsParser;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.kintypestrings.QuerySectionParser;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.KinTypeStringProvider;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class KinTypeStringConverter
extends GraphSorter {
    DataStoreSvg dataStoreSvg;

    public KinTypeStringConverter(DataStoreSvg dataStoreSvg) {
        this.dataStoreSvg = dataStoreSvg;
    }

    public void setEgoKinTypeString(EntityData entityData) {
        for (KinType kinType : this.dataStoreSvg.getKinTypeDefinitions()) {
            if (!kinType.isEgoType() || !kinType.matchesEgonessAndSymbol(entityData, null, this.dataStoreSvg.defaultSymbol)) continue;
            entityData.addKinTypeString(kinType.codeString);
        }
    }

    public ArrayList<KinTypeElement> getKinTypeElements(String consumableString, ParserHighlight parserHighlight) {
        int initialLength = consumableString.length();
        ArrayList<KinTypeElement> kinTypeElementList = new ArrayList<KinTypeElement>();
        KinTypeElement previousElement = null;
        boolean foundKinType = true;
        String errorMessage = null;
        block0: while (foundKinType && consumableString.length() > 0) {
            for (KinType currentReferenceKinType : this.dataStoreSvg.getKinTypeDefinitions()) {
                foundKinType = false;
                boolean foundStart = false;
                if (consumableString.startsWith(currentReferenceKinType.codeString)) {
                    foundStart = true;
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.KinType, initialLength - consumableString.length(), currentReferenceKinType.displayString);
                } else if (consumableString.startsWith("[")) {
                    foundStart = true;
                }
                if (!foundStart) continue;
                KinTypeElement currentElement = new KinTypeElement();
                if (previousElement != null) {
                    previousElement.nextType = currentElement;
                    currentElement.prevType = previousElement;
                }
                previousElement = currentElement;
                currentElement.kinType = currentReferenceKinType;
                consumableString = consumableString.substring(currentReferenceKinType.codeString.length());
                foundKinType = true;
                QuerySectionParser querySectionParser = new QuerySectionParser(consumableString, parserHighlight, foundKinType, errorMessage);
                querySectionParser.parseQuerySection(currentElement, initialLength);
                consumableString = querySectionParser.consumableString;
                parserHighlight = querySectionParser.parserHighlight;
                foundKinType = querySectionParser.foundKinType;
                errorMessage = querySectionParser.errorMessage;
                kinTypeElementList.add(currentElement);
                continue block0;
            }
        }
        if (!foundKinType && !consumableString.startsWith("#")) {
            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), errorMessage);
        }
        if (consumableString.contains("#")) {
            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, initialLength - consumableString.length() + consumableString.indexOf("#"), null);
        }
        return kinTypeElementList;
    }

    public ArrayList<KinType> getKinTypes(String consumableString) {
        ArrayList<KinType> kinTypeList = new ArrayList<KinType>();
        boolean foundKinType = true;
        block0: while (foundKinType && consumableString.length() > 0) {
            for (KinType currentReferenceKinType : this.dataStoreSvg.getKinTypeDefinitions()) {
                foundKinType = false;
                if (!consumableString.startsWith(currentReferenceKinType.codeString)) continue;
                kinTypeList.add(currentReferenceKinType);
                consumableString = consumableString.substring(currentReferenceKinType.codeString.length());
                foundKinType = true;
                continue block0;
            }
        }
        return kinTypeList;
    }

    public void readKinTypes(ArrayList<KinTypeStringProvider> kinTypeStringProviders, DataStoreSvg dataStoreSvg) {
        HashMap<UniqueIdentifier, EntityData> namedEntitiesMap = new HashMap<UniqueIdentifier, EntityData>();
        HashSet<EntityData> allEntitiesSet = new HashSet<EntityData>();
        ArrayList<EntityData> egoDataNodeList = new ArrayList<EntityData>();
        int lineCounter = -1;
        for (KinTypeStringProvider kinTypeStringProvider : kinTypeStringProviders) {
            String[] kinTypeStrings = kinTypeStringProvider.getCurrentStrings();
            ParserHighlight[] parserHighlightArray = new ParserHighlight[kinTypeStrings.length];
            block1: for (String inputString : kinTypeStrings) {
                ParserHighlight parserHighlight = new ParserHighlight();
                if (parserHighlightArray.length > ++lineCounter) {
                    parserHighlightArray[lineCounter] = parserHighlight;
                }
                if (inputString == null || inputString.length() <= 0) continue;
                if (inputString.startsWith("#")) {
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, 0, null);
                    continue;
                }
                int initialLength = inputString.length();
                String consumableString = inputString;
                HashSet<EntityData> parentDataNodes = new HashSet<EntityData>();
                String fullKinTypeString = "";
                while (consumableString.length() > 0) {
                    int parserHighlightPosition = initialLength - consumableString.length();
                    boolean kinTypeFound = false;
                    for (KinType currentReferenceKinType : dataStoreSvg.getKinTypeDefinitions()) {
                        if (!consumableString.startsWith(currentReferenceKinType.codeString) || currentReferenceKinType.getRelationTypes() == null || currentReferenceKinType.getSymbolTypes() == null) continue;
                        String previousConsumableString = consumableString;
                        if (currentReferenceKinType.hasNoRelationTypes() && !parentDataNodes.isEmpty()) break;
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.KinType, parserHighlightPosition, currentReferenceKinType.displayString);
                        String currentKinTypeString = consumableString;
                        consumableString = consumableString.substring(currentReferenceKinType.codeString.length());
                        consumableString = consumableString.replaceAll("^[-\\+\\d]*", "");
                        currentKinTypeString = currentKinTypeString.substring(0, currentKinTypeString.length() - consumableString.length());
                        String kinTypeModifier = currentKinTypeString.substring(currentReferenceKinType.codeString.length());
                        HashSet<EntityData> currentGraphDataNodeSet = new HashSet<EntityData>();
                        fullKinTypeString = fullKinTypeString + previousConsumableString.substring(0, previousConsumableString.length() - consumableString.length());
                        LabelStringsParser labelStringsParser = new LabelStringsParser(consumableString, currentKinTypeString);
                        if (labelStringsParser.userDefinedIdentifierFound) {
                            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - consumableString.length(), "Label text");
                            consumableString = labelStringsParser.remainingInputString;
                        }
                        if (labelStringsParser.uidStartLocation > -1) {
                            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Parameter, initialLength - labelStringsParser.uidStartLocation, "User defined identifier");
                            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - labelStringsParser.uidEndLocation, "Label text");
                        }
                        if (labelStringsParser.dateLocation > -1) {
                            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Parameter, initialLength - labelStringsParser.dateLocation, "Date of birth/death");
                            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - labelStringsParser.dateEndLocation, "Label text");
                        }
                        if (labelStringsParser.dateError) {
                            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - labelStringsParser.dateLocation, "Incorrect date format: Valid formats are yyyy, yyyy/mm, yyyy/mm/dd with the birth date followed by death date eg yyyy/mm/dd-yyyy/mm/dd");
                            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - labelStringsParser.dateEndLocation, "Label text");
                        }
                        if (parentDataNodes.isEmpty()) {
                            this.generateNeededEntities(null, labelStringsParser, parentDataNodes, currentReferenceKinType, currentGraphDataNodeSet, kinTypeModifier, fullKinTypeString, egoDataNodeList, namedEntitiesMap, allEntitiesSet);
                        } else {
                            for (EntityData currentParentNode : parentDataNodes.toArray(new EntityData[0])) {
                                this.generateNeededEntities(currentParentNode, labelStringsParser, parentDataNodes, currentReferenceKinType, currentGraphDataNodeSet, kinTypeModifier, fullKinTypeString, egoDataNodeList, namedEntitiesMap, allEntitiesSet);
                            }
                        }
                        for (EntityData currentGraphDataNode : currentGraphDataNodeSet) {
                            currentGraphDataNode.isVisible = true;
                        }
                        for (KinTypeStringProvider kinTypeStringProviderKinGroup : kinTypeStringProviders) {
                            if (!(kinTypeStringProviderKinGroup instanceof KinTermGroup)) continue;
                            KinTermGroup kinTerms = (KinTermGroup)kinTypeStringProviderKinGroup;
                            if (!kinTerms.graphShow) continue;
                            for (EntityData currentGraphDataNode : currentGraphDataNodeSet) {
                                for (String kinTermLabel : kinTerms.getTermLabel(fullKinTypeString)) {
                                    currentGraphDataNode.addKinTermString(kinTermLabel, kinTerms.graphColour);
                                }
                            }
                        }
                        parentDataNodes = currentGraphDataNodeSet;
                        kinTypeFound = true;
                        break;
                    }
                    if (kinTypeFound) continue;
                    if ((consumableString = consumableString.replaceAll("^[\\s]*", "")).startsWith("#")) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, initialLength - consumableString.length(), null);
                        continue block1;
                    }
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), "Incorrect syntax");
                    int commentPosition = consumableString.indexOf("#");
                    if (commentPosition <= 0) continue block1;
                    consumableString = consumableString.substring(commentPosition);
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, initialLength - consumableString.length(), null);
                    continue block1;
                }
            }
            kinTypeStringProvider.highlightKinTypeStrings(parserHighlightArray, kinTypeStrings);
        }
        super.setEntitys(allEntitiesSet.toArray(new EntityData[0]));
    }

    private void generateNeededEntities(EntityData currentParentNode, LabelStringsParser labelStringsParser, HashSet<EntityData> parentDataNodes, KinType currentReferenceKinType, HashSet<EntityData> currentGraphDataNodeSet, String kinTypeModifier, String fullKinTypeString, ArrayList<EntityData> egoDataNodeList, HashMap<UniqueIdentifier, EntityData> namedEntitiesMap, HashSet<EntityData> allEntitiesSet) {
        if (!parentDataNodes.isEmpty() && !labelStringsParser.userDefinedIdentifierFound) {
            for (EntityData parentDataNode : parentDataNodes) {
                for (EntityRelation entityRelation : parentDataNode.getAllRelations()) {
                    if (!currentReferenceKinType.matchesRelation(entityRelation, kinTypeModifier, this.dataStoreSvg.defaultSymbol)) continue;
                    EntityData alterNode = entityRelation.getAlterNode();
                    currentGraphDataNodeSet.add(alterNode);
                    alterNode.addKinTypeString(fullKinTypeString);
                }
            }
        } else if (parentDataNodes.isEmpty() && !labelStringsParser.userDefinedIdentifierFound) {
            for (EntityData egoEntity : egoDataNodeList) {
                if (!currentReferenceKinType.matchesEgonessAndSymbol(egoEntity, kinTypeModifier, this.dataStoreSvg.defaultSymbol)) continue;
                currentGraphDataNodeSet.add(egoEntity);
                egoEntity.addKinTypeString(fullKinTypeString);
            }
        }
        for (EntityData.SymbolType symbolType : currentReferenceKinType.getSymbolTypes()) {
            EntityData currentGraphDataNode = null;
            if (labelStringsParser.userDefinedIdentifierFound) {
                currentGraphDataNode = namedEntitiesMap.get(labelStringsParser.getUniqueIdentifier());
            } else if (currentParentNode != null) {
                for (EntityRelation entityRelation : currentParentNode.getAllRelations()) {
                    boolean symbolMatchFound = false;
                    for (String symbolName : entityRelation.getAlterNode().getSymbolNames(this.dataStoreSvg.defaultSymbol)) {
                        if (!symbolType.toString().equals(symbolName)) continue;
                        symbolMatchFound = true;
                        break;
                    }
                    if (!symbolMatchFound || !currentReferenceKinType.matchesRelation(entityRelation, kinTypeModifier, this.dataStoreSvg.defaultSymbol)) continue;
                    currentGraphDataNode = entityRelation.getAlterNode();
                    currentGraphDataNodeSet.add(currentGraphDataNode);
                    currentGraphDataNode.addKinTypeString(fullKinTypeString);
                }
            } else {
                for (EntityData existingEntity : currentGraphDataNodeSet) {
                    if (!currentReferenceKinType.matchesEgonessAndSymbol(existingEntity, kinTypeModifier, this.dataStoreSvg.defaultSymbol)) continue;
                    currentGraphDataNode = existingEntity;
                }
            }
            if (currentGraphDataNode == null) {
                currentGraphDataNode = new EntityData(labelStringsParser, currentParentNode, fullKinTypeString, symbolType, currentReferenceKinType.isEgoType());
            }
            if (currentGraphDataNode.isEgo) {
                egoDataNodeList.add(currentGraphDataNode);
            }
            if (labelStringsParser.userDefinedIdentifierFound) {
                namedEntitiesMap.put(currentGraphDataNode.getUniqueIdentifier(), currentGraphDataNode);
            }
            currentGraphDataNodeSet.add(currentGraphDataNode);
            allEntitiesSet.add(currentGraphDataNode);
            if (parentDataNodes.isEmpty() || currentReferenceKinType.hasNoRelationTypes() || currentParentNode == null) continue;
            for (DataTypes.RelationType relationType : currentReferenceKinType.getRelationTypes()) {
                EntityRelation nodeRelation = currentParentNode.addRelatedNode(currentGraphDataNode, relationType, null, null, null, null);
                if (kinTypeModifier == null || kinTypeModifier.isEmpty()) continue;
                if (kinTypeModifier.equals("-")) {
                    nodeRelation.setRelationOrder(-1);
                    continue;
                }
                if (kinTypeModifier.equals("+")) {
                    nodeRelation.setRelationOrder(1);
                    continue;
                }
                nodeRelation.setRelationOrder(Integer.parseInt(kinTypeModifier.replaceFirst("^\\+", "")));
            }
        }
    }

    public static enum QueryType {
        Contains,
        Greater,
        Less,
        Equals;

    }
}

