/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashSet;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.GraphicsDragHandle;
import nl.mpi.kinnate.svg.OldFormatException;
import nl.mpi.kinnate.svg.RelationDragHandle;
import nl.mpi.kinnate.svg.RelationSvg;
import nl.mpi.kinnate.svg.relationlines.RelationRecord;
import nl.mpi.kinnate.svg.relationlines.RelationRecordTable;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;

public class SvgUpdateHandler {
    private GraphPanel graphPanel;
    private final KinDiagramPanel kinTermSavePanel;
    private MessageDialogHandler dialogHandler;
    private boolean dragUpdateRequired = false;
    private boolean threadRunning = false;
    private boolean relationThreadRunning = false;
    private int updateDragNodeX = 0;
    private int updateDragNodeY = 0;
    private int updateDragRelationX = 0;
    private int updateDragRelationY = 0;
    private float[][] dragRemainders = null;
    private float dragScale;
    private boolean resizeRequired = false;
    protected RelationDragHandle relationDragHandle = null;
    private HashSet<UniqueIdentifier> highlightedIdentifiers = new HashSet();
    public RelationRecordTable relationRecords;
    private boolean oldFormatWarningShown = false;
    private int paddingDistance = 20;
    private Rectangle dragSelectionRectOnDocument = null;

    public SvgUpdateHandler(GraphPanel graphPanel, KinDiagramPanel kinTermSavePanel, MessageDialogHandler dialogHandler) {
        this.graphPanel = graphPanel;
        this.kinTermSavePanel = kinTermSavePanel;
        this.dialogHandler = dialogHandler;
    }

    public void clearHighlights() {
        this.removeRelationHighLights();
        for (UniqueIdentifier currentIdentifier : this.highlightedIdentifiers.toArray(new UniqueIdentifier[0])) {
            Element existingHighlight = this.graphPanel.doc.getElementById("highlight_" + currentIdentifier.getAttributeIdentifier());
            if (existingHighlight != null) {
                existingHighlight.getParentNode().removeChild(existingHighlight);
            }
            this.highlightedIdentifiers.remove(currentIdentifier);
        }
    }

    private void removeRelationHighLights() {
        Element relationOldHighlightGroup = this.graphPanel.doc.getElementById("RelationHighlightGroup");
        if (relationOldHighlightGroup != null) {
            relationOldHighlightGroup.getParentNode().removeChild(relationOldHighlightGroup);
        }
    }

    private void removeEntityHighLights() {
        Element entityHighlightGroup = this.graphPanel.doc.getElementById("highlight");
        while (entityHighlightGroup != null) {
            entityHighlightGroup.getParentNode().removeChild(entityHighlightGroup);
            entityHighlightGroup = this.graphPanel.doc.getElementById("highlight");
        }
    }

    private void createRelationLineHighlights(Element entityGroup) {
        this.removeRelationHighLights();
        if (this.relationRecords != null && this.graphPanel.dataStoreSvg.highlightRelationLines) {
            Element relationHighlightGroup = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
            relationHighlightGroup.setAttribute("id", "RelationHighlightGroup");
            entityGroup.getParentNode().insertBefore(relationHighlightGroup, entityGroup);
            for (RelationRecord relationRecord : this.relationRecords.getRecordsForSelection(this.graphPanel.selectedGroupId)) {
                String lineWidth = Integer.toString(relationRecord.lineWidth);
                String pathPointsString = relationRecord.getPathPointsString();
                Element highlightBackgroundLine = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "path");
                highlightBackgroundLine.setAttribute("stroke-width", lineWidth);
                highlightBackgroundLine.setAttribute("fill", "none");
                highlightBackgroundLine.setAttribute("d", pathPointsString);
                highlightBackgroundLine.setAttribute("stroke", "white");
                relationHighlightGroup.appendChild(highlightBackgroundLine);
                Element highlightLine = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "path");
                highlightLine.setAttribute("stroke-width", lineWidth);
                highlightLine.setAttribute("fill", "none");
                highlightLine.setAttribute("d", pathPointsString);
                highlightLine.setAttribute("stroke", "blue");
                highlightLine.setAttribute("stroke-dasharray", "3");
                highlightLine.setAttribute("stroke-dashoffset", "0");
                relationHighlightGroup.appendChild(highlightLine);
            }
        }
    }

    private void updateDragRelationLines(Element entityGroup, float localDragNodeX, float localDragNodeY) {
        RelationDragHandle localRelationDragHandle = this.relationDragHandle;
        if (localRelationDragHandle != null) {
            if (localRelationDragHandle instanceof GraphicsDragHandle) {
                ((GraphicsDragHandle)localRelationDragHandle).updatedElement(localDragNodeX, localDragNodeY, this.paddingDistance);
            } else {
                float dragNodeX = localRelationDragHandle.getTranslatedX(localDragNodeX);
                float dragNodeY = localRelationDragHandle.getTranslatedY(localDragNodeY);
                boolean entityConnection = false;
                localRelationDragHandle.targetIdentifier = this.graphPanel.entitySvg.getClosestEntity(new float[]{dragNodeX, dragNodeY}, 30, this.graphPanel.selectedGroupId);
                if (localRelationDragHandle.targetIdentifier != null) {
                    Point closestEntityPoint = this.graphPanel.entitySvg.getEntityLocationOffset(localRelationDragHandle.targetIdentifier);
                    dragNodeX = closestEntityPoint.x;
                    dragNodeY = closestEntityPoint.y;
                    entityConnection = true;
                }
                Element relationHighlightGroup = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
                relationHighlightGroup.setAttribute("id", "RelationHighlightGroup");
                entityGroup.getParentNode().insertBefore(relationHighlightGroup, entityGroup);
                float vSpacing = this.graphPanel.graphPanelSize.getVerticalSpacing();
                float hSpacing = this.graphPanel.graphPanelSize.getHorizontalSpacing();
                for (UniqueIdentifier uniqueIdentifier : this.graphPanel.selectedGroupId) {
                    Point dragPoint;
                    Point egoSymbolPoint;
                    String dragLineElementId = "dragLine-" + uniqueIdentifier.getAttributeIdentifier();
                    Point parentPoint = null;
                    DataTypes.RelationType directedRelation = localRelationDragHandle.getRelationType();
                    if (directedRelation == DataTypes.RelationType.descendant) {
                        egoSymbolPoint = new Point((int)dragNodeX, (int)dragNodeY);
                        dragPoint = this.graphPanel.entitySvg.getEntityLocationOffset(uniqueIdentifier);
                        directedRelation = DataTypes.RelationType.ancestor;
                    } else {
                        egoSymbolPoint = this.graphPanel.entitySvg.getEntityLocationOffset(uniqueIdentifier);
                        dragPoint = new Point((int)dragNodeX, (int)dragNodeY);
                    }
                    String svgLineType = "path";
                    Element highlightBackgroundLine = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, svgLineType);
                    highlightBackgroundLine.setAttribute("stroke-width", Integer.toString(2));
                    highlightBackgroundLine.setAttribute("fill", "none");
                    highlightBackgroundLine.setAttribute("stroke", "white");
                    try {
                        RelationRecord relationRecord = DataTypes.isSanguinLine(directedRelation) ? new RelationRecord(dragLineElementId, directedRelation, vSpacing, egoSymbolPoint, dragPoint, parentPoint) : new RelationRecord(localRelationDragHandle.getCurveLineOrientation(), hSpacing, vSpacing, egoSymbolPoint, dragPoint);
                        highlightBackgroundLine.setAttribute("d", relationRecord.getPathPointsString());
                        relationHighlightGroup.appendChild(highlightBackgroundLine);
                        Element highlightLine = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, svgLineType);
                        highlightLine.setAttribute("stroke-width", Integer.toString(2));
                        highlightLine.setAttribute("fill", "none");
                        highlightLine.setAttribute("d", relationRecord.getPathPointsString());
                        highlightLine.setAttribute("stroke", localRelationDragHandle.getRelationColour());
                        highlightLine.setAttribute("stroke-dasharray", "3");
                        highlightLine.setAttribute("stroke-dashoffset", "0");
                        relationHighlightGroup.appendChild(highlightLine);
                    }
                    catch (OldFormatException exception) {
                        if (this.oldFormatWarningShown) continue;
                        this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Old or erroneous format detected");
                        this.oldFormatWarningShown = true;
                    }
                }
                Element symbolNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "circle");
                symbolNode.setAttribute("cx", Float.toString(dragNodeX));
                symbolNode.setAttribute("cy", Float.toString(dragNodeY));
                if (entityConnection) {
                    symbolNode.setAttribute("r", "20");
                    symbolNode.setAttribute("fill", "none");
                    symbolNode.setAttribute("stroke", localRelationDragHandle.getRelationColour());
                    symbolNode.setAttribute("stroke-width", Integer.toString(2));
                } else {
                    symbolNode.setAttribute("r", "5");
                    symbolNode.setAttribute("fill", localRelationDragHandle.getRelationColour());
                    symbolNode.setAttribute("stroke", "none");
                }
                relationHighlightGroup.appendChild(symbolNode);
            }
        }
    }

    protected void addRelationDragHandles(RelationTypeDefinition[] relationTypeDefinitions, Element highlightGroupNode, SVGRect bbox, int paddingDistance) {
        float minCY;
        for (DataTypes.RelationType relationType : new DataTypes.RelationType[]{DataTypes.RelationType.ancestor, DataTypes.RelationType.descendant, DataTypes.RelationType.union, DataTypes.RelationType.sibling}) {
            Element symbolNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "circle");
            switch (relationType) {
                case ancestor: {
                    symbolNode.setAttribute("cy", Float.toString(bbox.getY() - (float)paddingDistance));
                    symbolNode.setAttribute("cx", Float.toString(bbox.getX() + bbox.getWidth() / 2.0f));
                    break;
                }
                case descendant: {
                    symbolNode.setAttribute("cy", Float.toString(bbox.getY() + bbox.getHeight() + (float)paddingDistance));
                    symbolNode.setAttribute("cx", Float.toString(bbox.getX() + bbox.getWidth() / 2.0f));
                    break;
                }
                case union: {
                    symbolNode.setAttribute("cy", Float.toString(bbox.getY() + bbox.getHeight()));
                    symbolNode.setAttribute("cx", Float.toString(bbox.getX() - (float)paddingDistance));
                    break;
                }
                case sibling: {
                    symbolNode.setAttribute("cy", Float.toString(bbox.getY()));
                    symbolNode.setAttribute("cx", Float.toString(bbox.getX() - (float)paddingDistance));
                }
            }
            symbolNode.setAttribute("r", "5");
            symbolNode.setAttribute("handletype", relationType.name());
            symbolNode.setAttribute("fill", "blue");
            symbolNode.setAttribute("stroke", "none");
            ((EventTarget)((Object)symbolNode)).addEventListener("mousedown", this.graphPanel.mouseListenerSvg, false);
            highlightGroupNode.appendChild(symbolNode);
        }
        float currentCX = bbox.getX() + bbox.getWidth() + (float)paddingDistance;
        float currentCY = minCY = bbox.getY() - (float)paddingDistance;
        float stepC = 12.0f;
        float maxCY = bbox.getHeight() + (float)paddingDistance;
        for (RelationTypeDefinition typeDefinition : relationTypeDefinitions) {
            if (typeDefinition == null) continue;
            for (DataTypes.RelationType relationType : typeDefinition.getRelationType()) {
                Element symbolNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "circle");
                symbolNode.setAttribute("cx", Float.toString(currentCX));
                symbolNode.setAttribute("cy", Float.toString(currentCY));
                currentCY += stepC;
                if (currentCY >= maxCY) {
                    currentCY = minCY;
                    currentCX += stepC;
                }
                symbolNode.setAttribute("r", "5");
                symbolNode.setAttribute("handletype", "custom:" + (Object)((Object)relationType) + ":" + typeDefinition.hashCode());
                symbolNode.setAttribute("fill", typeDefinition.getLineColour());
                symbolNode.setAttribute("stroke", "none");
                ((EventTarget)((Object)symbolNode)).addEventListener("mousedown", this.graphPanel.mouseListenerSvg, false);
                highlightGroupNode.appendChild(symbolNode);
            }
        }
    }

    protected void addGraphicsDragHandles(Element highlightGroupNode, UniqueIdentifier targetIdentifier, SVGRect bbox, int paddingDistance) {
        Element symbolNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "circle");
        symbolNode.setAttribute("cx", Float.toString(bbox.getX() + bbox.getWidth() + (float)paddingDistance));
        symbolNode.setAttribute("cy", Float.toString(bbox.getY() + bbox.getHeight() + (float)paddingDistance));
        symbolNode.setAttribute("r", "5");
        symbolNode.setAttribute("target", targetIdentifier.getAttributeIdentifier());
        symbolNode.setAttribute("fill", "blue");
        symbolNode.setAttribute("stroke", "none");
        ((EventTarget)((Object)symbolNode)).addEventListener("mousedown", this.graphPanel.mouseListenerSvg, false);
        highlightGroupNode.appendChild(symbolNode);
    }

    public void panToSelected(UniqueIdentifier[] targetIdentifiers) {
        UpdateManager updateManager;
        Rectangle selectionSize = null;
        for (UniqueIdentifier currentIdentifier : targetIdentifiers) {
            Point currentPoint = this.graphPanel.entitySvg.getEntityLocationOffset(currentIdentifier);
            if (currentPoint == null) continue;
            if (selectionSize == null) {
                selectionSize = new Rectangle(currentPoint.x, currentPoint.y, 1, 1);
                continue;
            }
            selectionSize.add(currentPoint);
        }
        final Rectangle selectionRect = selectionSize;
        Rectangle renderRectScreen = this.graphPanel.svgCanvas.getBounds();
        Element labelGroup = this.graphPanel.doc.getElementById("LabelsGroup");
        SVGLocatable labelGroupLocatable = (SVGLocatable)labelGroup;
        final Rectangle renderRectDocument = this.getRectOnDocument(renderRectScreen, labelGroupLocatable);
        if (selectionRect != null && selectionRect != null && !renderRectDocument.contains(selectionRect) && (updateManager = this.graphPanel.svgCanvas.getUpdateManager()) != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SVGLocatable diagramGroupLocatable = (SVGLocatable)((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("DiagramGroup");
                    double scaleFactor = diagramGroupLocatable.getScreenCTM().getA();
                    AffineTransform at = new AffineTransform();
                    double offsetX = renderRectDocument.getCenterX() - selectionRect.getCenterX();
                    double offsetY = renderRectDocument.getCenterY() - selectionRect.getCenterY();
                    at.translate(offsetX / 2.0 * scaleFactor, offsetY / 2.0 * scaleFactor);
                    at.concatenate(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgCanvas.getRenderingTransform());
                    ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgCanvas.setRenderingTransform(at);
                }
            });
        }
    }

    public void addTestRect(final Rectangle testRect, int rectangleID) {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        final String rectangleName = "SelectionBorder" + rectangleID;
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    System.out.println("selectionRect: " + testRect);
                    Element pageBorderNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById(rectangleName);
                    if (pageBorderNode == null) {
                        Element labelGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("LabelsGroup");
                        pageBorderNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "rect");
                        pageBorderNode.setAttribute("id", rectangleName);
                        pageBorderNode.setAttribute("fill", "none");
                        pageBorderNode.setAttribute("x", Float.toString(testRect.x - 20));
                        pageBorderNode.setAttribute("y", Float.toString(testRect.y - 20));
                        pageBorderNode.setAttribute("width", Float.toString(testRect.width + 40));
                        pageBorderNode.setAttribute("height", Float.toString(testRect.height + 40));
                        pageBorderNode.setAttribute("stroke-width", "1");
                        pageBorderNode.setAttribute("stroke", "green");
                        labelGroup.appendChild(pageBorderNode);
                    }
                    pageBorderNode.setAttribute("x", Float.toString(testRect.x - 20));
                    pageBorderNode.setAttribute("y", Float.toString(testRect.y - 20));
                    pageBorderNode.setAttribute("width", Float.toString(testRect.width + 40));
                    pageBorderNode.setAttribute("height", Float.toString(testRect.height + 40));
                    System.out.println("pageBorderNode:" + pageBorderNode);
                }
            });
        }
    }

    public void updateMouseDot(final Point currentLocation) {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Element labelGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("LabelsGroup");
                    Element mouseDotElement = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("MouseDot");
                    if (mouseDotElement == null) {
                        mouseDotElement = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "circle");
                        mouseDotElement.setAttribute("id", "MouseDot");
                        mouseDotElement.setAttribute("r", "5");
                        mouseDotElement.setAttribute("fill", "blue");
                        mouseDotElement.setAttribute("stroke", "none");
                        labelGroup.appendChild(mouseDotElement);
                    }
                    SVGLocatable labelGroupLocatable = (SVGLocatable)labelGroup;
                    SVGOMPoint pointOnDocument = SvgUpdateHandler.this.getPointOnDocument(currentLocation, labelGroupLocatable);
                    mouseDotElement.setAttribute("cx", Float.toString(pointOnDocument.getX()));
                    mouseDotElement.setAttribute("cy", Float.toString(pointOnDocument.getY()));
                }
            });
        }
    }

    public Point getEntityPointOnDocument(Point screenLocation) {
        Element etityGroup = this.graphPanel.doc.getElementById("EntityGroup");
        SVGOMPoint pointOnDocument = this.getPointOnDocument(screenLocation, (SVGLocatable)etityGroup);
        return new Point((int)pointOnDocument.getX(), (int)pointOnDocument.getY());
    }

    private SVGOMPoint getPointOnScreen(Point documentLocation, SVGLocatable targetGroupElement) {
        SVGOMPoint pointOnDocument = new SVGOMPoint((float)documentLocation.x, (float)documentLocation.y);
        SVGMatrix mat = targetGroupElement.getScreenCTM();
        return (SVGOMPoint)pointOnDocument.matrixTransform(mat);
    }

    private SVGOMPoint getPointOnDocument(Point screenLocation, SVGLocatable targetGroupElement) {
        SVGOMPoint pointOnScreen = new SVGOMPoint((float)screenLocation.x, (float)screenLocation.y);
        SVGMatrix mat = targetGroupElement.getScreenCTM();
        mat = mat.inverse();
        return (SVGOMPoint)pointOnScreen.matrixTransform(mat);
    }

    private Rectangle getRectOnDocument(Rectangle screenRectangle, SVGLocatable targetGroupElement) {
        SVGOMPoint pointOnScreen = new SVGOMPoint((float)screenRectangle.x, (float)screenRectangle.y);
        SVGOMPoint sizeOnScreen = new SVGOMPoint((float)screenRectangle.width, (float)screenRectangle.height);
        SVGMatrix mat = targetGroupElement.getScreenCTM();
        mat = mat.inverse();
        SVGPoint pointOnDocument = pointOnScreen.matrixTransform(mat);
        SVGOMPoint sizeOnDocument = new SVGOMPoint(sizeOnScreen.getX() * mat.getA(), sizeOnScreen.getY() * mat.getA());
        System.out.println("sizeOnScreen: " + sizeOnScreen);
        System.out.println("sizeOnDocument: " + sizeOnDocument);
        return new Rectangle((int)pointOnDocument.getX(), (int)pointOnDocument.getY(), (int)sizeOnDocument.getX(), (int)sizeOnDocument.getY());
    }

    protected void updateSvgSelectionHighlights() {
        UpdateManager updateManager;
        if (this.kinTermSavePanel != null) {
            this.kinTermSavePanel.setStatusBarText(this.graphPanel.selectedGroupId.size() + " selected of " + this.kinTermSavePanel.getGraphEntities().length + "");
            String kinTypeStrings = "";
            for (UniqueIdentifier entityID : this.graphPanel.selectedGroupId) {
                if (kinTypeStrings.length() != 0) {
                    kinTypeStrings = kinTypeStrings + ",";
                }
                kinTypeStrings = kinTypeStrings + this.graphPanel.getKinTypeForElementId(entityID);
            }
            if (kinTypeStrings != null) {
                this.kinTermSavePanel.setSelectedKinTypeSting(kinTypeStrings);
            }
        }
        if ((updateManager = this.graphPanel.svgCanvas.getUpdateManager()) != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc != null) {
                        boolean isLeadSelection = true;
                        for (UniqueIdentifier currentIdentifier : SvgUpdateHandler.this.highlightedIdentifiers.toArray(new UniqueIdentifier[0])) {
                            if (((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId.contains(currentIdentifier)) continue;
                            Element existingHighlight = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("highlight_" + currentIdentifier.getAttributeIdentifier());
                            if (existingHighlight != null) {
                                existingHighlight.getParentNode().removeChild(existingHighlight);
                            }
                            SvgUpdateHandler.this.highlightedIdentifiers.remove(currentIdentifier);
                        }
                        for (UniqueIdentifier uniqueIdentifier : ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId.toArray(new UniqueIdentifier[0])) {
                            Element selectedGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById(uniqueIdentifier.getAttributeIdentifier());
                            Element existingHighlight = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("highlight_" + uniqueIdentifier.getAttributeIdentifier());
                            if (existingHighlight == null && selectedGroup != null) {
                                SVGRect bbox = ((SVGLocatable)selectedGroup).getBBox();
                                Element highlightGroupNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "g");
                                ((EventTarget)((Object)highlightGroupNode)).addEventListener("mousedown", ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.mouseListenerSvg, false);
                                highlightGroupNode.setAttribute("id", "highlight_" + uniqueIdentifier.getAttributeIdentifier());
                                Element symbolNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "rect");
                                symbolNode.setAttribute("x", Float.toString(bbox.getX() - (float)SvgUpdateHandler.this.paddingDistance));
                                symbolNode.setAttribute("y", Float.toString(bbox.getY() - (float)SvgUpdateHandler.this.paddingDistance));
                                symbolNode.setAttribute("width", Float.toString(bbox.getWidth() + (float)(SvgUpdateHandler.this.paddingDistance * 2)));
                                symbolNode.setAttribute("height", Float.toString(bbox.getHeight() + (float)(SvgUpdateHandler.this.paddingDistance * 2)));
                                symbolNode.setAttribute("fill", "#999999");
                                symbolNode.setAttribute("fill-opacity", "0");
                                symbolNode.setAttribute("stroke-width", "1");
                                if (isLeadSelection) {
                                    symbolNode.setAttribute("stroke-dasharray", "3");
                                    symbolNode.setAttribute("stroke-dashoffset", "0");
                                } else {
                                    symbolNode.setAttribute("stroke-dasharray", "6");
                                    symbolNode.setAttribute("stroke-dashoffset", "0");
                                }
                                symbolNode.setAttribute("stroke", "blue");
                                highlightGroupNode.appendChild(symbolNode);
                                if (!uniqueIdentifier.isTransientIdentifier() && !uniqueIdentifier.isGraphicsIdentifier()) {
                                    SvgUpdateHandler.this.addRelationDragHandles(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.getRelationTypeDefinitions(), highlightGroupNode, bbox, SvgUpdateHandler.this.paddingDistance);
                                } else if (uniqueIdentifier.isGraphicsIdentifier() && !"text".equals(selectedGroup.getLocalName())) {
                                    SvgUpdateHandler.this.addGraphicsDragHandles(highlightGroupNode, uniqueIdentifier, bbox, SvgUpdateHandler.this.paddingDistance);
                                }
                                if ("g".equals(selectedGroup.getLocalName())) {
                                    selectedGroup.appendChild(highlightGroupNode);
                                } else {
                                    highlightGroupNode.setAttribute("transform", selectedGroup.getAttribute("transform"));
                                    selectedGroup.getParentNode().appendChild(highlightGroupNode);
                                }
                                SvgUpdateHandler.this.highlightedIdentifiers.add(uniqueIdentifier);
                            }
                            isLeadSelection = false;
                        }
                        SvgUpdateHandler.this.createRelationLineHighlights(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("EntityGroup"));
                    }
                }
            });
        }
    }

    protected void dragCanvas(int updateDragNodeXLocal, int updateDragNodeYLocal) {
        AffineTransform at = new AffineTransform();
        at.translate(updateDragNodeXLocal, updateDragNodeYLocal);
        at.concatenate(this.graphPanel.svgCanvas.getRenderingTransform());
        this.graphPanel.svgCanvas.setRenderingTransform(at);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDragRelation(int updateDragNodeXLocal, int updateDragNodeYLocal) {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        SvgUpdateHandler svgUpdateHandler = this;
        synchronized (svgUpdateHandler) {
            this.updateDragRelationX = updateDragNodeXLocal;
            this.updateDragRelationY = updateDragNodeYLocal;
            if (!this.relationThreadRunning) {
                this.relationThreadRunning = true;
                updateManager.getUpdateRunnableQueue().invokeLater(this.getRelationRunnable());
            }
        }
    }

    private Runnable getRelationRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SvgUpdateHandler svgUpdateHandler;
                Element entityGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("EntityGroup");
                int updateDragNodeXLocal = 0;
                int updateDragNodeYLocal = 0;
                while (updateDragNodeXLocal != SvgUpdateHandler.this.updateDragRelationX && updateDragNodeYLocal != SvgUpdateHandler.this.updateDragRelationY) {
                    svgUpdateHandler = SvgUpdateHandler.this;
                    synchronized (svgUpdateHandler) {
                        updateDragNodeXLocal = SvgUpdateHandler.this.updateDragRelationX;
                        updateDragNodeYLocal = SvgUpdateHandler.this.updateDragRelationY;
                    }
                    SvgUpdateHandler.this.removeRelationHighLights();
                    SvgUpdateHandler.this.removeEntityHighLights();
                    SvgUpdateHandler.this.updateDragRelationLines(entityGroup, updateDragNodeXLocal, updateDragNodeYLocal);
                }
                svgUpdateHandler = SvgUpdateHandler.this;
                synchronized (svgUpdateHandler) {
                    SvgUpdateHandler.this.relationThreadRunning = false;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDrag() {
        float[][] tempRemainders = new float[this.graphPanel.selectedGroupId.size()][];
        for (int dragCounter = 0; dragCounter < tempRemainders.length; ++dragCounter) {
            tempRemainders[dragCounter] = new float[]{0.0f, 0.0f};
        }
        SvgUpdateHandler svgUpdateHandler = this;
        synchronized (svgUpdateHandler) {
            this.dragRemainders = tempRemainders;
            SVGMatrix draggedElementScreenMatrix = ((SVGLocatable)this.graphPanel.doc.getDocumentElement()).getScreenCTM().inverse();
            this.dragScale = draggedElementScreenMatrix.getA();
        }
    }

    protected Rectangle removeSelectionRect() {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Element labelGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("LabelsGroup");
                    Element selectionBorderNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("drag_select_highlight");
                    labelGroup.removeChild(selectionBorderNode);
                }
            });
        }
        return this.dragSelectionRectOnDocument;
    }

    protected void drawSelectionRect(final Point startLocation, final Point currentLocation) {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    float tempValue;
                    Element labelGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("LabelsGroup");
                    SVGOMPoint startOnDocument = SvgUpdateHandler.this.getPointOnDocument(startLocation, (SVGLocatable)labelGroup);
                    SVGOMPoint currentOnDocument = SvgUpdateHandler.this.getPointOnDocument(currentLocation, (SVGLocatable)labelGroup);
                    Element selectionBorderNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("drag_select_highlight");
                    float highlightX = startOnDocument.getX();
                    float highlightY = startOnDocument.getY();
                    float highlightWidth = currentOnDocument.getX();
                    float highlightHeight = currentOnDocument.getY();
                    if (highlightX > highlightWidth) {
                        tempValue = highlightWidth;
                        highlightWidth = highlightX;
                        highlightX = tempValue;
                    }
                    if (highlightY > highlightHeight) {
                        tempValue = highlightHeight;
                        highlightHeight = highlightY;
                        highlightY = tempValue;
                    }
                    SvgUpdateHandler.this.dragSelectionRectOnDocument = new Rectangle((int)highlightX, (int)highlightY, (int)(highlightWidth -= highlightX), (int)(highlightHeight -= highlightY));
                    if (selectionBorderNode == null) {
                        selectionBorderNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "rect");
                        selectionBorderNode.setAttribute("id", "drag_select_highlight");
                        selectionBorderNode.setAttribute("fill", "none");
                        selectionBorderNode.setAttribute("x", Float.toString(highlightX));
                        selectionBorderNode.setAttribute("y", Float.toString(highlightY));
                        selectionBorderNode.setAttribute("width", Float.toString(highlightWidth));
                        selectionBorderNode.setAttribute("height", Float.toString(highlightHeight));
                        selectionBorderNode.setAttribute("stroke-width", "1");
                        selectionBorderNode.setAttribute("stroke", "blue");
                        labelGroup.appendChild(selectionBorderNode);
                    }
                    selectionBorderNode.setAttribute("x", Float.toString(highlightX));
                    selectionBorderNode.setAttribute("y", Float.toString(highlightY));
                    selectionBorderNode.setAttribute("width", Float.toString(highlightWidth));
                    selectionBorderNode.setAttribute("height", Float.toString(highlightHeight));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDragNode(int updateDragNodeXLocal, int updateDragNodeYLocal) {
        this.resizeRequired = true;
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        SvgUpdateHandler svgUpdateHandler = this;
        synchronized (svgUpdateHandler) {
            this.dragUpdateRequired = true;
            this.updateDragNodeX += updateDragNodeXLocal;
            this.updateDragNodeY += updateDragNodeYLocal;
            if (!this.threadRunning) {
                this.threadRunning = true;
                updateManager.getUpdateRunnableQueue().invokeLater(this.getRunnable());
            }
        }
    }

    private Runnable getRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                block19: {
                    Rectangle initialGraphRect = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.graphData.getGraphSize(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.entitySvg.entityPositions);
                    Element entityGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("EntityGroup");
                    try {
                        boolean continueUpdating = true;
                        while (continueUpdating) {
                            continueUpdating = false;
                            SvgUpdateHandler svgUpdateHandler = SvgUpdateHandler.this;
                            // MONITORENTER : svgUpdateHandler
                            SvgUpdateHandler.this.dragUpdateRequired = false;
                            int updateDragNodeXInner = SvgUpdateHandler.this.updateDragNodeX;
                            int updateDragNodeYInner = SvgUpdateHandler.this.updateDragNodeY;
                            SvgUpdateHandler.this.updateDragNodeX = 0;
                            SvgUpdateHandler.this.updateDragNodeY = 0;
                            // MONITOREXIT : svgUpdateHandler
                            if (((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc == null || ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.graphData == null) {
                                BugCatcherManager.getBugCatcher().logError(new Exception("graphData or the svg document is null, is this an old file format? try redrawing before draging."));
                            } else {
                                boolean allRealtionsSelected = true;
                                block11: for (EntityData entityData : ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                                    if (!entityData.isVisible || !((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId.contains(entityData.getUniqueIdentifier())) continue;
                                    for (EntityData relatedEntity : entityData.getVisiblyRelated()) {
                                        if (!relatedEntity.isVisible || ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId.contains(relatedEntity.getUniqueIdentifier())) continue;
                                        allRealtionsSelected = false;
                                        break block11;
                                    }
                                }
                                int dragCounter = 0;
                                for (UniqueIdentifier entityId : ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId) {
                                    SvgUpdateHandler svgUpdateHandler2 = SvgUpdateHandler.this;
                                    // MONITORENTER : svgUpdateHandler2
                                    if (SvgUpdateHandler.this.dragRemainders.length > dragCounter) {
                                        ((SvgUpdateHandler)SvgUpdateHandler.this).dragRemainders[dragCounter] = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.entitySvg.moveEntity(SvgUpdateHandler.this.graphPanel, entityId, updateDragNodeXInner, SvgUpdateHandler.this.dragRemainders[dragCounter][0], updateDragNodeYInner, SvgUpdateHandler.this.dragRemainders[dragCounter][1], ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.snapToGrid, SvgUpdateHandler.this.dragScale, allRealtionsSelected);
                                    }
                                    // MONITOREXIT : svgUpdateHandler2
                                    ++dragCounter;
                                }
                                int vSpacing = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.graphPanelSize.getVerticalSpacing();
                                int hSpacing = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.graphPanelSize.getHorizontalSpacing();
                                new RelationSvg(SvgUpdateHandler.this.dialogHandler).updateRelationLines(SvgUpdateHandler.this.graphPanel, SvgUpdateHandler.this.relationRecords, ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId, hSpacing, vSpacing);
                                SvgUpdateHandler.this.createRelationLineHighlights(entityGroup);
                                Rectangle rectangle = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.graphData.getGraphSize(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.entitySvg.entityPositions);
                                if (!initialGraphRect.contains(rectangle)) {
                                    Element svgRoot = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getDocumentElement();
                                    Element diagramGroupNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("DiagramGroup");
                                    SvgUpdateHandler.this.resizeCanvas(svgRoot, diagramGroupNode, false);
                                }
                            }
                            svgUpdateHandler = SvgUpdateHandler.this;
                            // MONITORENTER : svgUpdateHandler
                            continueUpdating = SvgUpdateHandler.this.dragUpdateRequired;
                            if (!continueUpdating) {
                                SvgUpdateHandler.this.threadRunning = false;
                            }
                            // MONITOREXIT : svgUpdateHandler
                        }
                    }
                    catch (OldFormatException exception) {
                        SvgUpdateHandler svgUpdateHandler = SvgUpdateHandler.this;
                        // MONITORENTER : svgUpdateHandler
                        SvgUpdateHandler.this.threadRunning = false;
                        // MONITOREXIT : svgUpdateHandler
                        if (SvgUpdateHandler.this.oldFormatWarningShown) break block19;
                        SvgUpdateHandler.this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Old or erroneous format detected");
                        SvgUpdateHandler.this.oldFormatWarningShown = true;
                    }
                }
                SvgUpdateHandler.this.graphPanel.setRequiresSave();
            }
        };
    }

    private void resizeCanvas(Element svgRoot, Element diagramGroupNode, boolean resetZoom) {
        int emptyBorder;
        System.out.println("resetZoom: " + resetZoom);
        if (resetZoom) {
            AffineTransform at = new AffineTransform();
            at.scale(1.0, 1.0);
            at.setToTranslation(1.0, 1.0);
            this.graphPanel.svgCanvas.setRenderingTransform(at);
        }
        Rectangle graphSize = this.graphPanel.dataStoreSvg.graphData.getGraphSize(this.graphPanel.entitySvg.entityPositions);
        diagramGroupNode.removeAttribute("transform");
        System.out.println("graphSize: " + graphSize);
        svgRoot.removeAttribute("width");
        svgRoot.removeAttribute("height");
        int maxAutoScale = 2;
        Rectangle panelBounds = this.graphPanel.svgCanvas.getBounds();
        int horizontalGap = panelBounds.width / 2 - graphSize.width;
        int verticalGap = panelBounds.height / 2 - graphSize.height;
        int n = emptyBorder = horizontalGap < verticalGap ? horizontalGap : verticalGap;
        if (emptyBorder < 0) {
            emptyBorder = 0;
        }
        svgRoot.setAttribute("viewBox", graphSize.x - 5 - emptyBorder + " " + (graphSize.y - 5 - emptyBorder) + " " + (graphSize.width + 10 + emptyBorder * 2) + " " + (graphSize.height + 10 + emptyBorder * 2));
        if (this.graphPanel.dataStoreSvg.showDiagramBorder) {
            Element pageBorderNode = this.graphPanel.doc.getElementById("PageBorder");
            if (pageBorderNode == null) {
                pageBorderNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "rect");
                pageBorderNode.setAttribute("id", "PageBorder");
                pageBorderNode.setAttribute("x", Float.toString(graphSize.x + 2 - emptyBorder));
                pageBorderNode.setAttribute("y", Float.toString(graphSize.y + 2 - emptyBorder));
                pageBorderNode.setAttribute("width", Float.toString(graphSize.width - 4 + emptyBorder * 2));
                pageBorderNode.setAttribute("height", Float.toString(graphSize.height - 4 + emptyBorder * 2));
                pageBorderNode.setAttribute("fill", "none");
                pageBorderNode.setAttribute("stroke-width", "2");
                pageBorderNode.setAttribute("stroke", "grey");
                diagramGroupNode.appendChild(pageBorderNode);
            } else {
                pageBorderNode.setAttribute("x", Float.toString(graphSize.x + 2 - emptyBorder));
                pageBorderNode.setAttribute("y", Float.toString(graphSize.y + 2 - emptyBorder));
                pageBorderNode.setAttribute("width", Float.toString(graphSize.width - 4 + emptyBorder * 2));
                pageBorderNode.setAttribute("height", Float.toString(graphSize.height - 4 + emptyBorder * 2));
            }
        } else {
            Element pageBorderNode = this.graphPanel.doc.getElementById("PageBorder");
            if (pageBorderNode != null) {
                pageBorderNode.getParentNode().removeChild(pageBorderNode);
            }
        }
    }

    public void requestResize() {
        this.resizeRequired = true;
        this.updateCanvasSize(true);
    }

    public void updateCanvasSize(final boolean resetZoom) {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SvgUpdateHandler.this.resizeRequired) {
                        SvgUpdateHandler.this.resizeRequired = false;
                        Element svgRoot = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getDocumentElement();
                        Element diagramGroupNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("DiagramGroup");
                        SvgUpdateHandler.this.resizeCanvas(svgRoot, diagramGroupNode, resetZoom);
                    }
                }
            });
        }
    }

    public void deleteGraphics(UniqueIdentifier uniqueIdentifier) {
        final Element graphicsElement = this.graphPanel.doc.getElementById(uniqueIdentifier.getAttributeIdentifier());
        final Element existingHighlight = this.graphPanel.doc.getElementById("highlight_" + uniqueIdentifier.getAttributeIdentifier());
        final Node parentElement = graphicsElement.getParentNode();
        this.graphPanel.entitySvg.entityPositions.remove(uniqueIdentifier);
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    parentElement.removeChild(graphicsElement);
                    if (existingHighlight != null) {
                        existingHighlight.getParentNode().removeChild(existingHighlight);
                    }
                    SvgUpdateHandler.this.graphPanel.setRequiresSave();
                }
            });
        }
    }

    public void addGraphics(final GraphicsTypes graphicsType, final Point locationOnScreen) {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Element labelText;
                    switch (graphicsType) {
                        case Circle: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "circle");
                            labelText.setAttribute("r", "100");
                            labelText.setAttribute("fill", "#ffffff");
                            labelText.setAttribute("stroke", "#000000");
                            labelText.setAttribute("stroke-width", "2");
                            break;
                        }
                        case Ellipse: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "ellipse");
                            labelText.setAttribute("rx", "100");
                            labelText.setAttribute("ry", "100");
                            labelText.setAttribute("fill", "#ffffff");
                            labelText.setAttribute("stroke", "#000000");
                            labelText.setAttribute("stroke-width", "2");
                            break;
                        }
                        case Label: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "text");
                            labelText.setAttribute("fill", "#000000");
                            labelText.setAttribute("stroke-width", "0");
                            labelText.setAttribute("font-size", "28");
                            Text textNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createTextNode("Label");
                            labelText.appendChild(textNode);
                            break;
                        }
                        case Polyline: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "polyline");
                            break;
                        }
                        case Square: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "rect");
                            labelText.setAttribute("width", "100");
                            labelText.setAttribute("height", "100");
                            labelText.setAttribute("fill", "#ffffff");
                            labelText.setAttribute("stroke", "#000000");
                            labelText.setAttribute("stroke-width", "2");
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    UniqueIdentifier labelId = new UniqueIdentifier(UniqueIdentifier.IdentifierType.gid);
                    labelText.setAttribute("id", labelId.getAttributeIdentifier());
                    Element targetGroup = graphicsType.equals((Object)GraphicsTypes.Label) ? ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("LabelsGroup") : ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("GraphicsGroup");
                    SVGOMPoint pointOnDocument = SvgUpdateHandler.this.getPointOnDocument(locationOnScreen, (SVGLocatable)targetGroup);
                    Point labelPosition = new Point((int)pointOnDocument.getX(), (int)pointOnDocument.getY());
                    String transformAttribute = "translate(" + Integer.toString(labelPosition.x) + ", " + Integer.toString(labelPosition.y) + ")";
                    System.out.println("transformAttribute:" + transformAttribute);
                    labelText.setAttribute("transform", transformAttribute);
                    targetGroup.appendChild(labelText);
                    ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.entitySvg.entityPositions.put(labelId, new Point(labelPosition));
                    ((EventTarget)((Object)labelText)).addEventListener("mousedown", ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.mouseListenerSvg, false);
                    SvgUpdateHandler.this.resizeCanvas(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getDocumentElement(), ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("DiagramGroup"), false);
                }
            });
        }
    }

    public void updateEntities(final boolean resetZoom) {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SvgUpdateHandler.this.drawEntities(resetZoom);
                }
            });
        } else {
            this.drawEntities(resetZoom);
        }
    }

    public void drawEntities(boolean resetZoom) {
        this.graphPanel.dataStoreSvg.graphData.setPadding(this.graphPanel.graphPanelSize);
        this.relationRecords = new RelationRecordTable();
        int vSpacing = this.graphPanel.graphPanelSize.getVerticalSpacing();
        int hSpacing = this.graphPanel.graphPanelSize.getHorizontalSpacing();
        try {
            Element labelsGroup;
            this.removeRelationHighLights();
            Element svgRoot = this.graphPanel.doc.getDocumentElement();
            Element diagramGroupNode = this.graphPanel.doc.getElementById("DiagramGroup");
            if (diagramGroupNode == null) {
                diagramGroupNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
                diagramGroupNode.setAttribute("id", "DiagramGroup");
                svgRoot.appendChild(diagramGroupNode);
            }
            if ((labelsGroup = this.graphPanel.doc.getElementById("LabelsGroup")) == null) {
                labelsGroup = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
                labelsGroup.setAttribute("id", "LabelsGroup");
                diagramGroupNode.appendChild(labelsGroup);
            } else if (!labelsGroup.getParentNode().equals(diagramGroupNode)) {
                labelsGroup.getParentNode().removeChild(labelsGroup);
                diagramGroupNode.appendChild(labelsGroup);
            }
            Element relationGroupNodeOld = this.graphPanel.doc.getElementById("RelationGroup");
            Element entityGroupNodeOld = this.graphPanel.doc.getElementById("EntityGroup");
            Element relationGroupNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
            relationGroupNode.setAttribute("id", "RelationGroup");
            diagramGroupNode.insertBefore(relationGroupNode, labelsGroup);
            if (relationGroupNodeOld != null) {
                relationGroupNodeOld.getParentNode().removeChild(relationGroupNodeOld);
            }
            Element entityGroupNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
            entityGroupNode.setAttribute("id", "EntityGroup");
            diagramGroupNode.insertBefore(entityGroupNode, labelsGroup);
            if (entityGroupNodeOld != null) {
                entityGroupNodeOld.getParentNode().removeChild(entityGroupNodeOld);
            }
            this.graphPanel.dataStoreSvg.graphData.placeAllNodes(this.graphPanel.entitySvg.entityPositions);
            this.resizeCanvas(svgRoot, diagramGroupNode, resetZoom);
            this.graphPanel.dataStoreSvg.storeAllData(this.graphPanel.doc);
            for (EntityData currentNode : this.graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                if (!currentNode.isVisible) continue;
                entityGroupNode.appendChild(this.graphPanel.entitySvg.createEntitySymbol(this.graphPanel, currentNode));
            }
            for (EntityData currentNode : this.graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                if (!currentNode.isVisible) continue;
                for (EntityRelation graphLinkNode : currentNode.getAllRelations()) {
                    if (!this.graphPanel.dataStoreSvg.showKinTermLines && graphLinkNode.getRelationType() == DataTypes.RelationType.kinterm || !this.graphPanel.dataStoreSvg.showSanguineLines && DataTypes.isSanguinLine(graphLinkNode.getRelationType()) || graphLinkNode.getAlterNode() == null || !graphLinkNode.getAlterNode().isVisible) continue;
                    try {
                        this.relationRecords.addRecord(this.graphPanel, currentNode, graphLinkNode, hSpacing, vSpacing, 2);
                    }
                    catch (OldFormatException exception) {
                        if (this.oldFormatWarningShown) continue;
                        this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Old or erroneous format detected");
                        this.oldFormatWarningShown = true;
                    }
                }
            }
            new RelationSvg(this.dialogHandler).createRelationElements(this.graphPanel, this.relationRecords, relationGroupNode);
        }
        catch (DOMException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "SVG Error");
        }
        catch (OldFormatException exception) {
            this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Old or erroneous format detected");
        }
        catch (GraphSorter.UnsortablePointsException exception) {
            this.dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Error, the graph is unsortable.");
        }
        this.graphPanel.svgCanvas.repaint();
    }

    public static enum GraphicsTypes {
        Label,
        Circle,
        Square,
        Polyline,
        Ellipse;

    }
}

