/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.entityindexer.IndexerParam;
import nl.mpi.kinnate.entityindexer.ParameterElement;
import nl.mpi.kinnate.ui.TableCellDragHandler;

public class FieldSelectionList
extends JPanel {
    private SavePanel savePanel;
    private JPanel paddingPanel;
    protected IndexerParam indexerParam;
    private final EntityCollection entityCollection;

    public FieldSelectionList(EntityCollection entityCollection, SavePanel savePanelLocal, IndexerParam indexerParamLocal, TableCellDragHandler tableCellDragHandler) {
        this.entityCollection = entityCollection;
        this.paddingPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.paddingPanel, "First");
        this.savePanel = savePanelLocal;
        this.indexerParam = indexerParamLocal;
        this.populateSelectionList();
        this.setTransferHandler(tableCellDragHandler);
    }

    private void populateSelectionList() {
        JComboBox<String> fieldSelect;
        this.paddingPanel.setLayout(new BoxLayout(this.paddingPanel, 3));
        this.paddingPanel.removeAll();
        for (final ParameterElement parameterElement : this.indexerParam.getValues()) {
            final JTextField fieldPathLabel = new JTextField(parameterElement.getXpathString());
            fieldPathLabel.setBackground(this.paddingPanel.getBackground());
            JPanel fieldPanel = new JPanel();
            fieldPanel.setLayout(new BoxLayout(fieldPanel, 2));
            fieldPanel.add(fieldPathLabel);
            fieldPanel.add(new JPanel());
            if (parameterElement.hasSelectedValue()) {
                String[] availableValues = this.indexerParam.getAvailableValues();
                if (availableValues != null) {
                    JComboBox<String> valueSelect = new JComboBox<String>(availableValues);
                    valueSelect.setSelectedItem(parameterElement.getSelectedValue());
                    valueSelect.setActionCommand(parameterElement.getXpathString());
                    fieldPanel.add(valueSelect);
                    valueSelect.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            parameterElement.setSelectedValue(((JComboBox)evt.getSource()).getSelectedItem().toString());
                            FieldSelectionList.this.indexerParam.setChangedFlag();
                            FieldSelectionList.this.populateSelectionList();
                            FieldSelectionList.this.revalidate();
                            FieldSelectionList.this.savePanel.updateGraph();
                            FieldSelectionList.this.savePanel.requiresSave();
                        }
                    });
                } else {
                    JTextField valueField = new JTextField(parameterElement.getSelectedValue());
                    fieldPanel.add(valueField);
                }
            }
            fieldPathLabel.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent fe) {
                    fieldPathLabel.setBackground(Color.WHITE);
                }

                @Override
                public void focusLost(FocusEvent fe) {
                    if (!parameterElement.getXpathString().equals(fieldPathLabel.getText())) {
                        parameterElement.setXpathString(fieldPathLabel.getText());
                        FieldSelectionList.this.indexerParam.setChangedFlag();
                        FieldSelectionList.this.populateSelectionList();
                        FieldSelectionList.this.revalidate();
                        FieldSelectionList.this.savePanel.updateGraph();
                        FieldSelectionList.this.savePanel.requiresSave();
                    }
                    fieldPathLabel.setBackground(FieldSelectionList.this.paddingPanel.getBackground());
                }
            });
            JButton removeButton = new JButton("x");
            removeButton.setToolTipText("delete item");
            int removeButtonSize = removeButton.getFontMetrics(removeButton.getFont()).getHeight();
            removeButton.setPreferredSize(new Dimension(removeButtonSize, removeButtonSize));
            removeButton.setActionCommand(parameterElement.getXpathString());
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FieldSelectionList.this.indexerParam.removeValue(parameterElement);
                    FieldSelectionList.this.populateSelectionList();
                    FieldSelectionList.this.revalidate();
                    FieldSelectionList.this.savePanel.updateGraph();
                    FieldSelectionList.this.savePanel.requiresSave();
                }
            });
            fieldPanel.add(removeButton);
            this.paddingPanel.add(fieldPanel);
        }
        final String[] availableValues = this.indexerParam.getAvailableValues();
        JPanel addPanel = new JPanel();
        addPanel.setLayout(new BoxLayout(addPanel, 2));
        try {
            fieldSelect = new JComboBox<String>(this.entityCollection.getAllFieldNames());
            addPanel.add(fieldSelect);
        }
        catch (EntityServiceException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            fieldSelect = new JComboBox<String>(new String[]{"<Error Getting Field Names>"});
            addPanel.add(fieldSelect);
        }
        final JComboBox<String> fieldSelectComboBox = fieldSelect;
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String initialValue = null;
                if (availableValues != null) {
                    initialValue = availableValues.length > 0 ? availableValues[0] : "";
                }
                String initialParameter = String.format(FieldSelectionList.this.indexerParam.getDefaultValueFormat(), fieldSelectComboBox.getSelectedItem().toString());
                FieldSelectionList.this.indexerParam.setValue(initialParameter, initialValue);
                FieldSelectionList.this.populateSelectionList();
                FieldSelectionList.this.revalidate();
                FieldSelectionList.this.savePanel.updateGraph();
                FieldSelectionList.this.savePanel.requiresSave();
            }
        });
        addPanel.add(addButton);
        addPanel.add(new JPanel());
        this.paddingPanel.add(addPanel);
        this.paddingPanel.add(new JPanel());
        if (availableValues != null) {
            JPanel defaultValuePanel = new JPanel();
            defaultValuePanel.setLayout(new BoxLayout(defaultValuePanel, 2));
            defaultValuePanel.add(new JLabel("Default Symbol"));
            final JComboBox<String> defaultSymbolComboBox = new JComboBox<String>(availableValues);
            String currentDefault = this.savePanel.getGraphPanel().dataStoreSvg.defaultSymbol;
            for (String currentValue : availableValues) {
                if (!currentValue.equals(currentDefault)) continue;
                defaultSymbolComboBox.setSelectedItem(currentValue);
            }
            defaultSymbolComboBox.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ((FieldSelectionList)FieldSelectionList.this).savePanel.getGraphPanel().dataStoreSvg.defaultSymbol = defaultSymbolComboBox.getSelectedItem().toString();
                    FieldSelectionList.this.savePanel.updateGraph();
                    FieldSelectionList.this.savePanel.requiresSave();
                }
            });
            defaultValuePanel.add(defaultSymbolComboBox);
            defaultValuePanel.add(new JPanel());
            this.paddingPanel.add(defaultValuePanel);
        }
    }

    protected void updateUiList() {
        this.populateSelectionList();
        this.revalidate();
        this.savePanel.updateGraph();
        this.savePanel.requiresSave();
    }
}

